/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.render;

import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.component.ChatOption;
import com.zhenshiz.chatbox.event.fabric.ChatBoxRenderEvent;
import com.zhenshiz.chatbox.event.fabric.InputEvent;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.chatbox.RenderUtil;
import com.zhenshiz.chatbox.utils.common.CollUtil;
import java.util.ArrayList;
import java.util.Comparator;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9779;

public class ChatBoxRender
implements HudRenderCallback,
ClientTickEvents.EndTick,
InputEvent.Key,
InputEvent.MouseButton.Post,
InputEvent.MouseScrollingEvent {
    public static Boolean isOpenChatBox = false;
    public static int selectIndex = 0;
    private static final class_310 minecraft = class_310.method_1551();

    public void onHudRender(class_332 guiGraphics, class_9779 deltaTracker) {
        float partialTick = deltaTracker.method_60636();
        if (ChatBoxRender.isRenderChatBox()) {
            if (((ChatBoxRenderEvent.Pre)ChatBoxRenderEvent.PRE.invoker()).pre(guiGraphics)) {
                return;
            }
            if (ChatBoxUtil.chatBoxScreen.backgroundImage != null) {
                RenderUtil.renderImage(guiGraphics, ChatBoxUtil.chatBoxScreen.backgroundImage, 0.0f, 0.0f, RenderUtil.screenWidth(), RenderUtil.screenHeight(), 1.0f, 100.0f, 0.0f);
            }
            ArrayList<AbstractComponent> list = new ArrayList<AbstractComponent>();
            list.add(ChatBoxUtil.chatBoxScreen.dialogBox);
            if (ChatBoxUtil.chatBoxScreen.video != null) {
                list.add(ChatBoxUtil.chatBoxScreen.video);
            }
            if (ChatBoxUtil.chatBoxScreen.chatOptions != null) {
                list.addAll(ChatBoxUtil.chatBoxScreen.chatOptions);
            }
            if (ChatBoxUtil.chatBoxScreen.portraits != null) {
                list.addAll(ChatBoxUtil.chatBoxScreen.portraits);
            }
            if (ChatBoxUtil.chatBoxScreen.keyPromptRender != null) {
                list.add(ChatBoxUtil.chatBoxScreen.keyPromptRender);
            }
            list.sort(Comparator.comparingInt(p -> p.renderOrder));
            list.forEach(abstractComponent -> abstractComponent.render(guiGraphics, partialTick));
            ((ChatBoxRenderEvent.Post)ChatBoxRenderEvent.POST.invoker()).post(guiGraphics);
        }
    }

    public void onEndTick(class_310 minecraft) {
        if (ChatBoxRender.isRenderChatBox()) {
            ChatBoxUtil.chatBoxScreen.method_25393();
        }
    }

    @Override
    public void onKey(int key, int scancode, int action, int modifiers) {
        if (ChatBoxRender.isRenderChatBox() && ChatBoxUtil.chatBoxScreen.keyPromptRender.visible.booleanValue()) {
            if (key == 341) {
                ChatBoxUtil.chatBoxScreen.dialogBox.click(ChatBoxUtil.chatBoxScreen.shouldGotoNext());
            }
            if (action == 1 && key == 295) {
                ChatBoxUtil.chatBoxScreen.autoPlay = !ChatBoxUtil.chatBoxScreen.autoPlay;
            }
        }
    }

    @Override
    public void mousePost(int button, int action, int modifiers) {
        if (ChatBoxRender.isRenderChatBox() && action == 1 && button == 1) {
            if (!CollUtil.isEmpty(ChatBoxUtil.chatBoxScreen.chatOptions).booleanValue() && ChatBoxUtil.chatBoxScreen.dialogBox.isAllOver) {
                ChatOption chatOption = ChatBoxUtil.chatBoxScreen.chatOptions.get(selectIndex);
                chatOption.click();
                selectIndex = 0;
            }
            if (ChatBoxUtil.chatBoxScreen.keyPromptRender.visible.booleanValue()) {
                ChatBoxUtil.chatBoxScreen.dialogBox.click(ChatBoxUtil.chatBoxScreen.shouldGotoNext());
            }
        }
    }

    @Override
    public boolean onMouseScroll(double scrollDeltaX, double scrollDeltaY, boolean leftDown, boolean middleDown, boolean rightDown, double mouseX, double mouseY) {
        if (ChatBoxRender.isRenderChatBox() && !ChatBoxUtil.chatBoxScreen.chatOptions.isEmpty()) {
            if (scrollDeltaY > 0.0) {
                selectIndex = (selectIndex - 1 + ChatBoxUtil.chatBoxScreen.chatOptions.size()) % ChatBoxUtil.chatBoxScreen.chatOptions.size();
            } else if (scrollDeltaY < 0.0) {
                selectIndex = (selectIndex + 1) % ChatBoxUtil.chatBoxScreen.chatOptions.size();
            }
            for (int i = 0; i < ChatBoxUtil.chatBoxScreen.chatOptions.size(); ++i) {
                ChatOption chatOption = ChatBoxUtil.chatBoxScreen.chatOptions.get(i);
                chatOption.isSelect = i == selectIndex;
            }
            return true;
        }
        return false;
    }

    private static boolean isRenderChatBox() {
        return !ChatBoxUtil.isScreen && isOpenChatBox != false && ChatBoxRender.minecraft.field_1755 == null && ChatBoxUtil.chatBoxScreen.dialogBox != null;
    }

    public static void onClose() {
        isOpenChatBox = false;
        ChatBoxUtil.chatBoxScreen.autoPlay = false;
        ChatBoxUtil.chatBoxScreen.fastForward = false;
        if (ChatBoxUtil.chatBoxScreen.video != null) {
            ChatBoxUtil.chatBoxScreen.video.close();
        }
    }
}

