/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.utils.chatbox;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.zhenshiz.chatbox.data.ChatBoxTheme;
import com.zhenshiz.chatbox.utils.chatbox.FloatBlitRenderState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import net.minecraft.class_1041;
import net.minecraft.class_1068;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_5348;
import net.minecraft.class_7532;
import net.minecraft.class_8030;
import net.minecraft.class_8685;
import net.minecraft.class_9296;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import org.lwjgl.glfw.GLFW;

public class RenderUtil {
    private static final class_310 minecraft = class_310.method_1551();
    private static final Map<String, class_8685> skins = new HashMap<String, class_8685>();

    public static int screenWidth() {
        return minecraft.method_22683().method_4486();
    }

    public static int screenHeight() {
        return minecraft.method_22683().method_4502();
    }

    private static void submitSimpleGuiElement(final class_332 guiGraphics, final BiConsumer<class_4588, Float> builder, final @Nullable class_8030 bounds) {
        guiGraphics.field_59826.method_70919(new class_11244(){

            public void method_70917(class_4588 consumer, float z) {
                builder.accept(consumer, Float.valueOf(z));
            }

            @NotNull
            public RenderPipeline comp_4055() {
                return class_10799.field_56879;
            }

            @NotNull
            public class_11231 comp_4056() {
                return class_11231.method_70899();
            }

            @Nullable
            public class_8030 comp_4069() {
                return guiGraphics.field_44659.method_70863();
            }

            @Nullable
            public class_8030 comp_4274() {
                return bounds;
            }
        });
    }

    public static void fillRect(class_332 guiGraphics, int x, int y, int w, int h, int color) {
        guiGraphics.method_25294(x, y, x + w, y + h, color);
    }

    public static void fillArc(class_332 guiGraphics, int cX, int cY, int radius, int start, int end, int color) {
        RenderUtil.submitSimpleGuiElement(guiGraphics, (consumer, z) -> {
            Matrix3x2fStack pose = guiGraphics.method_51448();
            consumer.method_70815((Matrix3x2f)pose, (float)cX, (float)cY, z.floatValue()).method_39415(color);
            for (int i = start - 90; i <= end - 90; ++i) {
                double angle = Math.toRadians(i);
                float x = (float)(Math.cos(angle) * (double)radius) + (float)cX;
                float y = (float)(Math.sin(angle) * (double)radius) + (float)cY;
                consumer.method_70815((Matrix3x2f)pose, x, y, z.floatValue()).method_39415(color);
            }
        }, new class_8030(cX - radius, cY - radius, 2 * radius, 2 * radius));
    }

    public static void fillCircle(class_332 guiGraphics, int cX, int cY, int radius, int color) {
        RenderUtil.fillArc(guiGraphics, cX, cY, radius, 0, 360, color);
    }

    public static void fillAnnulusArc(class_332 guiGraphics, int cx, int cy, int radius, int start, int end, int thickness, int color) {
        RenderUtil.submitSimpleGuiElement(guiGraphics, (consumer, z) -> {
            Matrix3x2fStack pose = guiGraphics.method_51448();
            for (int i = start - 90; i <= end - 90; ++i) {
                float angle = (float)Math.toRadians(i);
                float cos = (float)Math.cos(angle);
                float sin = (float)Math.sin(angle);
                float x1 = (float)cx + cos * (float)radius;
                float y1 = (float)cy + sin * (float)radius;
                float x2 = (float)cx + cos * (float)(radius + thickness);
                float y2 = (float)cy + sin * (float)(radius + thickness);
                consumer.method_70815((Matrix3x2f)pose, x1, y1, z.floatValue()).method_39415(color);
                consumer.method_70815((Matrix3x2f)pose, x2, y2, z.floatValue()).method_39415(color);
            }
        }, new class_8030(cx - radius, cy - radius, 2 * radius, 2 * radius));
    }

    public static void fillAnnulus(class_332 guiGraphics, int cx, int cy, int radius, int thickness, int color) {
        RenderUtil.fillAnnulusArc(guiGraphics, cx, cy, radius, 0, 360, thickness, color);
    }

    public static void fillRoundRect(class_332 guiGraphics, int x, int y, int w, int h, int r, int color) {
        int finalR = r = class_3532.method_15340((int)r, (int)0, (int)(Math.min(w, h) / 2));
        RenderUtil.submitSimpleGuiElement(guiGraphics, (consumer, z) -> {
            Matrix3x2fStack pose = guiGraphics.method_51448();
            consumer.method_70815((Matrix3x2f)pose, (float)x + (float)w / 2.0f, (float)y + (float)h / 2.0f, 0.0f).method_39415(color);
            int[][] corners = new int[][]{{x + w - finalR, y + finalR}, {x + w - finalR, y + h - finalR}, {x + finalR, y + h - finalR}, {x + finalR, y + finalR}};
            for (int corner = 0; corner < 4; ++corner) {
                int cornerStart = (corner - 1) * 90;
                int cornerEnd = cornerStart + 90;
                for (int i = cornerStart; i <= cornerEnd; i += 10) {
                    float angle = (float)Math.toRadians(i);
                    float rx = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)finalR);
                    float ry = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)finalR);
                    consumer.method_70815((Matrix3x2f)pose, rx, ry, 0.0f).method_39415(color);
                }
            }
            consumer.method_70815((Matrix3x2f)pose, (float)corners[0][0], (float)y, 0.0f).method_39415(color);
        }, new class_8030(x, y, w, h));
    }

    public static void fillRoundShadow(class_332 guiGraphics, int x, int y, int w, int h, int r, int thickness, int innerColor, int outerColor) {
        int finalR = r = class_3532.method_15340((int)r, (int)0, (int)(Math.min(w, h) / 2));
        RenderUtil.submitSimpleGuiElement(guiGraphics, (consumer, z) -> {
            Matrix3x2fStack pose = guiGraphics.method_51448();
            int[][] corners = new int[][]{{x + w - finalR, y + finalR}, {x + w - finalR, y + h - finalR}, {x + finalR, y + h - finalR}, {x + finalR, y + finalR}};
            for (int corner = 0; corner < 4; ++corner) {
                int cornerStart = (corner - 1) * 90;
                int cornerEnd = cornerStart + 90;
                for (int i = cornerStart; i <= cornerEnd; i += 10) {
                    float angle = (float)Math.toRadians(i);
                    float rx1 = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)finalR);
                    float ry1 = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)finalR);
                    float rx2 = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)(finalR + thickness));
                    float ry2 = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)(finalR + thickness));
                    consumer.method_70815((Matrix3x2f)pose, rx1, ry1, 0.0f).method_39415(innerColor);
                    consumer.method_70815((Matrix3x2f)pose, rx2, ry2, 0.0f).method_39415(outerColor);
                }
            }
            consumer.method_70815((Matrix3x2f)pose, (float)corners[0][0], (float)y, 0.0f).method_39415(innerColor);
            consumer.method_70815((Matrix3x2f)pose, (float)corners[0][0], (float)(y - thickness), 0.0f).method_39415(outerColor);
        }, new class_8030(x, y, w, h));
    }

    public static void fillRoundTabTop(class_332 guiGraphics, int x, int y, int w, int h, int r, int color) {
        int finalR = r = class_3532.method_15340((int)r, (int)0, (int)(Math.min(w, h) / 2));
        RenderUtil.submitSimpleGuiElement(guiGraphics, (consumer, z) -> {
            Matrix3x2fStack pose = guiGraphics.method_51448();
            consumer.method_70815((Matrix3x2f)pose, (float)x + (float)w / 2.0f, (float)y + (float)h / 2.0f, 0.0f).method_39415(color);
            int[][] corners = new int[][]{{x + finalR, y + finalR}, {x + w - finalR, y + finalR}};
            for (int corner = 0; corner < 2; ++corner) {
                int cornerStart = (corner - 2) * 90;
                int cornerEnd = cornerStart + 90;
                for (int i = cornerStart; i <= cornerEnd; i += 10) {
                    float angle = (float)Math.toRadians(i);
                    float rx = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)finalR);
                    float ry = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)finalR);
                    consumer.method_70815((Matrix3x2f)pose, rx, ry, 0.0f).method_39415(color);
                }
            }
            consumer.method_70815((Matrix3x2f)pose, (float)(x + w), (float)(y + h), 0.0f).method_39415(color);
            consumer.method_70815((Matrix3x2f)pose, (float)x, (float)(y + h), 0.0f).method_39415(color);
            consumer.method_70815((Matrix3x2f)pose, (float)x, (float)corners[0][1], 0.0f).method_39415(color);
        }, new class_8030(x, y, w, h));
    }

    public static void fillRoundTabBottom(class_332 guiGraphics, int x, int y, int w, int h, int r, int color) {
        int finalR = r = class_3532.method_15340((int)r, (int)0, (int)(Math.min(w, h) / 2));
        RenderUtil.submitSimpleGuiElement(guiGraphics, (consumer, z) -> {
            Matrix3x2fStack pose = guiGraphics.method_51448();
            consumer.method_70815((Matrix3x2f)pose, (float)x + (float)w / 2.0f, (float)y + (float)h / 2.0f, 0.0f).method_39415(color);
            int[][] corners = new int[][]{{x + w - finalR, y + h - finalR}, {x + finalR, y + h - finalR}};
            for (int corner = 0; corner < 2; ++corner) {
                int cornerStart = corner * 90;
                int cornerEnd = cornerStart + 90;
                for (int i = cornerStart; i <= cornerEnd; i += 10) {
                    float angle = (float)Math.toRadians(i);
                    float rx = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)finalR);
                    float ry = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)finalR);
                    consumer.method_70815((Matrix3x2f)pose, rx, ry, 0.0f).method_39415(color);
                }
            }
            consumer.method_70815((Matrix3x2f)pose, (float)x, (float)y, 0.0f).method_39415(color);
            consumer.method_70815((Matrix3x2f)pose, (float)(x + w), (float)y, 0.0f).method_39415(color);
            consumer.method_70815((Matrix3x2f)pose, (float)(x + w), (float)corners[0][1], 0.0f).method_39415(color);
        }, new class_8030(x, y, w, h));
    }

    public static void fillRoundHorLine(class_332 guiGraphics, int x, int y, int length, int thickness, int color) {
        RenderUtil.fillRoundRect(guiGraphics, x, y, length, thickness, thickness / 2, color);
    }

    public static void fillRoundVerLine(class_332 guiGraphics, int x, int y, int length, int thickness, int color) {
        RenderUtil.fillRoundRect(guiGraphics, x, y, thickness, length, thickness / 2, color);
    }

    public static void drawRect(class_332 guiGraphics, int x, int y, int w, int h, int color) {
        RenderUtil.drawHorLine(guiGraphics, x, y, w, color);
        RenderUtil.drawVerLine(guiGraphics, x, y + 1, h - 2, color);
        RenderUtil.drawVerLine(guiGraphics, x + w - 1, y + 1, h - 2, color);
        RenderUtil.drawHorLine(guiGraphics, x, y + h - 1, w, color);
    }

    public static void drawBox(class_332 guiGraphics, int x, int y, int w, int h, int color) {
        RenderUtil.drawLine(guiGraphics, x, y, x + w, y, color);
        RenderUtil.drawLine(guiGraphics, x, y + h, x + w, y + h, color);
        RenderUtil.drawLine(guiGraphics, x, y, x, y + h, color);
        RenderUtil.drawLine(guiGraphics, x + w, y, x + w, y + h, color);
    }

    public static void drawHorLine(class_332 guiGraphics, int x, int y, int length, int color) {
        RenderUtil.fillRect(guiGraphics, x, y, length, 1, color);
    }

    public static void drawVerLine(class_332 guiGraphics, int x, int y, int length, int color) {
        RenderUtil.fillRect(guiGraphics, x, y, 1, length, color);
    }

    public static void drawLine(class_332 guiGraphics, int x1, int y1, int x2, int y2, int color) {
        RenderUtil.submitSimpleGuiElement(guiGraphics, (consumer, z) -> {
            Matrix3x2fStack pose = guiGraphics.method_51448();
            consumer.method_70815((Matrix3x2f)pose, (float)x1, (float)y1, 0.0f).method_39415(color);
            consumer.method_70815((Matrix3x2f)pose, (float)x2, (float)y2, 0.0f).method_39415(color);
        }, new class_8030(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x1 - x2), Math.abs(y1 - y2)));
    }

    public static void drawArc(class_332 guiGraphics, int cX, int cY, int radius, int start, int end, int color) {
        RenderUtil.submitSimpleGuiElement(guiGraphics, (consumer, z) -> {
            Matrix3x2fStack pose = guiGraphics.method_51448();
            for (int i = start - 90; i <= end - 90; ++i) {
                double angle = Math.toRadians(i);
                float x = (float)(Math.cos(angle) * (double)radius) + (float)cX;
                float y = (float)(Math.sin(angle) * (double)radius) + (float)cY;
                consumer.method_70815((Matrix3x2f)pose, x, y, 0.0f).method_39415(color);
            }
        }, new class_8030(cX - radius, cY - radius, 2 * radius, 2 * radius));
    }

    public static void drawCircle(class_332 guiGraphics, int cX, int cY, int radius, int color) {
        RenderUtil.drawArc(guiGraphics, cX, cY, radius, 0, 360, color);
    }

    public static void drawRoundRect(class_332 guiGraphics, int x, int y, int w, int h, int r, int color) {
        int finalR = r = class_3532.method_15340((int)r, (int)0, (int)(Math.min(w, h) / 2));
        RenderUtil.submitSimpleGuiElement(guiGraphics, (consumer, z) -> {
            Matrix3x2fStack pose = guiGraphics.method_51448();
            int[][] corners = new int[][]{{x + w - finalR, y + finalR}, {x + w - finalR, y + h - finalR}, {x + finalR, y + h - finalR}, {x + finalR, y + finalR}};
            for (int corner = 0; corner < 4; ++corner) {
                int cornerStart = (corner - 1) * 90;
                int cornerEnd = cornerStart + 90;
                for (int i = cornerStart; i <= cornerEnd; i += 10) {
                    float angle = (float)Math.toRadians(i);
                    float rx = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)finalR);
                    float ry = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)finalR);
                    consumer.method_70815((Matrix3x2f)pose, rx, ry, 0.0f).method_39415(color);
                }
            }
            consumer.method_70815((Matrix3x2f)pose, (float)corners[0][0], (float)y, 0.0f).method_39415(color);
        }, new class_8030(x, y, w, h));
    }

    public static void drawRoundHorLine(class_332 guiGraphics, int x, int y, int length, int thickness, int color) {
        RenderUtil.drawRoundRect(guiGraphics, x, y, length, thickness, thickness / 2, color);
    }

    public static void drawRoundVerLine(class_332 guiGraphics, int x, int y, int length, int thickness, int color) {
        RenderUtil.drawRoundRect(guiGraphics, x, y, thickness, length, thickness / 2, color);
    }

    public static void renderImage(class_332 guiGraphics, Matrix3x2f pose, class_2960 resourceLocation, float x, float y, float uw, float uh, float width, float height, float opacity) {
        GpuTextureView view = minecraft.method_1531().method_4619(resourceLocation).method_71659();
        guiGraphics.field_59826.method_70919((class_11244)new FloatBlitRenderState(guiGraphics, class_10799.field_56883, class_11231.method_70900((GpuTextureView)view), pose, x, y, width, height, uw, uh, RenderUtil.getColor(opacity)));
    }

    public static void renderImage(class_332 guiGraphics, class_2960 resourceLocation, float x, float y, float width, float height, float scale, float opacity, float angle, List<ChatBoxTheme.Portrait.Attachment> attachments) {
        Matrix3x2f pose = new Matrix3x2f((Matrix3x2fc)guiGraphics.method_51448()).rotateAbout((float)Math.toRadians(angle), x + width / 2.0f, y + height / 2.0f).scale(scale);
        RenderUtil.renderImage(guiGraphics, pose, resourceLocation, x /= scale, y /= scale, 1.0f, 1.0f, width, height, opacity);
        for (ChatBoxTheme.Portrait.Attachment attachment : attachments) {
            ChatBoxTheme.Portrait.Attachment a = attachment.mapParameter();
            RenderUtil.renderImage(guiGraphics, pose, class_2960.method_60654((String)a.value), x + a.x.floatValue(), y + a.y.floatValue(), 1.0f, 1.0f, a.width.floatValue(), a.height.floatValue(), opacity);
        }
    }

    public static void renderImage(class_332 guiGraphics, class_2960 resourceLocation, float x, float y, float width, float height, float scale, float opacity, float angle) {
        RenderUtil.renderImage(guiGraphics, resourceLocation, x, y, width, height, scale, opacity, angle, List.of());
    }

    public static void renderPlayerHead(class_332 guiGraphics, String input, int x, int y, int size, float scale, float opacity, float angle) {
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().rotateAbout((float)Math.toRadians(angle), (float)x + (float)size / 2.0f, (float)y + (float)size / 2.0f);
        x = (int)((float)x / scale);
        y = (int)((float)y / scale);
        guiGraphics.method_51448().scale(scale, scale);
        class_7532.method_44443((class_332)guiGraphics, (class_8685)RenderUtil.getSkin(input), (int)x, (int)y, (int)size, (int)RenderUtil.getColor(opacity));
        guiGraphics.method_51448().popMatrix();
    }

    public static void renderItem(class_332 guiGraphics, class_1799 item, int x, int y, float scale, float angle, String text) {
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().rotateAbout((float)Math.toRadians(angle), (float)x + 8.0f, (float)y + 8.0f);
        x = (int)((float)x / scale);
        y = (int)((float)y / scale);
        guiGraphics.method_51448().scale(scale, scale);
        guiGraphics.method_51427(item, x, y);
        guiGraphics.method_51432(RenderUtil.minecraft.field_1772, item, x, y, text);
        guiGraphics.method_51448().popMatrix();
    }

    public static void renderItem(class_332 guiGraphics, class_1799 item, int x, int y, float scale, float angle) {
        RenderUtil.renderItem(guiGraphics, item, x, y, scale, angle, "");
    }

    public static void drawLeftScaleText(class_332 guiGraphics, class_2561 component, int x, int y, float scale, boolean shadow, int color) {
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        poseStack.scale(scale, scale);
        float rescale = 1.0f / scale;
        x = (int)((float)x * rescale);
        y = (int)((float)y * rescale);
        guiGraphics.method_51439(RenderUtil.minecraft.field_1772, component, x, y, color, shadow);
        poseStack.scale(rescale, rescale);
    }

    public static void drawCenterScaleText(class_332 guiGraphics, class_2561 component, int centerX, int y, float scale, boolean shadow, int color) {
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        poseStack.scale(scale, scale);
        float rescale = 1.0f / scale;
        centerX = (int)((float)centerX * rescale);
        y = (int)((float)y * rescale);
        guiGraphics.method_51439(RenderUtil.minecraft.field_1772, component, centerX -= RenderUtil.minecraft.field_1772.method_27525((class_5348)component) / 2, y, color, shadow);
        poseStack.scale(rescale, rescale);
    }

    public static void drawRightScaleText(class_332 guiGraphics, class_2561 component, int rightX, int y, float scale, boolean shadow, int color) {
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        poseStack.scale(scale, scale);
        float rescale = 1.0f / scale;
        rightX = (int)((float)rightX * rescale);
        y = (int)((float)y * rescale);
        guiGraphics.method_51439(RenderUtil.minecraft.field_1772, component, rightX -= RenderUtil.minecraft.field_1772.method_27525((class_5348)component), y, color, shadow);
        poseStack.scale(rescale, rescale);
    }

    public static void setCursor(int x, int y) {
        class_1041 window = minecraft.method_22683();
        int w1 = window.method_4489();
        int w2 = RenderUtil.screenWidth();
        int h1 = window.method_4506();
        int h2 = RenderUtil.screenHeight();
        double ratW = (double)w2 / (double)w1;
        double ratH = (double)h2 / (double)h1;
        GLFW.glfwSetCursorPos((long)window.method_4490(), (double)((double)x / ratW), (double)((double)y / ratH));
    }

    public static class_241 getCursor() {
        class_1041 window = minecraft.method_22683();
        int w1 = window.method_4489();
        int w2 = RenderUtil.screenWidth();
        int h1 = window.method_4506();
        int h2 = RenderUtil.screenHeight();
        double rW = (double)w2 / (double)w1;
        double rH = (double)h2 / (double)h1;
        return new class_241((float)((int)(rW * RenderUtil.minecraft.field_1729.method_1603())), (float)((int)(rH * RenderUtil.minecraft.field_1729.method_1604())));
    }

    public static int getColor(float opacity) {
        return class_9848.method_61324((int)((int)(opacity / 100.0f * 255.0f)), (int)255, (int)255, (int)255);
    }

    private static void handleGameProfileAsync(String input) {
        class_9296 component = RenderUtil.createProfileComponent(input);
        ((CompletableFuture)component.method_57507().thenApplyAsync(result -> {
            GameProfile profile = result.comp_2413();
            try {
                ((Optional)minecraft.method_1582().method_52863(profile).get()).ifPresent(playerSkin -> skins.put(input, (class_8685)playerSkin));
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
            return profile;
        })).exceptionally(ex -> null);
    }

    private static class_9296 createProfileComponent(String input) {
        try {
            UUID uuid = UUID.fromString(input);
            return new class_9296(Optional.empty(), Optional.of(uuid), new PropertyMap());
        }
        catch (IllegalArgumentException e) {
            return new class_9296(Optional.of(input), Optional.empty(), new PropertyMap());
        }
    }

    private static class_8685 getSkin(String input) {
        if (skins.containsKey(input)) {
            return skins.get(input);
        }
        RenderUtil.handleGameProfileAsync(input);
        if (skins.containsKey(input)) {
            return skins.get(input);
        }
        return class_1068.method_4648((UUID)minecraft.method_1548().method_44717());
    }
}

