/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.utils.common;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class BeanUtil {
    public static <T> T getValueOrDefault(T param, T defaultValue) {
        return Optional.ofNullable(param).orElse(defaultValue);
    }

    public static void copyPropertiesIfTargetNull(Object source, Object target) {
        BeanUtil.copyProperties(source, target, true);
    }

    public static void copyProperties(Object source, Object target) {
        BeanUtil.copyProperties(source, target, false);
    }

    private static void copyProperties(Object source, Object target, boolean onlyIfTargetNull) {
        if (source == null || target == null) {
            throw new IllegalArgumentException("Source and target objects cannot be null");
        }
        Class<?> sourceClass = source.getClass();
        Class<?> targetClass = target.getClass();
        Set<Field> sourceFields = BeanUtil.getAllFields(sourceClass);
        Set<Field> targetFields = BeanUtil.getAllFields(targetClass);
        for (Field targetField : targetFields) {
            try {
                Class<?> targetType;
                Field sourceField;
                Object targetValue;
                int modifiers = targetField.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
                targetField.setAccessible(true);
                if (onlyIfTargetNull && (targetValue = targetField.get(target)) != null || (sourceField = BeanUtil.findField(sourceFields, targetField.getName())) == null) continue;
                sourceField.setAccessible(true);
                Object sourceValue = sourceField.get(source);
                if (sourceValue == null) continue;
                Class<?> sourceType = sourceValue.getClass();
                if (BeanUtil.isCompatibleType(sourceType, targetType = targetField.getType())) {
                    targetField.set(target, sourceValue);
                    continue;
                }
                if (!BeanUtil.isWrapperType(sourceType, targetType)) continue;
                targetField.set(target, sourceValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error copying property: " + targetField.getName(), e);
            }
        }
    }

    private static Set<Field> getAllFields(Class<?> clazz) {
        HashSet<Field> fields = new HashSet<Field>();
        while (clazz != null && clazz != Object.class) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    private static Field findField(Set<Field> fields, String name) {
        for (Field field : fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    private static boolean isCompatibleType(Class<?> sourceType, Class<?> targetType) {
        return targetType.isAssignableFrom(sourceType);
    }

    private static boolean isWrapperType(Class<?> sourceType, Class<?> targetType) {
        if (sourceType.isPrimitive() || targetType.isPrimitive()) {
            if (sourceType.isPrimitive()) {
                Class<?> primitive = sourceType;
                Class<?> wrapper = BeanUtil.getWrapperType(primitive);
                return wrapper == targetType;
            }
            Class<?> primitive = targetType;
            Class<?> wrapper = sourceType;
            return BeanUtil.getWrapperType(primitive) == wrapper;
        }
        return false;
    }

    private static Class<?> getWrapperType(Class<?> primitiveType) {
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        return null;
    }
}

