/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.utils.math;

import java.lang.runtime.SwitchBootstraps;

public class EasingUtil {
    public static float easingFunction(float min, float max, double currentTime, double duration, Easing easing) {
        double progress = currentTime / duration;
        progress = Math.min(1.0, Math.max(0.0, progress));
        Easing easing2 = easing;
        int n = 0;
        double easedProgress = switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"EASE_IN_SINE", "EASE_OUT_SINE", "EASE_IN_OUT_SINE", "EASE_IN_QUAD", "EASE_OUT_QUAD", "EASE_IN_OUT_QUAD", "EASE_IN_CUBIC", "EASE_OUT_CUBIC", "EASE_IN_OUT_CUBIC", "EASE_IN_QUART", "EASE_OUT_QUART", "EASE_IN_OUT_QUART", "EASE_IN_QUINT", "EASE_OUT_QUINT", "EASE_IN_OUT_QUINT", "EASE_IN_EXPO", "EASE_OUT_EXPO", "EASE_IN_OUT_EXPO", "EASE_IN_CIRC", "EASE_OUT_CIRC", "EASE_IN_OUT_CIRC", "EASE_IN_BACK", "EASE_OUT_BACK", "EASE_IN_OUT_BACK", "EASE_IN_ELASTIC", "EASE_OUT_ELASTIC", "EASE_IN_OUT_ELASTIC", "EASE_IN_BOUNCE", "EASE_OUT_BOUNCE", "EASE_IN_OUT_BOUNCE"}, (Easing)easing2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> EasingUtil.easeInSine(progress);
            case 1 -> EasingUtil.easeOutSine(progress);
            case 2 -> EasingUtil.easeInOutSine(progress);
            case 3 -> EasingUtil.easeInQuad(progress);
            case 4 -> EasingUtil.easeOutQuad(progress);
            case 5 -> EasingUtil.easeInOutQuad(progress);
            case 6 -> EasingUtil.easeInCubic(progress);
            case 7 -> EasingUtil.easeOutCubic(progress);
            case 8 -> EasingUtil.easeInOutCubic(progress);
            case 9 -> EasingUtil.easeInQuart(progress);
            case 10 -> EasingUtil.easeOutQuart(progress);
            case 11 -> EasingUtil.easeInOutQuart(progress);
            case 12 -> EasingUtil.easeInQuint(progress);
            case 13 -> EasingUtil.easeOutQuint(progress);
            case 14 -> EasingUtil.easeInOutQuint(progress);
            case 15 -> EasingUtil.easeInExpo(progress);
            case 16 -> EasingUtil.easeOutExpo(progress);
            case 17 -> EasingUtil.easeInOutExpo(progress);
            case 18 -> EasingUtil.easeInCirc(progress);
            case 19 -> EasingUtil.easeOutCirc(progress);
            case 20 -> EasingUtil.easeInOutCirc(progress);
            case 21 -> EasingUtil.easeInBack(progress);
            case 22 -> EasingUtil.easeOutBack(progress);
            case 23 -> EasingUtil.easeInOutBack(progress);
            case 24 -> EasingUtil.easeInElastic(progress);
            case 25 -> EasingUtil.easeOutElastic(progress);
            case 26 -> EasingUtil.easeInOutElastic(progress);
            case 27 -> EasingUtil.easeInBounce(progress);
            case 28 -> EasingUtil.easeOutBounce(progress);
            case 29 -> EasingUtil.easeInOutBounce(progress);
            case -1 -> progress;
        };
        return (float)((double)min + (double)(max - min) * easedProgress);
    }

    private static double easeInSine(double x) {
        return 1.0 - Math.cos(x * Math.PI / 2.0);
    }

    private static double easeOutSine(double x) {
        return Math.sin(x * Math.PI / 2.0);
    }

    private static double easeInOutSine(double x) {
        return -(Math.cos(Math.PI * x) - 1.0) / 2.0;
    }

    private static double easeInQuad(double x) {
        return x * x;
    }

    private static double easeOutQuad(double x) {
        return 1.0 - (1.0 - x) * (1.0 - x);
    }

    private static double easeInOutQuad(double x) {
        return x < 0.5 ? 2.0 * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 2.0) / 2.0;
    }

    private static double easeInCubic(double x) {
        return x * x * x;
    }

    private static double easeOutCubic(double x) {
        return 1.0 - Math.pow(1.0 - x, 3.0);
    }

    private static double easeInOutCubic(double x) {
        return x < 0.5 ? 4.0 * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 3.0) / 2.0;
    }

    private static double easeInQuart(double x) {
        return x * x * x * x;
    }

    private static double easeOutQuart(double x) {
        return 1.0 - Math.pow(1.0 - x, 4.0);
    }

    private static double easeInOutQuart(double x) {
        return x < 0.5 ? 8.0 * x * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 4.0) / 2.0;
    }

    private static double easeInQuint(double x) {
        return x * x * x * x * x;
    }

    private static double easeOutQuint(double x) {
        return 1.0 - Math.pow(1.0 - x, 5.0);
    }

    private static double easeInOutQuint(double x) {
        return x < 0.5 ? 16.0 * x * x * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 5.0) / 2.0;
    }

    private static double easeInExpo(double x) {
        return x == 0.0 ? 0.0 : Math.pow(2.0, 10.0 * x - 10.0);
    }

    private static double easeOutExpo(double x) {
        return x == 1.0 ? 1.0 : 1.0 - Math.pow(2.0, -10.0 * x);
    }

    private static double easeInOutExpo(double x) {
        return x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : (x < 0.5 ? Math.pow(2.0, 20.0 * x - 10.0) / 2.0 : (2.0 - Math.pow(2.0, -20.0 * x + 10.0)) / 2.0));
    }

    private static double easeInCirc(double x) {
        return 1.0 - Math.sqrt(1.0 - Math.pow(x, 2.0));
    }

    private static double easeOutCirc(double x) {
        return Math.sqrt(1.0 - Math.pow(x - 1.0, 2.0));
    }

    private static double easeInOutCirc(double x) {
        return x < 0.5 ? (1.0 - Math.sqrt(1.0 - Math.pow(2.0 * x, 2.0))) / 2.0 : (Math.sqrt(1.0 - Math.pow(-2.0 * x + 2.0, 2.0)) + 1.0) / 2.0;
    }

    private static double easeInBack(double x) {
        double c1 = 1.70158;
        double c3 = c1 + 1.0;
        return c3 * x * x * x - c1 * x * x;
    }

    private static double easeOutBack(double x) {
        double c1 = 1.70158;
        double c3 = c1 + 1.0;
        return 1.0 + c3 * Math.pow(x - 1.0, 3.0) + c1 * Math.pow(x - 1.0, 2.0);
    }

    private static double easeInOutBack(double x) {
        double c1 = 1.70158;
        double c2 = c1 * 1.525;
        return x < 0.5 ? Math.pow(2.0 * x, 2.0) * ((c2 + 1.0) * 2.0 * x - c2) / 2.0 : (Math.pow(2.0 * x - 2.0, 2.0) * ((c2 + 1.0) * (x * 2.0 - 2.0) + c2) + 2.0) / 2.0;
    }

    private static double easeInElastic(double x) {
        double c4 = 2.0943951023931953;
        return x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : -Math.pow(2.0, 10.0 * x - 10.0) * Math.sin((x * 10.0 - 10.75) * c4));
    }

    private static double easeOutElastic(double x) {
        double c4 = 2.0943951023931953;
        return x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : Math.pow(2.0, -10.0 * x) * Math.sin((x * 10.0 - 0.75) * c4) + 1.0);
    }

    private static double easeInOutElastic(double x) {
        double c5 = 1.3962634015954636;
        return x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : (x < 0.5 ? -(Math.pow(2.0, 20.0 * x - 10.0) * Math.sin((20.0 * x - 11.125) * c5)) / 2.0 : Math.pow(2.0, -20.0 * x + 10.0) * Math.sin((20.0 * x - 11.125) * c5) / 2.0 + 1.0));
    }

    private static double easeInBounce(double x) {
        return 1.0 - EasingUtil.easeOutBounce(1.0 - x);
    }

    private static double easeOutBounce(double x) {
        double n1 = 7.5625;
        double d1 = 2.75;
        if (x < 1.0 / d1) {
            return n1 * x * x;
        }
        if (x < 2.0 / d1) {
            return n1 * (x -= 1.5 / d1) * x + 0.75;
        }
        if (x < 2.5 / d1) {
            return n1 * (x -= 2.25 / d1) * x + 0.9375;
        }
        return n1 * (x -= 2.625 / d1) * x + 0.984375;
    }

    private static double easeInOutBounce(double x) {
        return x < 0.5 ? (1.0 - EasingUtil.easeOutBounce(1.0 - 2.0 * x)) / 2.0 : (1.0 + EasingUtil.easeOutBounce(2.0 * x - 1.0)) / 2.0;
    }

    public static enum Easing {
        EASE_IN_SINE,
        EASE_OUT_SINE,
        EASE_IN_OUT_SINE,
        EASE_IN_QUAD,
        EASE_OUT_QUAD,
        EASE_IN_OUT_QUAD,
        EASE_IN_CUBIC,
        EASE_OUT_CUBIC,
        EASE_IN_OUT_CUBIC,
        EASE_IN_QUART,
        EASE_OUT_QUART,
        EASE_IN_OUT_QUART,
        EASE_IN_QUINT,
        EASE_OUT_QUINT,
        EASE_IN_OUT_QUINT,
        EASE_IN_EXPO,
        EASE_OUT_EXPO,
        EASE_IN_OUT_EXPO,
        EASE_IN_CIRC,
        EASE_OUT_CIRC,
        EASE_IN_OUT_CIRC,
        EASE_IN_BACK,
        EASE_OUT_BACK,
        EASE_IN_OUT_BACK,
        EASE_IN_ELASTIC,
        EASE_OUT_ELASTIC,
        EASE_IN_OUT_ELASTIC,
        EASE_IN_BOUNCE,
        EASE_OUT_BOUNCE,
        EASE_IN_OUT_BOUNCE;


        public static Easing of(String value) {
            return Easing.valueOf(value.toUpperCase());
        }
    }
}

