/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.utils.math;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

public class FormulaCompiler {
    public static BiFunction<Float, Float, Float> compile(String text) {
        Lexer lexer = new Lexer(text);
        List<Token> tokens = lexer.scan();
        Parser parser = new Parser(tokens);
        parser.parse();
        return new VmFunction(parser.code(), parser.consts());
    }

    private static class Lexer {
        private final String src;
        private int pos = 0;

        Lexer(String src) {
            this.src = src.replaceAll("\\s+", "");
        }

        List<Token> scan() {
            ArrayList<Token> tokens = new ArrayList<Token>();
            while (this.pos < this.src.length()) {
                int st;
                char c = this.src.charAt(this.pos);
                if (Character.isDigit(c) || c == '.') {
                    st = this.pos;
                    while (this.pos < this.src.length() && (Character.isDigit(this.src.charAt(this.pos)) || this.src.charAt(this.pos) == '.')) {
                        ++this.pos;
                    }
                    double v = Double.parseDouble(this.src.substring(st, this.pos));
                    tokens.add(new Token(TkType.NUM, this.src.substring(st, this.pos), v));
                    continue;
                }
                if (Character.isLetter(c)) {
                    st = this.pos;
                    while (this.pos < this.src.length() && Character.isLetter(this.src.charAt(this.pos))) {
                        ++this.pos;
                    }
                    String word = this.src.substring(st, this.pos);
                    if (word.equals("pi")) {
                        tokens.add(new Token(TkType.NUM, "pi", Math.PI));
                        continue;
                    }
                    if (word.equals("e")) {
                        tokens.add(new Token(TkType.NUM, "e", Math.E));
                        continue;
                    }
                    if (this.pos < this.src.length() && this.src.charAt(this.pos) == '(') {
                        tokens.add(new Token(TkType.FUN, word));
                        continue;
                    }
                    tokens.add(new Token(TkType.VAR, word));
                    continue;
                }
                if (c == '+' || c == '-' || c == '*' || c == '/' || c == '^') {
                    tokens.add(new Token(TkType.OP, "" + c));
                    ++this.pos;
                    continue;
                }
                if (c == '(') {
                    tokens.add(new Token(TkType.LP, "("));
                    ++this.pos;
                    continue;
                }
                if (c == ')') {
                    tokens.add(new Token(TkType.RP, ")"));
                    ++this.pos;
                    continue;
                }
                throw new RuntimeException("\u975e\u6cd5\u5b57\u7b26: " + c);
            }
            tokens.add(new Token(TkType.EOF, ""));
            return tokens;
        }
    }

    private static class Parser {
        private final List<Token> tokens;
        private int cur = 0;
        private final List<Integer> code = new ArrayList<Integer>();
        private final List<Double> consts = new ArrayList<Double>();

        Parser(List<Token> tokens) {
            this.tokens = tokens;
        }

        List<Integer> code() {
            return this.code;
        }

        List<Double> consts() {
            return this.consts;
        }

        void parse() {
            this.expr();
            this.expect(TkType.EOF);
        }

        private void expr() {
            this.term();
            while (this.matchOp("+") || this.matchOp("-")) {
                String op = this.prevOp();
                this.term();
                this.emit(op.equals("+") ? 4 : 5);
            }
        }

        private void term() {
            this.power();
            while (this.matchOp("*") || this.matchOp("/")) {
                String op = this.prevOp();
                this.power();
                this.emit(op.equals("*") ? 6 : 7);
            }
        }

        private void power() {
            this.unary();
            if (this.matchOp("^")) {
                this.power();
                this.emit(9);
            }
        }

        private void unary() {
            if (this.matchOp("-")) {
                this.unary();
                this.emit(8);
            } else {
                this.primary();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void primary() {
            if (this.match(TkType.NUM)) {
                double v = this.tokens.get((int)(this.cur - 1)).numVal;
                this.emit(1, this.addConst(v));
                return;
            } else if (this.match(TkType.VAR)) {
                String name = this.tokens.get((int)(this.cur - 1)).text;
                if (name.equals("x")) {
                    this.emit(2);
                    return;
                } else {
                    if (!name.equals("y")) throw new RuntimeException("\u672a\u77e5\u53d8\u91cf: " + name);
                    this.emit(3);
                }
                return;
            } else if (this.match(TkType.FUN)) {
                String fun = this.tokens.get((int)(this.cur - 1)).text;
                this.expect(TkType.LP);
                this.expr();
                this.expect(TkType.RP);
                switch (fun) {
                    case "sin": {
                        this.emit(11);
                        return;
                    }
                    case "cos": {
                        this.emit(12);
                        return;
                    }
                    case "tan": {
                        this.emit(13);
                        return;
                    }
                    case "log": {
                        this.emit(15);
                        return;
                    }
                    case "ln": {
                        this.emit(14);
                        return;
                    }
                    case "exp": {
                        this.emit(16);
                        return;
                    }
                    case "abs": {
                        this.emit(17);
                        return;
                    }
                    case "asin": {
                        this.emit(18);
                        return;
                    }
                    case "acos": {
                        this.emit(19);
                        return;
                    }
                    case "atan": {
                        this.emit(20);
                        return;
                    }
                    case "sinh": {
                        this.emit(21);
                        return;
                    }
                    case "cosh": {
                        this.emit(22);
                        return;
                    }
                    case "tanh": {
                        this.emit(23);
                        return;
                    }
                    case "sqrt": {
                        this.emit(10);
                        return;
                    }
                    default: {
                        throw new RuntimeException("\u672a\u77e5\u51fd\u6570: " + fun);
                    }
                }
            } else {
                if (!this.match(TkType.LP)) throw new RuntimeException("\u8bed\u6cd5\u9519\u8bef");
                this.expr();
                this.expect(TkType.RP);
            }
        }

        private boolean match(TkType t) {
            if (this.cur < this.tokens.size() && this.tokens.get((int)this.cur).type == t) {
                ++this.cur;
                return true;
            }
            return false;
        }

        private boolean matchOp(String op) {
            if (this.cur < this.tokens.size() && this.tokens.get((int)this.cur).type == TkType.OP && this.tokens.get((int)this.cur).text.equals(op)) {
                ++this.cur;
                return true;
            }
            return false;
        }

        private String prevOp() {
            return this.tokens.get((int)(this.cur - 1)).text;
        }

        private void expect(TkType t) {
            if (!this.match(t)) {
                throw new RuntimeException("\u671f\u671b " + String.valueOf((Object)t) + " \u4f46\u770b\u5230 " + this.tokens.get((int)this.cur).text);
            }
        }

        private int addConst(double v) {
            this.consts.add(v);
            return this.consts.size() - 1;
        }

        private void emit(int op) {
            this.code.add(op);
        }

        private void emit(int op, int arg) {
            this.code.add(op);
            this.code.add(arg);
        }
    }

    private static class VmFunction
    implements BiFunction<Float, Float, Float> {
        private final int[] code;
        private final double[] consts;

        VmFunction(List<Integer> c, List<Double> cons) {
            this.code = c.stream().mapToInt(Integer::intValue).toArray();
            this.consts = cons.stream().mapToDouble(Double::doubleValue).toArray();
        }

        @Override
        public Float apply(Float x, Float y) {
            float[] stack = new float[32];
            int sp = -1;
            int pc = 0;
            block25: while (pc < this.code.length) {
                int op = this.code[pc++];
                switch (op) {
                    case 1: {
                        stack[++sp] = (float)this.consts[this.code[pc++]];
                        continue block25;
                    }
                    case 2: {
                        stack[++sp] = x.floatValue();
                        continue block25;
                    }
                    case 3: {
                        stack[++sp] = y.floatValue();
                        continue block25;
                    }
                    case 4: {
                        float b = stack[sp--];
                        float a = stack[sp--];
                        stack[++sp] = a + b;
                        continue block25;
                    }
                    case 5: {
                        float b = stack[sp--];
                        float a = stack[sp--];
                        stack[++sp] = a - b;
                        continue block25;
                    }
                    case 6: {
                        float b = stack[sp--];
                        float a = stack[sp--];
                        stack[++sp] = a * b;
                        continue block25;
                    }
                    case 7: {
                        float b = stack[sp--];
                        float a = stack[sp--];
                        stack[++sp] = a / b;
                        continue block25;
                    }
                    case 9: {
                        float b = stack[sp--];
                        float a = stack[sp--];
                        stack[++sp] = (float)Math.pow(a, b);
                        continue block25;
                    }
                    case 8: {
                        stack[sp] = -stack[sp];
                        continue block25;
                    }
                    case 11: {
                        stack[sp] = (float)Math.sin(stack[sp]);
                        continue block25;
                    }
                    case 12: {
                        stack[sp] = (float)Math.cos(stack[sp]);
                        continue block25;
                    }
                    case 13: {
                        stack[sp] = (float)Math.tan(stack[sp]);
                        continue block25;
                    }
                    case 14: {
                        stack[sp] = (float)Math.log(stack[sp]);
                        continue block25;
                    }
                    case 15: {
                        stack[sp] = (float)Math.log10(stack[sp]);
                        continue block25;
                    }
                    case 16: {
                        stack[sp] = (float)Math.exp(stack[sp]);
                        continue block25;
                    }
                    case 17: {
                        stack[sp] = Math.abs(stack[sp]);
                        continue block25;
                    }
                    case 18: {
                        stack[sp] = (float)Math.asin(stack[sp]);
                        continue block25;
                    }
                    case 19: {
                        stack[sp] = (float)Math.acos(stack[sp]);
                        continue block25;
                    }
                    case 20: {
                        stack[sp] = (float)Math.atan(stack[sp]);
                        continue block25;
                    }
                    case 21: {
                        stack[sp] = (float)Math.sinh(stack[sp]);
                        continue block25;
                    }
                    case 22: {
                        stack[sp] = (float)Math.cosh(stack[sp]);
                        continue block25;
                    }
                    case 23: {
                        stack[sp] = (float)Math.tanh(stack[sp]);
                        continue block25;
                    }
                    case 10: {
                        stack[sp] = (float)Math.sqrt(stack[sp]);
                        continue block25;
                    }
                }
                throw new RuntimeException("\u975e\u6cd5\u6307\u4ee4");
            }
            return Float.valueOf(stack[0]);
        }
    }

    private static class Op {
        static final int LOADC = 1;
        static final int LOADX = 2;
        static final int LOADY = 3;
        static final int ADD = 4;
        static final int SUB = 5;
        static final int MUL = 6;
        static final int DIV = 7;
        static final int NEG = 8;
        static final int POW = 9;
        static final int SQRT = 10;
        static final int SIN = 11;
        static final int COS = 12;
        static final int TAN = 13;
        static final int LN = 14;
        static final int LOG = 15;
        static final int EXP = 16;
        static final int ABS = 17;
        static final int ASIN = 18;
        static final int ACOS = 19;
        static final int ATAN = 20;
        static final int SINH = 21;
        static final int COSH = 22;
        static final int TANH = 23;

        private Op() {
        }
    }

    private static class Token {
        TkType type;
        String text;
        double numVal;

        Token(TkType t, String s) {
            this(t, s, 0.0);
        }

        Token(TkType t, String s, double v) {
            this.type = t;
            this.text = s;
            this.numVal = v;
        }
    }

    private static enum TkType {
        NUM,
        VAR,
        FUN,
        OP,
        LP,
        RP,
        EOF;

    }
}

