/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.utils.math;

import com.zhenshiz.chatbox.utils.math.Point;
import java.util.function.BiFunction;

public class MotionSimulator {
    private final BiFunction<Float, Float, Float> equation;
    private Point currentPosition;
    private final float delta;
    private static final float EPSILON = 0.001f;
    private static final float PROJECTION_TOLERANCE = 1.0E-6f;
    private static final int MAX_PROJECTION_ITERATIONS = 10;

    public MotionSimulator(BiFunction<Float, Float, Float> equation, Point startPosition, float delta) {
        this.equation = equation;
        this.currentPosition = startPosition;
        this.delta = delta;
    }

    private float evaluateEquation(Point p) {
        return this.equation.apply(Float.valueOf(p.x()), Float.valueOf(p.y())).floatValue();
    }

    private Point computeGradient(Point p) {
        float gradX = (this.evaluateEquation(new Point(p.x() + 0.001f, p.y())) - this.evaluateEquation(new Point(p.x() - 0.001f, p.y()))) / 0.002f;
        float gradY = (this.evaluateEquation(new Point(p.x(), p.y() + 0.001f)) - this.evaluateEquation(new Point(p.x(), p.y() - 0.001f))) / 0.002f;
        return new Point(gradX, gradY);
    }

    private Point projectToSurface(Point p) {
        Point gradient;
        float gradientSqr;
        float f;
        Point projected = p;
        for (int i = 0; i < 10 && !(Math.abs(f = this.evaluateEquation(projected)) < 1.0E-6f) && !((gradientSqr = (gradient = this.computeGradient(projected)).x() * gradient.x() + gradient.y() * gradient.y()) < 1.0E-12f); ++i) {
            float adjustment = f / gradientSqr;
            projected = projected.subtract(gradient.multiply(adjustment));
        }
        return projected;
    }

    public Point getNextPosition() {
        Point gradient = this.computeGradient(this.currentPosition);
        Point tangent = new Point(-gradient.y(), gradient.x()).normalize();
        Point nextPos = this.currentPosition.add(tangent.multiply(this.delta));
        this.currentPosition = nextPos = this.projectToSurface(nextPos);
        return nextPos;
    }

    public Point getCurrentPosition() {
        return this.currentPosition;
    }
}

