/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.utils.math;

import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.component.Portrait;
import com.zhenshiz.chatbox.utils.math.FormulaCompiler;
import com.zhenshiz.chatbox.utils.math.MotionSimulator;
import com.zhenshiz.chatbox.utils.math.Point;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_310;

public class MotionUtil {
    private static final Map<String, BiFunction<Float, Float, Float>> COMPILED_EQUATIONS = new HashMap<String, BiFunction<Float, Float, Float>>();
    private static final Map<String, PathCache> PATH_CACHE = new HashMap<String, PathCache>();

    public static void apply(Portrait portrait, String equation, Point start, float delta, int step, int index) {
        Point point = MotionUtil.getPathPoint(equation, start, delta, step, index);
        portrait.setPosition(start.x() + point.x(), start.y() + point.y());
    }

    private static Point getPathPoint(String equation, Point startPosition, float delta, int step, int index) {
        String cacheKey = equation + "-" + String.valueOf(startPosition) + "-" + delta + "-" + step;
        if (!PATH_CACHE.containsKey(cacheKey)) {
            PATH_CACHE.put(cacheKey, new PathCache(equation, startPosition, delta, step));
        }
        if (index < 0 || index >= step) {
            return new Point(0.0f, 0.0f);
        }
        return MotionUtil.PATH_CACHE.get((Object)cacheKey).path[index].multiply(1.0f, MotionUtil.getScreenRatio());
    }

    public static float getScreenRatio() {
        class_310 minecraft = class_310.method_1551();
        return (float)minecraft.method_22683().method_4486() / (float)minecraft.method_22683().method_4502();
    }

    private static class PathCache {
        private final Point[] path;

        public PathCache(String equation, Point startPosition, float delta, int step) {
            BiFunction<Float, Float, Float> compiledEquation;
            if (COMPILED_EQUATIONS.containsKey(equation)) {
                compiledEquation = COMPILED_EQUATIONS.get(equation);
            } else {
                try {
                    compiledEquation = FormulaCompiler.compile(equation);
                }
                catch (Exception e) {
                    ChatBox.LOGGER.error("Failed to compile equation: {}", (Object)equation, (Object)e);
                    compiledEquation = (x, y) -> Float.valueOf(0.0f);
                }
                COMPILED_EQUATIONS.put(equation, compiledEquation);
            }
            MotionSimulator simulator = new MotionSimulator(compiledEquation, startPosition, delta);
            this.path = new Point[step];
            for (int i = 0; i < step; ++i) {
                this.path[i] = simulator.getNextPosition();
            }
        }
    }
}

