/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.utils.math;

import org.jetbrains.annotations.NotNull;

public record Point(float x, float y) {
    public static final Point ZERO = new Point(0.0f, 0.0f);

    public Point add(Point other) {
        return new Point(this.x + other.x, this.y + other.y);
    }

    public Point subtract(Point other) {
        return new Point(this.x - other.x, this.y - other.y);
    }

    public Point multiply(float scalar) {
        return new Point(this.x * scalar, this.y * scalar);
    }

    public Point multiply(float xScalar, float yScalar) {
        return new Point(this.x * xScalar, this.y * yScalar);
    }

    public float magnitude() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Point normalize() {
        float mag = this.magnitude();
        return mag > 0.0f ? this.multiply(1.0f / mag) : this;
    }

    @Override
    @NotNull
    public String toString() {
        return String.format("(%.6f, %.6f)", Float.valueOf(this.x), Float.valueOf(this.y));
    }
}

