/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox;

import com.mojang.logging.LogUtils;
import com.zhenshiz.chatbox.api.ChatOptionClickEvent;
import com.zhenshiz.chatbox.data.ChatBoxTriggerCount;
import com.zhenshiz.chatbox.platform.IPlatformHelper;
import java.util.ServiceLoader;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class ChatBox {
    public static final String MOD_ID = "chatbox";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static ChatBoxTriggerCount triggerCounts;
    public static final IPlatformHelper PLATFORM;

    public static void init() {
        LOGGER.info("Ciallo\uff5e(\u2220\u00b7\u03c9< )\u2312\u2605");
        ChatOptionClickEvent.registerClickEvent(new ChatOptionClickEvent.Command());
    }

    private static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    public static ResourceLocation ResourceLocationMod(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static boolean isWaterMediaLoaded() {
        return PLATFORM.isModLoaded("watermedia");
    }

    public static ChatBoxTriggerCount getTriggerCounts() {
        return triggerCounts;
    }

    public static void setTriggerCounts(ChatBoxTriggerCount triggerCounts) {
        ChatBox.triggerCounts = triggerCounts;
    }

    static {
        PLATFORM = ChatBox.load(IPlatformHelper.class);
    }
}

