/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox;

import com.mojang.brigadier.CommandDispatcher;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.Config;
import com.zhenshiz.chatbox.client.ChatBoxClient;
import com.zhenshiz.chatbox.command.ChatBoxCommand;
import com.zhenshiz.chatbox.compat.terraentity.TerraEntityShop;
import com.zhenshiz.chatbox.data.ChatBoxTriggerCount;
import com.zhenshiz.chatbox.network.NetworkForge;
import java.io.Serializable;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;

@Mod(value="chatbox")
public class ChatBoxForge {
    public ChatBoxForge() {
        ChatBox.init();
        if (ChatBox.PLATFORM.isModLoaded("terra_entity")) {
            TerraEntityShop.register();
        }
        MinecraftForge.EVENT_BUS.addListener(this::onRegisterCommands);
        MinecraftForge.EVENT_BUS.addListener(this::onWorldLoad);
        NetworkForge.registerHandlers();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> {
            ChatBoxClient.init();
            ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> (Screen)AutoConfig.getConfigScreen(Config.class, (Screen)parent).get()));
        });
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        ChatBoxCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
    }

    private void onWorldLoad(LevelEvent.Load event) {
        ServerLevel world;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (world = (ServerLevel)levelAccessor).m_46472_() == Level.f_46428_) {
            ChatBox.setTriggerCounts((ChatBoxTriggerCount)world.m_8895_().m_164861_(nbt -> ChatBoxTriggerCount.fromNbt(world, nbt), () -> new ChatBoxTriggerCount(world), "chatbox_trigger_count"));
        }
    }
}

