/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.api;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.network.c2s.SendClickEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ChatOptionClickEvent {
    public static final Map<String, ChatOptionClickEvent> CLICK_EVENTS = new HashMap<String, ChatOptionClickEvent>();

    public static void registerClickEvent(ChatOptionClickEvent event) {
        CLICK_EVENTS.put(event.getType().toUpperCase(), event);
    }

    public static void registerClickEvent(final String type, final Consumer<String> executeOnClient, final Supplier<Boolean> shouldExecuteOnServer, final BiConsumer<ServerPlayer, String> executeOnServer) {
        ChatOptionClickEvent.registerClickEvent(new ChatOptionClickEvent(){

            @Override
            public String getType() {
                return type;
            }

            @Override
            public void executeOnClient(String value) {
                executeOnClient.accept(value);
            }

            @Override
            public boolean shouldExecuteOnServer() {
                return (Boolean)shouldExecuteOnServer.get();
            }

            @Override
            public void executeOnServer(ServerPlayer player, String value) {
                executeOnServer.accept(player, value);
            }
        });
    }

    public String getType();

    public void executeOnClient(String var1);

    public boolean shouldExecuteOnServer();

    public void executeOnServer(ServerPlayer var1, String var2);

    default public void execute(String value) {
        this.executeOnClient(value);
        if (this.shouldExecuteOnServer()) {
            ChatBox.PLATFORM.sendToServer(new SendClickEvent(this.getType().toUpperCase(), value));
        }
    }

    public static class Command
    implements ChatOptionClickEvent {
        @Override
        public String getType() {
            return "COMMAND";
        }

        @Override
        public void executeOnClient(String value) {
        }

        @Override
        public boolean shouldExecuteOnServer() {
            return true;
        }

        @Override
        public void executeOnServer(ServerPlayer player, String value) {
            String[] commands;
            for (String command : commands = value.split(";")) {
                if ((command = command.trim()).isBlank()) continue;
                Command.executeCommand(player.f_8924_, (Entity)player, command);
            }
        }

        public static void executeCommand(@NotNull MinecraftServer server, @Nullable Entity entity, String command) {
            CommandSourceStack commandSource = entity != null ? entity.m_20203_() : server.m_129893_();
            commandSource = commandSource.m_81325_(2).m_81324_();
            CommandDispatcher dispatcher = server.m_129892_().m_82094_();
            try {
                dispatcher.execute(dispatcher.parse(command, (Object)commandSource));
            }
            catch (CommandSyntaxException e) {
                ChatBox.LOGGER.error("Error executing command on server: {}", (Object)command, (Object)e);
            }
        }
    }
}

