/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.data.ChatBoxDialoguesLoader;
import com.zhenshiz.chatbox.data.ChatBoxThemeLoader;
import com.zhenshiz.chatbox.data.ChatBoxTriggerCount;
import com.zhenshiz.chatbox.network.s2c.ChatBoxPayload;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxCommandUtil;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ChatBoxCommand {
    public static final Component ERROR_ENTITY_ONLY = Component.m_237115_((String)"command.target.entity.only");
    public static final Component ERROR_PLAYER_ONLY = Component.m_237115_((String)"command.target.player.only");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"chatbox").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82127_((String)"theme").then(Commands.m_82129_((String)"Theme", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((context, builder) -> SharedSuggestionProvider.m_82926_(ChatBoxThemeLoader.themeMap.keySet(), (SuggestionsBuilder)builder)).executes(ChatBoxCommand::toggleTheme)))).then(Commands.m_82127_((String)"skip").then(Commands.m_82129_((String)"Dialogues", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((context, builder) -> SharedSuggestionProvider.m_82926_(ChatBoxDialoguesLoader.dialoguesMap.keySet(), (SuggestionsBuilder)builder)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"Group", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            ResourceLocation dialogues = ResourceLocationArgument.m_107011_((CommandContext)context, (String)"Dialogues");
            ChatBoxDialoguesLoader.dialoguesGroupMap.get(dialogues).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(context -> ChatBoxCommand.skipDialogues((CommandContext<CommandSourceStack>)context, 0))).then(Commands.m_82129_((String)"Index", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ChatBoxCommand.skipDialogues((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"Index")))))))).then(Commands.m_82127_((String)"open").executes(ChatBoxCommand::openChatBox))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"maxTriggerCount").then(Commands.m_82129_((String)"Dialogues", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((context, builder) -> SharedSuggestionProvider.m_82926_(ChatBoxDialoguesLoader.dialoguesMap.keySet(), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"MaxTriggerCount", (ArgumentType)IntegerArgumentType.integer()).executes(ChatBoxCommand::setMaxTriggerCount)))).then(Commands.m_82127_((String)"reset").executes(ChatBoxCommand::resetMaxTriggerCount)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"command").then(Commands.m_82127_((String)"nextDialogue").executes(ChatBoxCommand::nextDialogue))).then(Commands.m_82127_((String)"autoPlay").then(Commands.m_82129_((String)"AutoPlay", (ArgumentType)BoolArgumentType.bool()).executes(ChatBoxCommand::autoPlay)))).then(Commands.m_82127_((String)"isScreen").then(Commands.m_82129_((String)"IsScreen", (ArgumentType)BoolArgumentType.bool()).executes(ChatBoxCommand::setIsScreen)))));
    }

    private static int setIsScreen(CommandContext<CommandSourceStack> context) {
        boolean isScreen = BoolArgumentType.getBool(context, (String)"IsScreen");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player != null) {
            ChatBox.PLATFORM.sendToClient(player, new ChatBoxPayload.SimplePayload("set_is_screen", String.valueOf(isScreen)));
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int autoPlay(CommandContext<CommandSourceStack> context) {
        boolean autoPlay = BoolArgumentType.getBool(context, (String)"AutoPlay");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player != null) {
            ChatBox.PLATFORM.sendToClient(player, new ChatBoxPayload.SimplePayload("auto_play", String.valueOf(autoPlay)));
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int nextDialogue(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player != null) {
            ChatBox.PLATFORM.sendToClient(player, new ChatBoxPayload.SimplePayload("next_dialogue", ""));
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int toggleTheme(CommandContext<CommandSourceStack> context) {
        ResourceLocation theme = ResourceLocationArgument.m_107011_(context, (String)"Theme");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player != null) {
            ChatBoxCommandUtil.serverToggleTheme(player, theme);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.toggle.theme"), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int skipDialogues(CommandContext<CommandSourceStack> context, int index) {
        ResourceLocation dialogues = ResourceLocationArgument.m_107011_(context, (String)"Dialogues");
        String group = StringArgumentType.getString(context, (String)"Group");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player != null) {
            ChatBoxTriggerCount counts = ChatBox.getTriggerCounts();
            int count = counts.getPlayerMaxTriggerCount(player, dialogues);
            if (count != 0) {
                counts.setPlayerMaxTriggerCount(player, dialogues, count - 1);
                ChatBoxCommandUtil.serverSkipDialogues(player, dialogues, group, index);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.skip.dialogues", (Object[])new Object[]{group, index + 1}), true);
            }
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int openChatBox(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player != null) {
            ChatBoxCommandUtil.serverOpenChatBox(player);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int setMaxTriggerCount(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player != null) {
            ResourceLocation dialogues = ResourceLocationArgument.m_107011_(context, (String)"Dialogues");
            int maxTriggerCount = IntegerArgumentType.getInteger(context, (String)"MaxTriggerCount");
            ChatBox.getTriggerCounts().setPlayerMaxTriggerCount(player, dialogues, maxTriggerCount);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.set.max.trigger.count", (Object[])new Object[]{dialogues.toString(), maxTriggerCount}), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int resetMaxTriggerCount(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player != null) {
            ChatBox.getTriggerCounts().resetPlayerMaxTriggerCount(player);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.reset.max.trigger.count"), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_(ERROR_PLAYER_ONLY);
        return 0;
    }
}

