/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.component.AbstractComponent;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;
import org.watermedia.api.image.ImageAPI;
import org.watermedia.api.image.ImageRenderer;
import org.watermedia.api.player.videolan.VideoPlayer;
import org.watermedia.core.tools.JarTool;
import org.watermedia.videolan4j.player.base.State;
import org.watermedia.videolan4j.player.component.CallbackMediaPlayerComponent;

public class Video
extends AbstractComponent<Video> {
    private static final DateFormat FORMAT = new SimpleDateFormat("HH:mm:ss");
    private float actualX;
    private float actualY;
    private float actualWidth;
    private float actualHeight;
    private int tick = 0;
    private float fadeStep30 = 0.0f;
    private float fadeStep10 = 0.0f;
    private boolean started;
    private float volume = 100.0f;
    private final boolean loop;
    private boolean success;
    private final boolean canControl;
    public final boolean canSkip;
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final VideoPlayer player;
    private final URI uri;
    int videoTexture = -1;
    ImageRenderer IMG_PAUSED = ImageAPI.renderer((BufferedImage)JarTool.readImage((String)"/pictures/paused.png"), (boolean)true);
    ImageRenderer IMG_STEP30 = ImageAPI.renderer((BufferedImage)JarTool.readImage((String)"/pictures/step30.png"), (boolean)true);
    ImageRenderer IMG_STEP10 = ImageAPI.renderer((BufferedImage)JarTool.readImage((String)"/pictures/step10.png"), (boolean)true);

    public Video(URI uri, boolean canControl, boolean canSkip, boolean loop) {
        this.canControl = canControl;
        this.canSkip = canSkip;
        this.loop = loop;
        this.uri = uri;
        this.player = new VideoPlayer((Executor)this.minecraft);
        ChatBox.LOGGER.info("Playing video ({}blocked) ({} with volume: {}", new Object[]{canControl ? "not " : "", uri, (int)(this.minecraft.f_91066_.m_92147_(SoundSource.MASTER) * 100.0f)});
        this.player.setVolume((int)(this.minecraft.f_91066_.m_92147_(SoundSource.MASTER) * 100.0f));
        this.started = true;
        this.player.start(uri);
        this.success = false;
    }

    public boolean isPlaying() {
        return this.started;
    }

    public State getState() {
        CallbackMediaPlayerComponent raw = this.player.raw();
        if (raw == null) {
            return null;
        }
        return raw.mediaPlayer().status().state();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTick) {
        if (!this.isPlaying()) {
            return;
        }
        if (!this.success && this.getState() == State.PLAYING) {
            this.success = true;
        }
        ++this.tick;
        if (this.player.isEnded() || this.player.isStopped()) {
            if (this.loop) {
                this.player.start(this.uri);
                return;
            }
            this.stop();
            return;
        }
        Vec2 pos = this.getCurrentPosition();
        this.actualX = Video.getResponsiveWidth(pos.f_82470_);
        this.actualY = Video.getResponsiveHeight(pos.f_82471_);
        this.actualWidth = Video.getResponsiveWidth(this.width);
        this.actualHeight = Video.getResponsiveHeight(this.height);
        this.videoTexture = this.player.preRender();
        if (this.player.isPlaying() || this.player.isPaused()) {
            this.renderTexture(guiGraphics, this.videoTexture);
        }
        if (!this.player.isPlaying()) {
            if (this.player.isPaused()) {
                this.renderIcon(guiGraphics, this.IMG_PAUSED);
            } else {
                this.renderIcon(guiGraphics, ImageAPI.loadingGif());
            }
        }
        this.renderStep10(guiGraphics, pPartialTick);
        this.renderStep30(guiGraphics, pPartialTick);
        if (ChatBox.PLATFORM.isDevelopmentEnvironment()) {
            this.draw(guiGraphics, String.format("State: %s", this.player.getStateName()), this.getHeightCenter(-12));
            this.draw(guiGraphics, String.format("Time: %s (%s) / %s (%s)", FORMAT.format(new Date(this.player.getTime())), this.player.getTime(), FORMAT.format(new Date(this.player.getDuration())), this.player.getDuration()), this.getHeightCenter(0));
        }
    }

    private void renderTexture(GuiGraphics guiGraphics, int texture) {
        if (this.player.dimension() == null) {
            return;
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (int)texture);
        this.drawTexture(guiGraphics, texture, this.actualX, this.actualY, this.actualWidth, this.actualHeight);
    }

    private int getHeightCenter(int offset) {
        return (int)(this.actualHeight / 2.0f + (float)offset);
    }

    private void renderIcon(GuiGraphics guiGraphics, ImageRenderer image) {
        int iconSize = 36;
        float xOffset = this.actualWidth - (float)iconSize + this.actualX;
        float yOffset = this.actualHeight - (float)iconSize + this.actualY;
        this.drawTexture(guiGraphics, image.texture(this.tick, 1L, true), xOffset, yOffset, iconSize, iconSize);
    }

    private void renderStep30(GuiGraphics guiGraphics, float pPartialTicks) {
        if (this.fadeStep30 == 0.0f) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int texture = this.IMG_STEP30.texture(this.tick, 1L, true);
        float alpha = this.fadeStep30;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        float x = this.actualWidth / 2.0f + 70.0f + this.actualX;
        float y = this.actualHeight / 2.0f - 32.0f + this.actualY;
        int size = 64;
        this.drawTexture(guiGraphics, texture, x, y, size, size);
        this.fadeStep30 = Math.max(this.fadeStep30 - pPartialTicks / 8.0f, 0.0f);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.disableBlend();
    }

    private void renderStep10(GuiGraphics guiGraphics, float pPartialTicks) {
        if (this.fadeStep10 == 0.0f) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int texture = this.IMG_STEP10.texture(this.tick, 1L, true);
        float alpha = this.fadeStep10;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        float x = this.actualWidth / 2.0f - 134.0f + this.actualX;
        float y = this.actualHeight / 2.0f - 32.0f + this.actualY;
        int size = 64;
        this.drawTexture(guiGraphics, texture, x, y, size, size);
        this.fadeStep10 = Math.max(this.fadeStep10 - pPartialTicks / 8.0f, 0.0f);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.disableBlend();
    }

    private void drawTexture(GuiGraphics guiGraphics, int texture, float x, float y, float width, float height) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (int)texture);
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix4f, x, y + height, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, x + width, y + height, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, x + width, y, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, x, y, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    private void draw(GuiGraphics guiGraphics, String text, int height) {
        guiGraphics.m_280488_(this.minecraft.f_91062_, text, 5 + (int)this.actualX, height + (int)this.actualY, 0xFFFFFF);
    }

    public void keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        float newVolume;
        float actualVolume;
        if (pKeyCode == 265) {
            if (this.volume <= 95.0f) {
                this.volume += 5.0f;
            } else {
                this.volume = 100.0f;
                float masterVolume = this.minecraft.f_91066_.m_92147_(SoundSource.MASTER);
                if ((double)masterVolume <= 0.95) {
                    this.minecraft.f_91066_.m_246669_(SoundSource.MASTER).m_231514_((Object)((double)masterVolume + 0.05));
                } else {
                    this.minecraft.f_91066_.m_246669_(SoundSource.MASTER).m_231514_((Object)1.0);
                }
            }
            actualVolume = this.minecraft.f_91066_.m_92147_(SoundSource.MASTER);
            newVolume = this.volume * actualVolume;
            ChatBox.LOGGER.info("Volume UP to: {}", (Object)Float.valueOf(newVolume));
            this.player.setVolume((int)newVolume);
        }
        if (pKeyCode == 264) {
            this.volume = this.volume >= 5.0f ? (this.volume -= 5.0f) : 0.0f;
            actualVolume = this.minecraft.f_91066_.m_92147_(SoundSource.MASTER);
            newVolume = this.volume * actualVolume;
            ChatBox.LOGGER.info("Volume DOWN to: {}", (Object)Float.valueOf(newVolume));
            this.player.setVolume((int)newVolume);
        }
        if (pKeyCode == 77) {
            if (!this.player.isMuted()) {
                this.player.mute();
            } else {
                this.player.unmute();
            }
        }
        if (!this.canControl) {
            return;
        }
        if (pKeyCode == 262) {
            long time = this.loop && this.player.getTime() + 30000L > this.player.getDuration() ? 0L : this.player.getTime() + 30000L;
            this.player.seekTo(time);
            this.fadeStep30 = 1.0f;
        }
        if (pKeyCode == 263) {
            this.player.seekTo(this.player.getTime() - 10000L);
            this.fadeStep10 = 1.0f;
        }
        if (pKeyCode == 32) {
            if (!this.player.isPaused()) {
                this.player.pause();
            } else {
                this.player.play();
            }
        }
    }

    private void stop() {
        if (!this.success) {
            this.player.start(this.uri);
            return;
        }
        this.close();
    }

    public void close() {
        if (this.started) {
            this.started = false;
            this.player.stop();
            GlStateManager._deleteTexture((int)this.videoTexture);
            this.player.release();
        }
    }

    static {
        FORMAT.setTimeZone(TimeZone.getTimeZone("GMT-00:00"));
    }
}

