/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.data;

import com.google.gson.JsonElement;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.component.ChatOption;
import com.zhenshiz.chatbox.component.DialogBox;
import com.zhenshiz.chatbox.component.Portrait;
import com.zhenshiz.chatbox.component.Video;
import com.zhenshiz.chatbox.data.ChatBoxTheme;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.common.BeanUtil;
import com.zhenshiz.chatbox.utils.common.CollUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;

public class ChatBoxDialogues {
    public Map<String, List<Dialogues>> dialogues = new HashMap<String, List<Dialogues>>();
    public Boolean isTranslatable = false;
    public Boolean isEsc = true;
    public Boolean isPause = true;
    public Boolean isHistoricalSkip = true;
    public String theme;
    public Boolean isScreen;

    public static class Dialogues {
        public DialogBox dialogBox = new DialogBox();
        public List<JsonElement> portrait;
        public List<Option> options;
        public String sound = "";
        public Float volume = Float.valueOf(1.0f);
        public Float pitch = Float.valueOf(1.0f);
        public String command;
        public String backgroundImage;
        public Video video;
        public Boolean clearOldPortrait = true;
        public List<String> removePortrait;

        public List<Portrait> setPortraitDialogues(List<Portrait> portraitList) {
            Map<String, ChatBoxTheme.Portrait> map = ChatBoxUtil.chatBoxTheme.portrait;
            Map<String, List<ChatBoxTheme.Portrait.CustomAnimation>> animations = ChatBoxUtil.animationMap;
            if (this.clearOldPortrait.booleanValue()) {
                portraitList.clear();
            } else if (!CollUtil.isEmpty(this.removePortrait).booleanValue()) {
                portraitList.removeIf(portrait -> this.removePortrait.contains(portrait.id));
            }
            if (map != null && !map.isEmpty()) {
                this.parsePortrait().forEach(p -> {
                    Portrait portrait = null;
                    if (p instanceof String) {
                        String s = (String)p;
                        try {
                            portrait = (Portrait)((ChatBoxTheme.Portrait)map.get(s)).setPortraitTheme().build();
                            portrait.id = s;
                        }
                        catch (Exception e) {
                            ChatBox.LOGGER.error("portrait {} not found", p);
                        }
                    } else if (p instanceof ReplacePortrait) {
                        ReplacePortrait replacePortrait = (ReplacePortrait)p;
                        try {
                            portrait = (Portrait)replacePortrait.replace((ChatBoxTheme.Portrait)map.get(replacePortrait.id)).setPortraitTheme().build();
                            portrait.id = replacePortrait.id;
                        }
                        catch (Exception e) {
                            ChatBox.LOGGER.error("portrait {} not found", (Object)replacePortrait.id);
                        }
                    }
                    if (portrait != null) {
                        ArrayList<ChatBoxTheme.Portrait.CustomAnimation> animation = new ArrayList();
                        if (portrait.animationType != null && animations.containsKey(portrait.animationType)) {
                            animation = (List)animations.get(portrait.animationType);
                        }
                        if (!CollUtil.isEmpty(portrait.customAnimation).booleanValue()) {
                            animation = portrait.customAnimation;
                        }
                        if (!CollUtil.isEmpty(animation).booleanValue()) {
                            portrait.setCustomAnimation(animation);
                            portrait.setIsAnimation(true).setTarget(portrait.x, portrait.y, portrait.scale.floatValue(), portrait.opacity.floatValue(), portrait.angle.floatValue());
                            if (portrait.loop.booleanValue()) {
                                portrait.setStart(portrait.x, portrait.y, portrait.scale.floatValue(), portrait.opacity.floatValue(), portrait.angle.floatValue());
                            }
                        }
                        portraitList.add(portrait);
                    }
                });
            }
            return portraitList;
        }

        private List<Object> parsePortrait() {
            ArrayList<Object> portraitList = new ArrayList<Object>();
            if (CollUtil.isEmpty(this.portrait).booleanValue()) {
                return portraitList;
            }
            for (JsonElement element : this.portrait) {
                if (element.isJsonPrimitive()) {
                    portraitList.add(element.getAsString());
                    continue;
                }
                if (!element.isJsonObject()) continue;
                ReplacePortrait obj = (ReplacePortrait)ChatBoxUtil.GSON.fromJson(element, ReplacePortrait.class);
                portraitList.add(obj);
            }
            return portraitList;
        }

        public List<ChatOption> setChatOptionDialogues(boolean isTranslatable) {
            ArrayList<ChatOption> chatOptions = new ArrayList<ChatOption>();
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && !CollUtil.isEmpty(this.options).booleanValue()) {
                int i = -1;
                for (Option value : this.options) {
                    Scoreboard scoreboard = level.m_6188_();
                    Objective objective = scoreboard.m_83477_(value.hidden.objective);
                    Score scoreAccess = null;
                    if (objective != null) {
                        scoreAccess = scoreboard.m_83471_(value.hidden.value, objective);
                    }
                    if (value.isHidden.booleanValue() && (scoreAccess == null || scoreAccess.m_83400_() != 1)) continue;
                    ++i;
                    objective = scoreboard.m_83477_(value.lock.objective);
                    if (objective != null) {
                        scoreAccess = scoreboard.m_83471_(value.lock.value, objective);
                    }
                    ChatOption chatOption = new ChatOption().setOptionTooltip(value.tooltip, isTranslatable).setOptionChat(value.text, isTranslatable).setIsLock(value.isLock != false && (scoreAccess == null || scoreAccess.m_83400_() != 1)).setNext(value.next).setClickEvent(value.click.type, value.click.value);
                    chatOptions.add(ChatBoxUtil.chatBoxTheme.option.setChatOptionTheme(chatOption, i));
                }
            }
            return chatOptions;
        }

        public static class DialogBox {
            public String name = "";
            public String text = "";

            public com.zhenshiz.chatbox.component.DialogBox setDialogBoxDialogues(com.zhenshiz.chatbox.component.DialogBox dialogBox, boolean isTranslatable) {
                return dialogBox.setName(this.name, isTranslatable).setText(this.text, isTranslatable).resetTickCount();
            }
        }

        public static class ReplacePortrait
        extends ChatBoxTheme.Portrait {
            public String id;

            public ReplacePortrait() {
                this.x = null;
                this.y = null;
                this.width = null;
                this.height = null;
                this.alignX = null;
                this.alignY = null;
                this.opacity = null;
                this.renderOrder = null;
                this.angle = null;
                this.scale = null;
                this.loop = null;
            }

            public ChatBoxTheme.Portrait replace(ChatBoxTheme.Portrait portrait) {
                ChatBoxTheme.Portrait copy = new ChatBoxTheme.Portrait();
                BeanUtil.copyProperties(portrait, copy);
                BeanUtil.copyProperties(this, copy);
                return copy;
            }
        }

        public static class Option {
            public String text;
            public Boolean isLock = false;
            public Condition lock = new Condition();
            public Condition hidden = new Condition();
            public Boolean isHidden = false;
            public String next;
            public Click click = new Click();
            public String tooltip;

            public static class Condition {
                public String objective;
                public String value;
            }

            public static class Click {
                public String type;
                public String value;
            }
        }

        public static class Video
        extends ChatBoxTheme.Component {
            public String path;
            public Boolean canControl;
            public Boolean canSkip;
            public Boolean loop;

            public Video() {
                this.x = Float.valueOf(0.0f);
                this.y = Float.valueOf(0.0f);
                this.width = Float.valueOf(100.0f);
                this.height = Float.valueOf(100.0f);
                this.renderOrder = -1;
                this.canControl = true;
                this.canSkip = true;
                this.loop = false;
            }

            public com.zhenshiz.chatbox.component.Video setVideo() {
                if (!ChatBox.isWaterMediaLoaded()) {
                    return null;
                }
                Path gameDir = ChatBox.PLATFORM.getGameDirectory().toPath();
                File file = new File(gameDir.toString(), this.path);
                if (!file.exists()) {
                    file = new File(this.path);
                }
                if (!file.exists()) {
                    ChatBox.LOGGER.error("video {} not found", (Object)this.path);
                    return null;
                }
                return (com.zhenshiz.chatbox.component.Video)new com.zhenshiz.chatbox.component.Video(file.toURI(), this.canControl, this.canSkip, this.loop).setDefaultOption(this.x.floatValue(), this.y.floatValue(), this.width.floatValue(), this.height.floatValue(), AbstractComponent.AlignX.of(this.alignX), AbstractComponent.AlignY.of(this.alignY), this.opacity, this.renderOrder, this.angle);
            }
        }
    }
}

