/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.network.s2c;

import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.network.CustomPacket;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxCommandUtil;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ChatBoxPayload {
    private static Map<ResourceLocation, String> mergeString(Map<ResourceLocation, List<String>> map) {
        HashMap<ResourceLocation, String> result = new HashMap<ResourceLocation, String>();
        for (Map.Entry<ResourceLocation, List<String>> entry : map.entrySet()) {
            ResourceLocation rl = entry.getKey();
            List<String> parts = entry.getValue();
            StringBuilder builder = new StringBuilder();
            for (String part : parts) {
                builder.append(part);
            }
            result.put(rl, builder.toString());
        }
        return result;
    }

    public record SimplePayload(String name, String value) implements CustomPacket
    {
        public static final ResourceLocation ID = ChatBox.ResourceLocationMod("simple_payload");
        private static final Map<String, Consumer<String>> handlers = new HashMap<String, Consumer<String>>();

        @Override
        public ResourceLocation id() {
            return ID;
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            SimplePayload.encode(this, buf);
        }

        public static void encode(SimplePayload packet, FriendlyByteBuf buf) {
            buf.m_130070_(packet.name);
            buf.m_130070_(packet.value);
        }

        public static SimplePayload decode(FriendlyByteBuf buf) {
            return new SimplePayload(buf.m_130277_(), buf.m_130277_());
        }

        public static void handleOnClient(SimplePayload packet) {
            ChatBox.PLATFORM.runOnClient(() -> {
                if (handlers.containsKey(packet.name)) {
                    handlers.get(packet.name).accept(packet.value);
                }
            });
        }

        static {
            handlers.put("open_dialog", s -> ChatBoxCommandUtil.clientOpenChatBox());
            handlers.put("set_theme", ChatBoxCommandUtil::clientToggleTheme);
            handlers.put("next_dialogue", s -> ChatBoxCommandUtil.clientNextDialogue());
            handlers.put("auto_play", s -> ChatBoxCommandUtil.clientAutoPlay(Boolean.parseBoolean(s)));
            handlers.put("set_is_screen", s -> ChatBoxCommandUtil.clientSetIsScreen(Boolean.parseBoolean(s)));
        }
    }

    public record AllChatBoxDialoguesToClient(Map<ResourceLocation, List<String>> dialoguesMap) implements CustomPacket
    {
        public static final ResourceLocation ID = ChatBox.ResourceLocationMod("all_chat_box_dialogues_to_client");

        @Override
        public ResourceLocation id() {
            return ID;
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            AllChatBoxDialoguesToClient.encode(this, buf);
        }

        public static void encode(AllChatBoxDialoguesToClient packet, FriendlyByteBuf buf) {
            buf.m_236831_(packet.dialoguesMap, FriendlyByteBuf::m_130085_, (vBuf, v) -> vBuf.m_236828_((Collection)v, FriendlyByteBuf::m_130070_));
        }

        public static AllChatBoxDialoguesToClient decode(FriendlyByteBuf buf) {
            return new AllChatBoxDialoguesToClient(buf.m_236847_(FriendlyByteBuf::m_130281_, v -> v.m_236845_(FriendlyByteBuf::m_130277_)));
        }

        public static void handleOnClient(AllChatBoxDialoguesToClient packet) {
            ChatBox.PLATFORM.runOnClient(() -> ChatBoxUtil.setDialogues(ChatBoxPayload.mergeString(packet.dialoguesMap)));
        }
    }

    public record AllChatBoxThemeToClient(Map<ResourceLocation, List<String>> themeMap) implements CustomPacket
    {
        public static final ResourceLocation ID = ChatBox.ResourceLocationMod("all_chat_box_theme_to_client");

        @Override
        public ResourceLocation id() {
            return ID;
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            AllChatBoxThemeToClient.encode(this, buf);
        }

        public static void encode(AllChatBoxThemeToClient packet, FriendlyByteBuf buf) {
            buf.m_236831_(packet.themeMap, FriendlyByteBuf::m_130085_, (vBuf, v) -> vBuf.m_236828_((Collection)v, FriendlyByteBuf::m_130070_));
        }

        public static AllChatBoxThemeToClient decode(FriendlyByteBuf buf) {
            return new AllChatBoxThemeToClient(buf.m_236847_(FriendlyByteBuf::m_130281_, v -> v.m_236845_(FriendlyByteBuf::m_130277_)));
        }

        public static void handleOnClient(AllChatBoxThemeToClient packet) {
            ChatBox.PLATFORM.runOnClient(() -> {
                ResourceLocation theme;
                ChatBoxUtil.setTheme(ChatBoxPayload.mergeString(packet.themeMap));
                if (ChatBoxUtil.themeResourceLocation != null && (theme = ResourceLocation.m_135820_((String)ChatBoxUtil.themeResourceLocation)) != null) {
                    ChatBoxUtil.toggleTheme(theme);
                }
            });
        }
    }

    public record OpenScreen(ResourceLocation dialogues, String group, int index) implements CustomPacket
    {
        public static final ResourceLocation ID = ChatBox.ResourceLocationMod("open_screen");

        @Override
        public ResourceLocation id() {
            return ID;
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            OpenScreen.encode(this, buf);
        }

        public static void encode(OpenScreen packet, FriendlyByteBuf buf) {
            buf.m_130085_(packet.dialogues);
            buf.m_130070_(packet.group);
            buf.writeInt(packet.index);
        }

        public static OpenScreen decode(FriendlyByteBuf buf) {
            return new OpenScreen(buf.m_130281_(), buf.m_130277_(), buf.readInt());
        }

        public static void handleOnClient(OpenScreen packet) {
            ChatBox.PLATFORM.runOnClient(() -> ChatBoxCommandUtil.clientSkipDialogues(packet.dialogues, packet.group, packet.index));
        }
    }
}

