/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.utils.common;

import com.zhenshiz.chatbox.utils.common.ArrayUtil;
import com.zhenshiz.chatbox.utils.common.StrFormatter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StrUtil {
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !StrUtil.isEmpty(str);
    }

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (StrUtil.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence str) {
        return !StrUtil.isBlank(str);
    }

    public static String removePrefix(CharSequence str, CharSequence prefix) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(prefix)) {
            return str.toString();
        }
        String str2 = str.toString();
        if (str2.startsWith(prefix.toString())) {
            return str2.substring(prefix.length());
        }
        return str2;
    }

    public static String subBefore(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (StrUtil.isEmpty(string) || separator == null) {
            return null == string ? null : string.toString();
        }
        String str = string.toString();
        String sep = separator.toString();
        if (sep.isEmpty()) {
            return EMPTY;
        }
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return EMPTY;
        }
        return str.substring(0, pos);
    }

    public static String addSuffixIfNot(CharSequence str, CharSequence suffix) {
        return StrUtil.appendIfMissing(str, suffix, suffix);
    }

    public static String appendIfMissing(CharSequence str, CharSequence suffix, CharSequence ... suffixes) {
        return StrUtil.appendIfMissing(str, suffix, false, suffixes);
    }

    public static String appendIfMissing(CharSequence str, CharSequence suffix, boolean ignoreCase, CharSequence ... testSuffixes) {
        if (str == null || StrUtil.isEmpty(suffix) || StrUtil.endWith(str, suffix, ignoreCase, false)) {
            return StrUtil.str(str);
        }
        if (testSuffixes != null) {
            for (CharSequence testSuffix : testSuffixes) {
                if (!StrUtil.endWith(str, testSuffix, ignoreCase, false)) continue;
                return str.toString();
            }
        }
        return str.toString().concat(suffix.toString());
    }

    public static boolean endWith(CharSequence str, CharSequence suffix, boolean ignoreCase, boolean ignoreEquals) {
        if (null == str || null == suffix) {
            if (ignoreEquals) {
                return false;
            }
            return null == str && null == suffix;
        }
        int strOffset = str.length() - suffix.length();
        boolean isEndWith = str.toString().regionMatches(ignoreCase, strOffset, suffix.toString(), 0, suffix.length());
        if (isEndWith) {
            return !ignoreEquals || !StrUtil.equals(str, suffix, ignoreCase);
        }
        return false;
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.toString().contentEquals(str2);
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234 || c == 0 || c == 12644 || c == 10240 || c == 8204 || c == 6158;
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StrUtil.str(obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StrUtil.str(obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StrUtil.str(obj, charset);
        }
        return ArrayUtil.isArray(obj) ? ArrayUtil.toString(obj) : obj.toString();
    }

    public static String utf8Str(Object obj) {
        return StrUtil.str(obj, StandardCharsets.UTF_8);
    }

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return "null";
        }
        return !ArrayUtil.isEmpty(params) && !StrUtil.isBlank(template) ? StrFormatter.format(template.toString(), params) : template.toString();
    }

    public static String replace(String str, String searchStr, String replacement) {
        return StrUtil.replace(str, 0, searchStr, replacement, false);
    }

    public static String replace(String str, int fromIndex, String searchStr, String replacement, boolean ignoreCase) {
        if (!StrUtil.isEmpty(str) && !StrUtil.isEmpty(searchStr)) {
            int index;
            int searchStrLength;
            int strLength;
            if (null == replacement) {
                replacement = EMPTY;
            }
            if ((strLength = str.length()) < (searchStrLength = searchStr.length())) {
                return StrUtil.str(str);
            }
            if (fromIndex > strLength) {
                return StrUtil.str(str);
            }
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            StringBuilder result = new StringBuilder(strLength - searchStrLength + replacement.length());
            if (0 != fromIndex) {
                result.append(str.subSequence(0, fromIndex));
            }
            int preIndex = fromIndex;
            while ((index = StrUtil.indexOf(str, searchStr, preIndex, ignoreCase)) > -1) {
                result.append(str.subSequence(preIndex, index));
                result.append(replacement);
                preIndex = index + searchStrLength;
            }
            if (preIndex < strLength) {
                result.append(str.subSequence(preIndex, strLength));
            }
            return result.toString();
        }
        return StrUtil.str(str);
    }

    public static int indexOf(String str, String searchStr, int preIndex, boolean ignoreCase) {
        if (str == null || searchStr == null || searchStr.isEmpty() || preIndex < 0 || preIndex >= str.length()) {
            return -1;
        }
        if (ignoreCase) {
            str = str.toLowerCase();
            searchStr = searchStr.toLowerCase();
        }
        for (int i = preIndex; i <= str.length() - searchStr.length(); ++i) {
            if (!str.startsWith(searchStr, i)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String maxLength(String str, int length) {
        if (str == null || length <= 0) {
            return null;
        }
        return str.length() <= length ? str : StrUtil.sub(str, 0, length) + "...";
    }

    public static String sub(CharSequence str, int fromIndexInclude, int toIndexExclude) {
        if (StrUtil.isEmpty(str)) {
            return StrUtil.str(str);
        }
        int len = str.length();
        if (fromIndexInclude < 0) {
            if ((fromIndexInclude += len) < 0) {
                fromIndexInclude = 0;
            }
        } else if (fromIndexInclude > len) {
            fromIndexInclude = len;
        }
        if (toIndexExclude < 0) {
            if ((toIndexExclude += len) < 0) {
                toIndexExclude = len;
            }
        } else if (toIndexExclude > len) {
            toIndexExclude = len;
        }
        if (toIndexExclude < fromIndexInclude) {
            int tmp = fromIndexInclude;
            fromIndexInclude = toIndexExclude;
            toIndexExclude = tmp;
        }
        return fromIndexInclude == toIndexExclude ? EMPTY : str.toString().substring(fromIndexInclude, toIndexExclude);
    }
}

