/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.zhenshiz.chatbox.Config;
import com.zhenshiz.chatbox.api.ChatOptionClickEvent;
import com.zhenshiz.chatbox.api.Command;
import com.zhenshiz.chatbox.api.OpenTerraShopEvent;
import com.zhenshiz.chatbox.command.ICommand;
import com.zhenshiz.chatbox.data.ChatBoxTriggerCount;
import com.zhenshiz.chatbox.utils.common.StrUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.objectweb.asm.Type;
import org.slf4j.Logger;

@Mod(value="chatbox")
public class ChatBox {
    public static final String MOD_ID = "chatbox";
    public static final Logger LOGGER = LogUtils.getLogger();

    public ChatBox(IEventBus modEventBus, ModContainer modContainer, Dist dist) {
        NeoForge.EVENT_BUS.addListener(this::onRegisterCommands);
        ChatBoxTriggerCount.ATTACHMENT_TYPES.register(modEventBus);
        this.registerClickEvents();
        if (dist == Dist.CLIENT) {
            modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.CONFIG_SPEC, StrUtil.format("{}_config.toml", MOD_ID));
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
    }

    private void registerClickEvents() {
        ChatOptionClickEvent.registerClickEvent(new Command());
        if (ChatBox.isTerraEntityLoaded()) {
            ChatOptionClickEvent.registerClickEvent(new OpenTerraShopEvent());
        }
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        String REGISTER = "register";
        ModContainer modContainer = (ModContainer)ModList.get().getModContainerById(MOD_ID).orElseThrow();
        Set classes = modContainer.getModInfo().getOwningFile().getFile().getScanResult().getClasses();
        classes.forEach(classData -> {
            Type clazz = classData.clazz();
            if (clazz.getClassName().startsWith(ICommand.class.getPackageName())) {
                try {
                    ClassLoader classLoader = ChatBox.class.getClassLoader();
                    Class<?> commandClass = classLoader.loadClass(clazz.getClassName());
                    if (Arrays.stream(commandClass.getInterfaces()).toList().contains(ICommand.class)) {
                        Method register = commandClass.getMethod("register", CommandDispatcher.class, CommandBuildContext.class, Commands.CommandSelection.class);
                        Constructor<?> constructor = commandClass.getDeclaredConstructor(new Class[0]);
                        Object iCommand = constructor.newInstance(new Object[0]);
                        register.invoke(iCommand, event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static ResourceLocation ResourceLocationMod(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static boolean isWaterMediaLoaded() {
        return ChatBox.isModLoaded("watermedia");
    }

    public static boolean isTerraEntityLoaded() {
        return ChatBox.isModLoaded("terra_entity");
    }

    public static boolean isTextAnimatorLoaded() {
        return ChatBox.isModLoaded("textanimator");
    }
}

