/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.api;

import com.zhenshiz.chatbox.network.c2s.SendClickEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;

public interface ChatOptionClickEvent {
    public static final Map<String, ChatOptionClickEvent> CLICK_EVENTS = new HashMap<String, ChatOptionClickEvent>();

    public static void registerClickEvent(ChatOptionClickEvent event) {
        CLICK_EVENTS.put(event.getType().toUpperCase(), event);
    }

    public static void registerClickEvent(final String type, final Consumer<String> executeOnClient, final Boolean shouldExecuteOnServer, final BiConsumer<ServerPlayer, String> executeOnServer) {
        ChatOptionClickEvent.registerClickEvent(new ChatOptionClickEvent(){

            @Override
            public String getType() {
                return type;
            }

            @Override
            public void executeOnClient(String value) {
                executeOnClient.accept(value);
            }

            @Override
            public boolean shouldExecuteOnServer() {
                return shouldExecuteOnServer;
            }

            @Override
            public void executeOnServer(ServerPlayer player, String value) {
                executeOnServer.accept(player, value);
            }
        });
    }

    public String getType();

    public void executeOnClient(String var1);

    public boolean shouldExecuteOnServer();

    public void executeOnServer(ServerPlayer var1, String var2);

    default public void execute(String value) {
        this.executeOnClient(value);
        LocalPlayer player = Minecraft.getInstance().player;
        if (this.shouldExecuteOnServer() && player != null) {
            player.connection.send((CustomPacketPayload)new SendClickEvent(this.getType().toUpperCase(), value));
        }
    }
}

