/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.api;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.api.ChatOptionClickEvent;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Command
implements ChatOptionClickEvent {
    @Override
    public String getType() {
        return "COMMAND";
    }

    @Override
    public void executeOnClient(String value) {
    }

    @Override
    public boolean shouldExecuteOnServer() {
        return true;
    }

    @Override
    public void executeOnServer(ServerPlayer player, String value) {
        String[] commands;
        for (String command : commands = value.split(";")) {
            if ((command = command.trim()).isBlank()) continue;
            Command.executeCommand(player.server, (Entity)player, command);
        }
    }

    public static void executeCommand(@NotNull MinecraftServer server, @Nullable Entity entity, String command) {
        CommandSourceStack commandSource = entity != null ? entity.createCommandSourceStack() : server.createCommandSourceStack();
        commandSource = commandSource.withPermission(2).withSuppressedOutput();
        CommandDispatcher dispatcher = server.getCommands().getDispatcher();
        try {
            dispatcher.execute(dispatcher.parse(command, (Object)commandSource));
        }
        catch (CommandSyntaxException e) {
            ChatBox.LOGGER.error("Error executing command on server: {}", (Object)command, (Object)e);
        }
    }
}

