/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.zhenshiz.chatbox.command.ICommand;
import com.zhenshiz.chatbox.data.ChatBoxDialoguesLoader;
import com.zhenshiz.chatbox.data.ChatBoxThemeLoader;
import com.zhenshiz.chatbox.network.s2c.ClientChatBoxPayload;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxCommandUtil;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ChatBoxCommand
implements ICommand {
    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"chatbox").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.literal((String)"theme").then(Commands.argument((String)"Theme", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> SharedSuggestionProvider.suggestResource(ChatBoxThemeLoader.INSTANCE.themeMap.keySet(), (SuggestionsBuilder)builder)).executes(ChatBoxCommand::toggleTheme)))).then(Commands.literal((String)"skip").then(Commands.argument((String)"Dialogues", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> SharedSuggestionProvider.suggestResource(ChatBoxDialoguesLoader.INSTANCE.dialoguesMap.keySet(), (SuggestionsBuilder)builder)).then(((RequiredArgumentBuilder)Commands.argument((String)"Group", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            ResourceLocation dialogues = ResourceLocationArgument.getId((CommandContext)context, (String)"Dialogues");
            ChatBoxDialoguesLoader.dialoguesGroupMap.get(dialogues).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(context -> ChatBoxCommand.skipDialogues((CommandContext<CommandSourceStack>)context, 0))).then(Commands.argument((String)"Index", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ChatBoxCommand.skipDialogues((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"Index")))))))).then(Commands.literal((String)"open").executes(ChatBoxCommand::openChatBox))).then(((LiteralArgumentBuilder)Commands.literal((String)"maxTriggerCount").then(Commands.argument((String)"Dialogues", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> SharedSuggestionProvider.suggestResource(ChatBoxDialoguesLoader.INSTANCE.dialoguesMap.keySet(), (SuggestionsBuilder)builder)).then(Commands.argument((String)"MaxTriggerCount", (ArgumentType)IntegerArgumentType.integer()).executes(ChatBoxCommand::setMaxTriggerCount)))).then(Commands.literal((String)"reset").executes(ChatBoxCommand::resetMaxTriggerCount)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"command").then(Commands.literal((String)"nextDialogue").executes(ChatBoxCommand::nextDialogue))).then(Commands.literal((String)"autoPlay").then(Commands.argument((String)"AutoPlay", (ArgumentType)BoolArgumentType.bool()).executes(ChatBoxCommand::autoPlay)))).then(Commands.literal((String)"isScreen").then(Commands.argument((String)"IsScreen", (ArgumentType)BoolArgumentType.bool()).executes(ChatBoxCommand::toggleIsScreen)))));
    }

    private static int toggleIsScreen(CommandContext<CommandSourceStack> context) {
        boolean isScreen = BoolArgumentType.getBool(context, (String)"IsScreen");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player != null) {
            player.connection.send((CustomPacketPayload)new ClientChatBoxPayload.SimplePayload("set_is_screen", String.valueOf(isScreen)));
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int autoPlay(CommandContext<CommandSourceStack> context) {
        boolean autoPlay = BoolArgumentType.getBool(context, (String)"AutoPlay");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player != null) {
            player.connection.send((CustomPacketPayload)new ClientChatBoxPayload.SimplePayload("auto_play", String.valueOf(autoPlay)));
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int nextDialogue(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player != null) {
            player.connection.send((CustomPacketPayload)new ClientChatBoxPayload.SimplePayload("next_dialogue", ""));
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int toggleTheme(CommandContext<CommandSourceStack> context) {
        ResourceLocation theme = ResourceLocationArgument.getId(context, (String)"Theme");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player != null) {
            ChatBoxCommandUtil.serverToggleTheme(player, theme);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.toggle.theme"), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int skipDialogues(CommandContext<CommandSourceStack> context, int index) {
        ResourceLocation dialogues = ResourceLocationArgument.getId(context, (String)"Dialogues");
        String group = StringArgumentType.getString(context, (String)"Group");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player != null) {
            ChatBoxCommandUtil.serverSkipDialogues(player, dialogues, group, index);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.skip.dialogues", (Object[])new Object[]{group, index + 1}), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int openChatBox(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player != null) {
            ChatBoxCommandUtil.serverOpenChatBox(player);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int setMaxTriggerCount(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player != null) {
            ResourceLocation dialogues = ResourceLocationArgument.getId(context, (String)"Dialogues");
            int maxTriggerCount = IntegerArgumentType.getInteger(context, (String)"MaxTriggerCount");
            ChatBoxCommandUtil.serverSetMaxTriggerCount(player, dialogues, maxTriggerCount);
            player.connection.send((CustomPacketPayload)new ClientChatBoxPayload.SetMaxTriggerCount(dialogues, maxTriggerCount));
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.set.max.trigger.count", (Object[])new Object[]{dialogues.toString(), maxTriggerCount}), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int resetMaxTriggerCount(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player != null) {
            ChatBoxCommandUtil.serverResetMaxTriggerCount(player);
            player.connection.send((CustomPacketPayload)new ClientChatBoxPayload.ResetMaxTriggerCount());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.reset.max.trigger.count"), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure(ERROR_PLAYER_ONLY);
        return 0;
    }
}

