/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.zhenshiz.chatbox.data.ChatBoxTheme;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.chatbox.RenderUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;

public abstract class AbstractComponent<T extends AbstractComponent<T>> {
    protected static final Minecraft minecraft = Minecraft.getInstance();
    public AlignX alignX;
    public AlignY alignY;
    public float x;
    public float y;
    public float width;
    public float height;
    public Float opacity;
    public Integer renderOrder;
    public Float angle;

    public static float getResponsiveWidth(float value) {
        return (float)minecraft.getWindow().getGuiScaledWidth() * value / 100.0f;
    }

    public static float getResponsiveHeight(float value) {
        return (float)minecraft.getWindow().getGuiScaledHeight() * value / 100.0f;
    }

    public T setDefaultOption(float x, float y, float width, float height, AlignX alignX, AlignY alignY, Float opacity, Integer renderOrder, Float angle) {
        this.setPosition(x, y);
        this.setSize(width, height);
        this.setAlign(alignX, alignY);
        this.setOpacity(opacity);
        this.setRenderOrder(renderOrder);
        this.setAngle(angle);
        return (T)this;
    }

    public T setPosition(float x, float y) {
        this.x = x;
        this.y = y;
        return (T)this;
    }

    public T setSize(float width, float height) {
        if (this.checkSize(width) && this.checkSize(height)) {
            this.width = width;
            this.height = height;
        }
        return (T)this;
    }

    public T setAlign(AlignX alignX, AlignY alignY) {
        return ((AbstractComponent)this.setAlignX(alignX)).setAlignY(alignY);
    }

    public T setAlignX(AlignX alignX) {
        if (alignX != null) {
            this.alignX = alignX;
        }
        return (T)this;
    }

    public T setAlignY(AlignY alignY) {
        if (alignY != null) {
            this.alignY = alignY;
        }
        return (T)this;
    }

    public T setOpacity(Float opacity) {
        if (opacity != null && this.checkSize(opacity.floatValue())) {
            this.opacity = opacity;
        }
        return (T)this;
    }

    public T setRenderOrder(Integer renderOrder) {
        if (renderOrder != null) {
            this.renderOrder = renderOrder;
        }
        return (T)this;
    }

    public T setAngle(Float angle) {
        if (angle != null) {
            this.angle = angle;
        }
        return (T)this;
    }

    public T build() {
        return (T)this;
    }

    protected boolean checkSize(float value) {
        return value > 0.0f;
    }

    protected Vec2 getCurrentPosition() {
        return new Vec2(this.alignX.getPositionX(this), this.alignY.getPositionY(this));
    }

    protected void renderImage(GuiGraphics guiGraphics, ResourceLocation texture) {
        this.renderImage(guiGraphics, texture, Float.valueOf(1.0f), List.of());
    }

    protected void renderImage(GuiGraphics guiGraphics, ResourceLocation texture, Float scale, List<ChatBoxTheme.Portrait.Attachment> attachments) {
        RenderUtil.renderOpacity(guiGraphics, this.opacity.floatValue() / 100.0f, () -> {
            Vec2 position = this.getCurrentPosition();
            RenderUtil.renderImage(guiGraphics, texture, AbstractComponent.getResponsiveWidth(position.x), AbstractComponent.getResponsiveHeight(position.y), 0.0f, AbstractComponent.getResponsiveWidth(this.width), AbstractComponent.getResponsiveHeight(this.height), scale.floatValue(), this.angle.floatValue(), attachments);
        });
    }

    public boolean isSelect(float width, float height, float x, float y, double mouseX, double mouseY) {
        return mouseX > (double)x && mouseX < (double)(x + width) && mouseY > (double)y && mouseY < (double)(y + height);
    }

    public boolean isSelect(double mouseX, double mouseY) {
        Vec2 position = this.getCurrentPosition();
        return this.isSelect(AbstractComponent.getResponsiveWidth(this.width), AbstractComponent.getResponsiveHeight(this.height), AbstractComponent.getResponsiveWidth((int)position.x), AbstractComponent.getResponsiveHeight((int)position.y), mouseX, mouseY);
    }

    protected String parseText(String input) {
        return ChatBoxUtil.parseText(input, false);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTick) {
    }

    public void render(GuiGraphics guiGraphics, float pPartialTick) {
    }

    public static enum AlignX {
        LEFT,
        CENTER,
        RIGHT;


        public static AlignX of(String value) {
            if (value == null) {
                return LEFT;
            }
            return AlignX.valueOf(value.toUpperCase());
        }

        public float getPositionX(AbstractComponent<?> abstractComponent) {
            float x = abstractComponent.x;
            float width = abstractComponent.width;
            AlignX alignX = abstractComponent.alignX;
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"LEFT", "CENTER", "RIGHT"}, (AlignX)alignX, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> x;
                case 1 -> x + 50.0f - width / 2.0f;
                case 2 -> x + 100.0f - width;
                case -1 -> x;
            };
        }
    }

    public static enum AlignY {
        TOP,
        CENTER,
        BOTTOM;


        public static AlignY of(String value) {
            if (value == null) {
                return TOP;
            }
            return AlignY.valueOf(value.toUpperCase());
        }

        public float getPositionY(AbstractComponent<?> abstractComponent) {
            float y = abstractComponent.y;
            float height = abstractComponent.height;
            AlignY alignY = abstractComponent.alignY;
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TOP", "CENTER", "BOTTOM"}, (AlignY)alignY, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> y;
                case 1 -> y + 50.0f - height / 2.0f;
                case 2 -> y + 100.0f - height;
                case -1 -> y;
            };
        }
    }
}

