/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.api.ChatOptionClickEvent;
import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.chatbox.RenderUtil;
import com.zhenshiz.chatbox.utils.common.StrUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;

public class ChatOption
extends AbstractComponent<ChatOption> {
    public ResourceLocation texture;
    public ResourceLocation selectTexture;
    public ResourceLocation lockTexture;
    public Component optionChat;
    public float optionChatX;
    public float optionChatY;
    public Runnable onClickEvent;
    public boolean isLock;
    public Component optionTooltip;
    public TextAlign textAlign;
    public String next;
    public boolean isSelect;

    public ChatOption() {
        this.setTextures(ChatBox.ResourceLocationMod("textures/options/default_no_checked_option.png"));
        this.setSelectTexture(ChatBox.ResourceLocationMod("textures/options/default_checked_option.png"));
        this.setLockTexture(ChatBox.ResourceLocationMod("textures/options/default_no_checked_option.png"));
        this.setOptionChat("", false);
        this.setOptionChatPosition(0.0f, 0.0f);
        this.setClickEvent(() -> {});
        this.setIsLock(false);
        this.setOptionTooltip("", false);
        this.setTextAlign(TextAlign.LEFT);
        this.setNext("");
        this.setIsSelect(false);
    }

    public ChatOption setOptionChat(String optionChat, boolean isTranslatable) {
        if (optionChat != null) {
            this.optionChat = isTranslatable ? Component.translatable((String)optionChat) : Component.nullToEmpty((String)optionChat);
        }
        return this;
    }

    public ChatOption setOptionTooltip(String optionTooltip, boolean isTranslatable) {
        if (optionTooltip != null) {
            this.optionTooltip = isTranslatable ? Component.translatable((String)optionTooltip) : Component.nullToEmpty((String)optionTooltip);
        }
        return this;
    }

    public ChatOption setTextures(ResourceLocation textures) {
        if (textures != null) {
            this.texture = textures;
        }
        return this;
    }

    public ChatOption setTextures(String textures) {
        if (textures != null) {
            return this.setTextures(ResourceLocation.tryParse((String)textures));
        }
        return this;
    }

    public ChatOption setSelectTexture(ResourceLocation selectTexture) {
        if (selectTexture != null) {
            this.selectTexture = selectTexture;
        }
        return this;
    }

    public ChatOption setSelectTexture(String selectTexture) {
        if (selectTexture != null) {
            return this.setSelectTexture(ResourceLocation.tryParse((String)selectTexture));
        }
        return this;
    }

    public ChatOption setLockTexture(ResourceLocation lockTexture) {
        if (lockTexture != null) {
            this.lockTexture = lockTexture;
        }
        return this;
    }

    public ChatOption setLockTexture(String lockTexture) {
        if (lockTexture != null) {
            return this.setLockTexture(ResourceLocation.tryParse((String)lockTexture));
        }
        return this;
    }

    public ChatOption setClickEvent(Runnable onClickEvent) {
        if (onClickEvent != null) {
            this.onClickEvent = onClickEvent;
        }
        return this;
    }

    public ChatOption setClickEvent(String type, String value) {
        if (type != null) {
            this.onClickEvent = () -> {
                if (ChatOption.minecraft.player != null && ChatOptionClickEvent.CLICK_EVENTS.containsKey(type.toUpperCase())) {
                    ChatOptionClickEvent.CLICK_EVENTS.get(type.toUpperCase()).execute(value == null ? "" : value);
                }
            };
        }
        return this;
    }

    public ChatOption setIsLock(boolean isLock) {
        this.isLock = isLock;
        return this;
    }

    public ChatOption setNext(String next) {
        if (next != null) {
            this.next = next;
        }
        return this;
    }

    public ChatOption setOptionChatPosition(float x, float y) {
        this.optionChatX = x;
        this.optionChatY = y;
        return this;
    }

    public ChatOption setTextAlign(TextAlign textAlign) {
        if (textAlign != null) {
            this.textAlign = textAlign;
        }
        return this;
    }

    public ChatOption setIsSelect(boolean isSelect) {
        this.isSelect = isSelect;
        return this;
    }

    public void click() {
        if (!this.isLock && ChatOption.minecraft.player != null) {
            this.onClickEvent.run();
            if (StrUtil.isEmpty(this.next)) {
                ChatBoxUtil.skipDialogues(ChatBoxUtil.dialoguesResourceLocation, ChatBoxUtil.group, ChatBoxUtil.index + 1);
            } else if (StrUtil.isInteger(this.next)) {
                int index = Integer.parseInt(this.next);
                ChatBoxUtil.skipDialogues(ChatBoxUtil.dialoguesResourceLocation, ChatBoxUtil.group, index);
            } else {
                ChatBoxUtil.skipDialogues(ChatBoxUtil.dialoguesResourceLocation, this.next);
            }
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTick) {
        Vec2 pos = this.getCurrentPosition();
        float x = pos.x;
        float y = pos.y;
        int color = -1;
        ResourceLocation texture = this.texture;
        if (this.isLock) {
            texture = this.lockTexture;
            color = -8355712;
        } else if (this.isSelect(mouseX, mouseY)) {
            texture = this.selectTexture;
            color = -256;
        }
        if (texture != null) {
            this.renderImage(guiGraphics, texture);
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        switch (this.textAlign.ordinal()) {
            case 0: {
                RenderUtil.drawLeftScaleText(guiGraphics, Component.nullToEmpty((String)this.parseText(this.optionChat.getString())), (int)ChatOption.getResponsiveWidth(x + this.width / 2.0f + this.optionChatX), (int)ChatOption.getResponsiveHeight(y + this.height / 2.0f + this.optionChatY), 1.0f, false, color);
                break;
            }
            case 1: {
                RenderUtil.drawCenterScaleText(guiGraphics, Component.nullToEmpty((String)this.parseText(this.optionChat.getString())), (int)ChatOption.getResponsiveWidth(x + this.width / 2.0f + this.optionChatX), (int)ChatOption.getResponsiveHeight(y + this.height / 2.0f + this.optionChatY), 1.0f, false, color);
                break;
            }
            case 2: {
                RenderUtil.drawRightScaleText(guiGraphics, Component.nullToEmpty((String)this.parseText(this.optionChat.getString())), (int)ChatOption.getResponsiveWidth(x + this.width / 2.0f + this.optionChatX), (int)ChatOption.getResponsiveHeight(y + this.height / 2.0f + this.optionChatY), 1.0f, false, color);
            }
        }
        poseStack.popPose();
        if (!this.optionTooltip.getString().isEmpty() && this.isSelect(mouseX, mouseY)) {
            guiGraphics.renderTooltip(ChatOption.minecraft.font, this.optionTooltip, mouseX, mouseY);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, float pPartialTick) {
        Vec2 pos = this.getCurrentPosition();
        float x = pos.x;
        float y = pos.y;
        int color = -1;
        ResourceLocation texture = this.texture;
        if (this.isLock) {
            texture = this.lockTexture;
            color = -8355712;
        } else if (this.isSelect) {
            texture = this.selectTexture;
            color = -256;
        }
        if (texture != null) {
            this.renderImage(guiGraphics, texture);
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        switch (this.textAlign.ordinal()) {
            case 0: {
                RenderUtil.drawLeftScaleText(guiGraphics, Component.nullToEmpty((String)this.parseText(this.optionChat.getString())), (int)ChatOption.getResponsiveWidth(x + this.width / 2.0f + this.optionChatX), (int)ChatOption.getResponsiveHeight(y + this.height / 2.0f + this.optionChatY), 1.0f, false, color);
                break;
            }
            case 1: {
                RenderUtil.drawCenterScaleText(guiGraphics, Component.nullToEmpty((String)this.parseText(this.optionChat.getString())), (int)ChatOption.getResponsiveWidth(x + this.width / 2.0f + this.optionChatX), (int)ChatOption.getResponsiveHeight(y + this.height / 2.0f + this.optionChatY), 1.0f, false, color);
                break;
            }
            case 2: {
                RenderUtil.drawRightScaleText(guiGraphics, Component.nullToEmpty((String)this.parseText(this.optionChat.getString())), (int)ChatOption.getResponsiveWidth(x + this.width / 2.0f + this.optionChatX), (int)ChatOption.getResponsiveHeight(y + this.height / 2.0f + this.optionChatY), 1.0f, false, color);
            }
        }
        poseStack.popPose();
    }

    public static enum TextAlign {
        LEFT,
        CENTER,
        RIGHT;


        public static TextAlign of(String text) {
            if (text == null) {
                return LEFT;
            }
            return TextAlign.valueOf(text.toUpperCase());
        }
    }
}

