/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.Config;
import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.common.StrUtil;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;

public class DialogBox
extends AbstractComponent<DialogBox> {
    public ResourceLocation texture;
    public String text;
    public float textX;
    public float textY;
    public Component name;
    public float nameX;
    public float nameY;
    public float lineWidth;
    public boolean isAllOver;
    public int tickCount;
    private String[] textBuffer;
    private int charIndex;

    public DialogBox() {
        this.setTexture(ChatBox.ResourceLocationMod("textures/chatbox/default_dialog_box.png"));
        this.setText("", false);
        this.setTextPosition(0.0f, 0.0f);
        this.setName("", false);
        this.setNamePosition(0.0f, 0.0f);
        this.setLineWidth(Float.valueOf(100.0f));
        this.setAllOver(false);
        this.resetTickCount();
        this.textBuffer = new String[]{""};
    }

    public DialogBox setTexture(ResourceLocation texture) {
        if (texture != null) {
            this.texture = texture;
        }
        return this;
    }

    public DialogBox setTexture(String texture) {
        if (texture != null) {
            return this.setTexture(ResourceLocation.tryParse((String)texture));
        }
        return this;
    }

    public DialogBox setText(String text, boolean isTranslatable) {
        if (text != null) {
            String string = this.text = isTranslatable ? Language.getInstance().getOrDefault(text) : text;
            if (ChatBox.isTextAnimatorLoaded()) {
                this.text = this.text.replaceAll("<typewriter>", "");
            }
            this.textToTextBuffer();
        }
        return this;
    }

    public DialogBox setName(String name, boolean isTranslatable) {
        if (name != null) {
            this.name = isTranslatable ? Component.translatable((String)name) : Component.nullToEmpty((String)name);
        }
        return this;
    }

    public DialogBox setNamePosition(float x, float y) {
        this.nameX = x;
        this.nameY = y;
        return this;
    }

    public DialogBox setTextPosition(float x, float y) {
        this.textX = x;
        this.textY = y;
        return this;
    }

    public DialogBox setLineWidth(Float lineWidth) {
        if (this.checkSize(lineWidth.floatValue())) {
            this.lineWidth = lineWidth.floatValue();
        }
        return this;
    }

    public DialogBox setAllOver(boolean allOver) {
        this.isAllOver = allOver;
        return this;
    }

    public DialogBox resetTickCount() {
        this.tickCount = 0;
        this.charIndex = 0;
        return this;
    }

    private void textToTextBuffer() {
        String input = this.text;
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int index = 0; index < input.length(); ++index) {
            int closing;
            char c = input.charAt(index);
            stringBuilder.append(c);
            if (c == '\\' || c == '\u00a7') {
                stringBuilder.append(input.charAt(index + 1));
                ++index;
            }
            if (ChatBox.isTextAnimatorLoaded() && c == '<' && (closing = input.indexOf(62, index + 1)) != -1) {
                stringBuilder.append(input, index + 1, closing + 1);
                index = closing;
            }
            result.add(stringBuilder.toString());
        }
        this.textBuffer = result.toArray(new String[0]);
    }

    public void click(boolean gotoNext) {
        if (!this.isAllOver) {
            this.charIndex = this.textBuffer.length - 1;
            this.setAllOver(true);
        } else if (gotoNext && DialogBox.minecraft.player != null) {
            ChatBoxUtil.skipDialogues(ChatBoxUtil.dialoguesResourceLocation, ChatBoxUtil.group, ChatBoxUtil.index + 1);
            ChatBoxUtil.chatBoxScreen.tickAutoPlay = 20;
        }
    }

    public void tick() {
        if (!this.isAllOver) {
            if (this.charIndex == this.textBuffer.length - 1) {
                this.setAllOver(true);
                return;
            }
            ++this.tickCount;
            float charPerTick = (float)((Integer)Config.charPerSecond.get()).intValue() / 20.0f;
            if ((float)this.tickCount * charPerTick >= (float)(this.charIndex + 1)) {
                this.charIndex = Math.min((int)((float)this.tickCount * charPerTick), this.textBuffer.length - 1);
            }
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTick) {
        if (this.texture != null) {
            this.renderImage(guiGraphics, this.texture);
        }
        Vec2 position = this.getCurrentPosition();
        float x = position.x;
        float y = position.y;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        if (StrUtil.isNotEmpty(this.name.getString())) {
            guiGraphics.drawWordWrap(DialogBox.minecraft.font, (FormattedText)Component.nullToEmpty((String)this.parseText(StrUtil.format("[{}]", this.name.getString()))), (int)DialogBox.getResponsiveWidth(x + this.nameX), (int)DialogBox.getResponsiveHeight(y + this.nameY), (int)DialogBox.getResponsiveWidth(this.lineWidth), -1);
        }
        if (StrUtil.isNotEmpty(this.text)) {
            guiGraphics.drawWordWrap(DialogBox.minecraft.font, (FormattedText)Component.nullToEmpty((String)this.parseText(this.textBuffer[this.charIndex])), (int)DialogBox.getResponsiveWidth(x + this.textX), (int)DialogBox.getResponsiveHeight(y + this.textY), (int)DialogBox.getResponsiveWidth(this.lineWidth), -1);
        }
        poseStack.popPose();
    }

    @Override
    public void render(GuiGraphics guiGraphics, float pPartialTick) {
        this.render(guiGraphics, 0, 0, pPartialTick);
    }
}

