/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.screen.ChatBoxScreen;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.chatbox.RenderUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;

public class FunctionalButton
extends AbstractComponent<FunctionalButton> {
    public ResourceLocation texture;
    public ResourceLocation hoverTexture;
    public final Type type;
    private final ChatBoxScreen chatBoxScreen = ChatBoxUtil.chatBoxScreen;

    public FunctionalButton(Type type) {
        this.type = type;
        switch (type.ordinal()) {
            case 0: {
                this.setTexture(ChatBox.ResourceLocationMod("textures/button/default_log.png"));
                this.setHoverTexture(ChatBox.ResourceLocationMod("textures/button/default_hover_log.png"));
                break;
            }
            case 1: {
                this.setTexture(ChatBox.ResourceLocationMod("textures/button/default_fastforward.png"));
                this.setHoverTexture(ChatBox.ResourceLocationMod("textures/button/default_hover_fastforward.png"));
                break;
            }
            case 2: {
                this.setTexture(ChatBox.ResourceLocationMod("textures/button/default_autoplay.png"));
                this.setHoverTexture(ChatBox.ResourceLocationMod("textures/button/default_hover_autoplay.png"));
            }
        }
    }

    public FunctionalButton setTexture(ResourceLocation texture) {
        if (texture != null) {
            this.texture = texture;
        }
        return this;
    }

    public FunctionalButton setTexture(String texture) {
        if (texture != null) {
            this.setTexture(ResourceLocation.tryParse((String)texture));
        }
        return this;
    }

    public FunctionalButton setHoverTexture(ResourceLocation hoverTexture) {
        if (hoverTexture != null) {
            this.hoverTexture = hoverTexture;
        }
        return this;
    }

    public FunctionalButton setHoverTexture(String hoverTexture) {
        if (hoverTexture != null) {
            this.setHoverTexture(ResourceLocation.tryParse((String)hoverTexture));
        }
        return this;
    }

    public void click() {
        if (FunctionalButton.minecraft.player != null) {
            switch (this.type.ordinal()) {
                case 0: {
                    minecraft.setScreen((Screen)ChatBoxUtil.historicalDialogue);
                    break;
                }
                case 1: {
                    this.chatBoxScreen.fastForward = true;
                    this.chatBoxScreen.autoPlay = false;
                    break;
                }
                case 2: {
                    this.chatBoxScreen.autoPlay = !this.chatBoxScreen.autoPlay;
                }
            }
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTick) {
        ResourceLocation texture = this.texture;
        if (this.isSelect(mouseX, mouseY)) {
            texture = this.hoverTexture;
        }
        if (this.type == Type.AUTOPLAY && this.chatBoxScreen.autoPlay) {
            texture = this.hoverTexture;
        }
        if (this.type == Type.FASTFORWARD && this.chatBoxScreen.fastForward) {
            texture = this.hoverTexture;
        }
        if (texture != null) {
            this.renderImage(guiGraphics, texture);
        }
        if (this.isSelect(mouseX, mouseY)) {
            MutableComponent text = switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Component.translatable((String)"chatbox.button.log");
                case 1 -> Component.translatable((String)"chatbox.button.fast_forward");
                case 2 -> Component.translatable((String)"chatbox.button.autoplay");
            };
            Vec2 position = this.getCurrentPosition();
            RenderUtil.drawCenterScaleText(guiGraphics, (Component)text, (int)FunctionalButton.getResponsiveWidth(position.x), (int)FunctionalButton.getResponsiveHeight(position.y) - 12, 1.0f, false, 0xFFFFFF);
        }
    }

    public static enum Type {
        LOG,
        FASTFORWARD,
        AUTOPLAY;


        public static Type of(String type) {
            return Type.valueOf(type.toUpperCase());
        }
    }
}

