/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.data.ChatBoxTheme;
import com.zhenshiz.chatbox.utils.chatbox.RenderUtil;
import com.zhenshiz.chatbox.utils.common.CollUtil;
import com.zhenshiz.chatbox.utils.math.EasingUtil;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.phys.Vec2;

public class Portrait
extends AbstractComponent<Portrait> {
    public Type type;
    public String value;
    public String animationType;
    public Float scale;
    public Integer customItemData;
    public List<ChatBoxTheme.Portrait.CustomAnimation> customAnimation;
    public Boolean loop;
    private final ChatBoxTheme.Portrait.CustomAnimation targetCustomAnimation = new ChatBoxTheme.Portrait.CustomAnimation();
    private final ChatBoxTheme.Portrait.CustomAnimation startCustomAnimation = new ChatBoxTheme.Portrait.CustomAnimation();
    public List<ChatBoxTheme.Portrait.Attachment> attachments;
    public String id;
    private boolean isAnimation = false;
    private int currentAnimationTick = 0;
    private int customAnimationIndex = 0;

    public Portrait(Type type, String animationType, List<ChatBoxTheme.Portrait.CustomAnimation> customAnimation, Float scale, Boolean loop) {
        this.setType(type).setAnimationType(animationType).setCustomAnimation(customAnimation).setLoop(loop).setScale(scale).build();
    }

    public Portrait createTexture(Portrait portrait, String value, List<ChatBoxTheme.Portrait.Attachment> attachments) {
        return portrait.setValue(value).setAttachment(attachments);
    }

    public Portrait createPlayerHead(Portrait portrait, String value) {
        return portrait.setValue(value);
    }

    public Portrait createItem(Portrait portrait, String value, Integer customItemData) {
        return portrait.setValue(value).setCustomItemData(customItemData);
    }

    public Portrait setAttachment(List<ChatBoxTheme.Portrait.Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public Portrait setScale(Float scale) {
        if (scale != null) {
            this.scale = scale;
        }
        return this;
    }

    public Portrait setType(Type type) {
        if (type != null) {
            this.type = type;
        }
        return this;
    }

    public Portrait setValue(String value) {
        if (value != null) {
            this.value = value;
        }
        return this;
    }

    public Portrait setCustomItemData(Integer customItemData) {
        if (customItemData != null) {
            this.customItemData = customItemData;
        }
        return this;
    }

    public Portrait setAnimationType(String animationType) {
        if (animationType != null) {
            this.animationType = animationType;
        }
        return this;
    }

    public Portrait setIsAnimation(Boolean isAnimation) {
        if (isAnimation != null) {
            this.isAnimation = isAnimation;
        }
        return this;
    }

    public Portrait setCustomAnimation(List<ChatBoxTheme.Portrait.CustomAnimation> customAnimation) {
        if (!CollUtil.isEmpty(customAnimation).booleanValue()) {
            this.customAnimation = customAnimation;
        }
        return this;
    }

    public Portrait setLoop(Boolean loop) {
        if (loop != null) {
            this.loop = loop;
        }
        return this;
    }

    public void resetCurrentAnimationTick() {
        this.currentAnimationTick = 0;
    }

    public void setCustomAnimationIndex(Integer customAnimationIndex) {
        if (customAnimationIndex != null) {
            this.customAnimationIndex = customAnimationIndex;
        }
    }

    public void setTarget(float x, float y, float scale, float opacity, float angle) {
        this.targetCustomAnimation.x = Float.valueOf(x);
        this.targetCustomAnimation.y = Float.valueOf(y);
        this.targetCustomAnimation.scale = Float.valueOf(scale);
        this.targetCustomAnimation.opacity = Float.valueOf(opacity);
        this.targetCustomAnimation.angle = Float.valueOf(angle);
    }

    public void setStart(float x, float y, float scale, float opacity, float angle) {
        this.startCustomAnimation.x = Float.valueOf(x);
        this.startCustomAnimation.y = Float.valueOf(y);
        this.startCustomAnimation.scale = Float.valueOf(scale);
        this.startCustomAnimation.opacity = Float.valueOf(opacity);
        this.startCustomAnimation.angle = Float.valueOf(angle);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTick) {
        if (this.type != null && this.value != null) {
            Vec2 position = this.getCurrentPosition();
            float x = position.x;
            float y = position.y;
            if (this.isAnimation) {
                ++this.currentAnimationTick;
                this.execCustomAnimation();
            }
            switch (this.type.ordinal()) {
                case 0: {
                    this.renderImage(guiGraphics, ResourceLocation.parse((String)this.value), this.scale, this.attachments);
                    break;
                }
                case 1: {
                    RenderUtil.renderOpacity(guiGraphics, this.opacity.floatValue() / 100.0f, () -> RenderUtil.renderPlayerHead(guiGraphics, this.parseText(this.value), (int)Portrait.getResponsiveWidth(x), (int)Portrait.getResponsiveHeight(y), (int)(Portrait.getResponsiveWidth(this.width) + Portrait.getResponsiveHeight(this.height)), this.scale.floatValue(), this.angle.floatValue()));
                    break;
                }
                case 2: {
                    ItemStack itemStack = ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)this.value))).getDefaultInstance();
                    if (this.customItemData != null) {
                        itemStack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(this.customItemData.intValue()));
                    }
                    RenderUtil.renderOpacity(guiGraphics, this.opacity.floatValue() / 100.0f, () -> RenderUtil.renderItem(guiGraphics, itemStack, (int)Portrait.getResponsiveWidth(x), (int)Portrait.getResponsiveHeight(y), this.scale.floatValue(), this.angle.floatValue()));
                }
            }
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, float pPartialTick) {
        this.render(guiGraphics, 0, 0, pPartialTick);
    }

    private void execCustomAnimation() {
        ChatBoxTheme.Portrait.CustomAnimation animation = this.customAnimation.get(this.customAnimationIndex);
        if (this.type.equals((Object)Type.TEXTURE) && animation.texture != null) {
            this.setValue(animation.texture);
        }
        float curX = this.targetCustomAnimation.x.floatValue();
        float curY = this.targetCustomAnimation.y.floatValue();
        if (animation.x != null) {
            curX = EasingUtil.easingFunction(this.targetCustomAnimation.x.floatValue(), animation.x.floatValue(), this.currentAnimationTick, animation.time.intValue(), animation.easing);
        }
        if (animation.y != null) {
            curY = EasingUtil.easingFunction(this.targetCustomAnimation.y.floatValue(), animation.y.floatValue(), this.currentAnimationTick, animation.time.intValue(), animation.easing);
        }
        if (animation.xOffset != null) {
            curX += EasingUtil.easingFunction(0.0f, animation.xOffset.floatValue(), this.currentAnimationTick, animation.time.intValue(), animation.easing);
        }
        if (animation.yOffset != null) {
            curY += EasingUtil.easingFunction(0.0f, animation.yOffset.floatValue(), this.currentAnimationTick, animation.time.intValue(), animation.easing);
        }
        this.setPosition(curX, curY);
        if (animation.scale != null) {
            this.setScale(Float.valueOf(EasingUtil.easingFunction(this.targetCustomAnimation.scale.floatValue(), animation.scale.floatValue(), this.currentAnimationTick, animation.time.intValue(), animation.easing)));
        }
        if (animation.opacity != null) {
            this.setOpacity(Float.valueOf(EasingUtil.easingFunction(this.targetCustomAnimation.opacity.floatValue(), animation.opacity.floatValue(), this.currentAnimationTick, animation.time.intValue(), animation.easing)));
        }
        if (animation.angle != null) {
            this.setAngle(Float.valueOf(EasingUtil.easingFunction(this.targetCustomAnimation.angle.floatValue(), animation.angle.floatValue(), this.currentAnimationTick, animation.time.intValue(), animation.easing)));
        }
        if (this.currentAnimationTick >= animation.time) {
            this.setTarget(this.x, this.y, this.scale.floatValue(), this.opacity.floatValue(), this.angle.floatValue());
            this.setCustomAnimationIndex(this.customAnimationIndex + 1);
            this.resetCurrentAnimationTick();
            if (this.customAnimationIndex >= this.customAnimation.size()) {
                if (this.loop.booleanValue()) {
                    this.setCustomAnimationIndex(0);
                    this.setTarget(this.startCustomAnimation.x.floatValue(), this.startCustomAnimation.y.floatValue(), this.startCustomAnimation.scale.floatValue(), this.startCustomAnimation.opacity.floatValue(), this.startCustomAnimation.angle.floatValue());
                    this.setPosition(this.startCustomAnimation.x.floatValue(), this.startCustomAnimation.y.floatValue());
                    this.setScale(this.startCustomAnimation.scale);
                    this.setOpacity(this.startCustomAnimation.opacity);
                    this.setAngle(this.startCustomAnimation.angle);
                } else {
                    this.setIsAnimation(false);
                }
            }
        }
    }

    public static enum Type {
        TEXTURE,
        PLAYER_HEAD,
        ITEM;


        public static Type of(String type) {
            return Type.valueOf(type.toUpperCase());
        }
    }
}

