/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.data;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.data.ChatBoxDialogues;
import com.zhenshiz.chatbox.event.ChatBoxSettingLoader;
import com.zhenshiz.chatbox.network.s2c.ClientChatBoxPayload;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxCommandUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class ChatBoxDialoguesLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final ChatBoxDialoguesLoader INSTANCE = new ChatBoxDialoguesLoader();
    public final Map<ResourceLocation, String> dialoguesMap = new HashMap<ResourceLocation, String>();
    public static final Map<ResourceLocation, Set<String>> dialoguesGroupMap = new HashMap<ResourceLocation, Set<String>>();
    private static final Map<ResourceLocation, JsonElement> criteriaElements = new HashMap<ResourceLocation, JsonElement>();
    private static final Map<ResourceLocation, Map<String, Map<String, Criterion<?>>>> dialoguesCriteriaMap = new HashMap();
    private static final Codec<Map<String, Criterion<?>>> CRITERIA_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Criterion.CODEC).validate(map -> map.isEmpty() ? DataResult.error(() -> "Advancement criteria cannot be empty") : DataResult.success((Object)map));

    public ChatBoxDialoguesLoader() {
        super(GSON, "chatbox/dialogues");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        this.dialoguesMap.clear();
        dialoguesGroupMap.clear();
        criteriaElements.clear();
        dialoguesCriteriaMap.clear();
        resourceLocationJsonElementMap.forEach((resourceLocation, jsonElement) -> this.dialoguesMap.put((ResourceLocation)resourceLocation, jsonElement.toString()));
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers().forEach(serverPlayer -> serverPlayer.connection.send((CustomPacketPayload)new ClientChatBoxPayload.AllChatBoxDialoguesToClient(ChatBoxSettingLoader.cutString(this.dialoguesMap))));
            ChatBoxDialoguesLoader.loadCriteria(ServerLifecycleHooks.getCurrentServer());
        }
        this.setDialogues(this.dialoguesMap);
    }

    private void setDialogues(Map<ResourceLocation, String> map) {
        map.forEach((resourceLocation, str) -> {
            JsonElement jsonElement = (JsonElement)GSON.fromJson(str, JsonElement.class);
            if (jsonElement == null) {
                return;
            }
            JsonElement dialoguesElement = jsonElement.getAsJsonObject().get("dialogues");
            if (dialoguesElement != null) {
                ChatBoxDialogues chatBoxDialogues = (ChatBoxDialogues)GSON.fromJson(jsonElement, new TypeToken<ChatBoxDialogues>(){}.getType());
                dialoguesGroupMap.put((ResourceLocation)resourceLocation, chatBoxDialogues.dialogues.keySet());
                JsonElement criteria = jsonElement.getAsJsonObject().get("criteria");
                if (criteria != null) {
                    criteriaElements.put((ResourceLocation)resourceLocation, criteria);
                }
            }
        });
    }

    public static <T extends SimpleCriterionTrigger.SimpleInstance> void triggerDialog(ServerPlayer player, Predicate<T> testTrigger) {
        for (Map.Entry<ResourceLocation, Map<String, Map<String, Criterion<?>>>> entry : dialoguesCriteriaMap.entrySet()) {
            ResourceLocation rl = entry.getKey();
            Map<String, Map<String, Criterion<?>>> groupWithCriteria = entry.getValue();
            for (Map.Entry<String, Map<String, Criterion<?>>> entry1 : groupWithCriteria.entrySet()) {
                String group = entry1.getKey();
                Map<String, Criterion<?>> criteria = entry1.getValue();
                for (Map.Entry<String, Criterion<?>> entry2 : criteria.entrySet()) {
                    Criterion<?> criterion = entry2.getValue();
                    CriterionTriggerInstance instance = criterion.triggerInstance();
                    try {
                        SimpleCriterionTrigger.SimpleInstance t = (SimpleCriterionTrigger.SimpleInstance)instance;
                        if (!testTrigger.test(t)) continue;
                        ChatBoxCommandUtil.serverSkipDialogues(player, rl, group);
                    }
                    catch (ClassCastException e) {}
                }
            }
        }
    }

    public static void loadCriteria(MinecraftServer server) {
        for (Map.Entry<ResourceLocation, JsonElement> entry : criteriaElements.entrySet()) {
            ResourceLocation rl = entry.getKey();
            JsonElement criteriaElement = entry.getValue();
            String group = (String)dialoguesGroupMap.get(rl).stream().toList().getFirst();
            RegistryOps registryOps = server.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            try {
                Map criteria = (Map)CRITERIA_CODEC.parse((DynamicOps)registryOps, (Object)criteriaElement).getOrThrow(JsonParseException::new);
                HashMap<String, Map> groupCriteriaMap = new HashMap<String, Map>();
                groupCriteriaMap.put(group, criteria);
                dialoguesCriteriaMap.put(rl, groupCriteriaMap);
            }
            catch (Exception var6x) {
                ChatBox.LOGGER.error("Parsing error loading dialog {}: {}", (Object)rl, (Object)var6x.getMessage());
            }
        }
    }
}

