/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.event;

import com.zhenshiz.chatbox.data.ChatBoxDialoguesLoader;
import com.zhenshiz.chatbox.data.ChatBoxThemeLoader;
import com.zhenshiz.chatbox.network.s2c.ClientChatBoxPayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;

@EventBusSubscriber(modid="chatbox")
public class ChatBoxSettingLoader {
    private static final int STRING_SIZE_LIMIT = 32000;

    @SubscribeEvent
    public static void chatBoxLoader(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)ChatBoxThemeLoader.INSTANCE);
        event.addListener((PreparableReloadListener)ChatBoxDialoguesLoader.INSTANCE);
    }

    @SubscribeEvent
    public static void initializeChatBoxScreen(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        player.connection.send((CustomPacketPayload)new ClientChatBoxPayload.AllChatBoxThemeToClient(ChatBoxSettingLoader.cutString(ChatBoxThemeLoader.INSTANCE.themeMap)));
        player.connection.send((CustomPacketPayload)new ClientChatBoxPayload.AllChatBoxDialoguesToClient(ChatBoxSettingLoader.cutString(ChatBoxDialoguesLoader.INSTANCE.dialoguesMap)));
    }

    @SubscribeEvent
    public static void initializeServer(ServerStartingEvent event) {
        ChatBoxDialoguesLoader.loadCriteria(event.getServer());
    }

    public static Map<ResourceLocation, List<String>> cutString(Map<ResourceLocation, String> map) {
        HashMap<ResourceLocation, List<String>> result = new HashMap<ResourceLocation, List<String>>();
        for (Map.Entry<ResourceLocation, String> entry : map.entrySet()) {
            ResourceLocation rl = entry.getKey();
            String data = entry.getValue();
            ArrayList<String> parts = new ArrayList<String>();
            for (int i = 0; i < data.length(); i += 32000) {
                parts.add(data.substring(i, Math.min(i + 32000, data.length())));
            }
            result.put(rl, parts);
        }
        return result;
    }
}

