/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.network.s2c;

import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.data.ChatBoxTriggerCount;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxCommandUtil;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ClientChatBoxPayload {
    private static Map<ResourceLocation, String> mergeString(Map<ResourceLocation, List<String>> map) {
        HashMap<ResourceLocation, String> result = new HashMap<ResourceLocation, String>();
        for (Map.Entry<ResourceLocation, List<String>> entry : map.entrySet()) {
            ResourceLocation rl = entry.getKey();
            List<String> parts = entry.getValue();
            StringBuilder builder = new StringBuilder();
            for (String part : parts) {
                builder.append(part);
            }
            result.put(rl, builder.toString());
        }
        return result;
    }

    public record SimplePayload(String name, String value) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SimplePayload> TYPE = new CustomPacketPayload.Type(ChatBox.ResourceLocationMod("simple_payload"));
        public static final StreamCodec<FriendlyByteBuf, SimplePayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SimplePayload::name, (StreamCodec)ByteBufCodecs.STRING_UTF8, SimplePayload::value, SimplePayload::new);
        private static final Map<String, Consumer<String>> handlers = new HashMap<String, Consumer<String>>();

        public static void execute(SimplePayload payload, IPayloadContext context) {
            String name = payload.name();
            String value = payload.value();
            if (handlers.containsKey(name)) {
                handlers.get(name).accept(value);
            }
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        static {
            handlers.put("open_dialog", s -> ChatBoxCommandUtil.clientOpenChatBox());
            handlers.put("set_theme", ChatBoxCommandUtil::clientToggleTheme);
            handlers.put("next_dialogue", s -> ChatBoxCommandUtil.clientNextDialogue());
            handlers.put("auto_play", s -> ChatBoxCommandUtil.clientAutoPlay(Boolean.parseBoolean(s)));
            handlers.put("set_is_screen", s -> ChatBoxCommandUtil.clientSetIsScreen(Boolean.parseBoolean(s)));
        }
    }

    public record ResetMaxTriggerCount() implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ResetMaxTriggerCount> TYPE = new CustomPacketPayload.Type(ChatBox.ResourceLocationMod("client_reset_max_trigger_count"));
        public static final StreamCodec<FriendlyByteBuf, ResetMaxTriggerCount> CODEC = StreamCodec.ofMember(ResetMaxTriggerCount::write, ResetMaxTriggerCount::new);

        public ResetMaxTriggerCount(FriendlyByteBuf friendlyByteBuf) {
            this();
        }

        private void write(FriendlyByteBuf buf) {
        }

        public static void execute(ResetMaxTriggerCount payload, IPayloadContext context) {
            ChatBoxCommandUtil.clientResetMaxTriggerCount();
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record SetMaxTriggerCountPlus(ChatBoxTriggerCount.MaxTriggerCount maxTriggerCount) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SetMaxTriggerCountPlus> TYPE = new CustomPacketPayload.Type(ChatBox.ResourceLocationMod("client_set_max_trigger_count_plus"));
        public static final StreamCodec<FriendlyByteBuf, SetMaxTriggerCountPlus> CODEC = StreamCodec.composite(ChatBoxTriggerCount.MaxTriggerCount.STREAM_CODEC, SetMaxTriggerCountPlus::maxTriggerCount, SetMaxTriggerCountPlus::new);

        public static void execute(SetMaxTriggerCountPlus payload, IPayloadContext context) {
            ChatBoxTriggerCount.MaxTriggerCount maxTriggerCount = payload.maxTriggerCount();
            context.player().setData(ChatBoxTriggerCount.MAX_TRIGGER_COUNT, (Object)maxTriggerCount);
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record SetMaxTriggerCount(ResourceLocation resourceLocation, int maxTriggerCount) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SetMaxTriggerCount> TYPE = new CustomPacketPayload.Type(ChatBox.ResourceLocationMod("client_set_max_trigger_count"));
        public static final StreamCodec<FriendlyByteBuf, SetMaxTriggerCount> CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, SetMaxTriggerCount::resourceLocation, (StreamCodec)ByteBufCodecs.INT, SetMaxTriggerCount::maxTriggerCount, SetMaxTriggerCount::new);

        public static void execute(SetMaxTriggerCount payload, IPayloadContext context) {
            ChatBoxCommandUtil.clientSetMaxTriggerCount(payload.resourceLocation(), payload.maxTriggerCount());
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record AllChatBoxDialoguesToClient(Map<ResourceLocation, List<String>> dialoguesMap) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<AllChatBoxDialoguesToClient> TYPE = new CustomPacketPayload.Type(ChatBox.ResourceLocationMod("all_chat_box_dialogues_to_client"));
        public static final StreamCodec<FriendlyByteBuf, AllChatBoxDialoguesToClient> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.STRING_UTF8)), AllChatBoxDialoguesToClient::dialoguesMap, AllChatBoxDialoguesToClient::new);

        public static void execute(AllChatBoxDialoguesToClient payload, IPayloadContext context) {
            ChatBoxUtil.setDialogues(ClientChatBoxPayload.mergeString(payload.dialoguesMap()));
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record AllChatBoxThemeToClient(Map<ResourceLocation, List<String>> themeMap) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<AllChatBoxThemeToClient> TYPE = new CustomPacketPayload.Type(ChatBox.ResourceLocationMod("all_chat_box_theme_to_client"));
        public static final StreamCodec<FriendlyByteBuf, AllChatBoxThemeToClient> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.STRING_UTF8)), AllChatBoxThemeToClient::themeMap, AllChatBoxThemeToClient::new);

        public static void execute(AllChatBoxThemeToClient payload, IPayloadContext context) {
            ResourceLocation theme;
            ChatBoxUtil.setTheme(ClientChatBoxPayload.mergeString(payload.themeMap()));
            if (ChatBoxUtil.themeResourceLocation != null && (theme = ResourceLocation.tryParse((String)ChatBoxUtil.themeResourceLocation)) != null) {
                ChatBoxUtil.toggleTheme(theme);
            }
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record OpenScreenPayload(ResourceLocation dialogues, String group, int index) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<OpenScreenPayload> TYPE = new CustomPacketPayload.Type(ChatBox.ResourceLocationMod("open_screen"));
        public static final StreamCodec<FriendlyByteBuf, OpenScreenPayload> CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, OpenScreenPayload::dialogues, (StreamCodec)ByteBufCodecs.STRING_UTF8, OpenScreenPayload::group, (StreamCodec)ByteBufCodecs.INT, OpenScreenPayload::index, OpenScreenPayload::new);

        public static void execute(OpenScreenPayload payload, IPayloadContext context) {
            ChatBoxCommandUtil.clientSkipDialogues(payload.dialogues(), payload.group(), payload.index());
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

