/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.render;

import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.component.ChatOption;
import com.zhenshiz.chatbox.event.neoforge.ChatBoxRenderEvent;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.chatbox.RenderUtil;
import com.zhenshiz.chatbox.utils.common.CollUtil;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.common.NeoForge;

@EventBusSubscriber(modid="chatbox", value={Dist.CLIENT})
public class ChatBoxRender {
    public static Boolean isOpenChatBox = false;
    public static int selectIndex = 0;
    private static final Minecraft minecraft = Minecraft.getInstance();

    @SubscribeEvent
    public static void ChatBoxRenderEvent(RenderGuiEvent.Pre event) {
        if (ChatBoxRender.isRenderChatBox()) {
            GuiGraphics guiGraphics = event.getGuiGraphics();
            float partialTick = event.getPartialTick().getGameTimeDeltaTicks();
            if (((ChatBoxRenderEvent.Pre)NeoForge.EVENT_BUS.post((Event)new ChatBoxRenderEvent.Pre(guiGraphics))).isCanceled()) {
                return;
            }
            if (ChatBoxUtil.chatBoxScreen.backgroundImage != null) {
                RenderUtil.renderImage(guiGraphics, ChatBoxUtil.chatBoxScreen.backgroundImage, 0.0f, 0.0f, 0.0f, RenderUtil.screenWidth(), RenderUtil.screenHeight(), 1.0f, 0.0f);
            }
            ArrayList<AbstractComponent> list = new ArrayList<AbstractComponent>();
            list.add(ChatBoxUtil.chatBoxScreen.dialogBox);
            if (ChatBoxUtil.chatBoxScreen.video != null) {
                list.add(ChatBoxUtil.chatBoxScreen.video);
            }
            if (ChatBoxUtil.chatBoxScreen.chatOptions != null) {
                list.addAll(ChatBoxUtil.chatBoxScreen.chatOptions);
            }
            if (ChatBoxUtil.chatBoxScreen.portraits != null) {
                list.addAll(ChatBoxUtil.chatBoxScreen.portraits);
            }
            if (ChatBoxUtil.chatBoxScreen.keyPromptRender != null) {
                list.add(ChatBoxUtil.chatBoxScreen.keyPromptRender);
            }
            list.sort(Comparator.comparingInt(p -> p.renderOrder));
            list.forEach(abstractComponent -> abstractComponent.render(guiGraphics, partialTick));
            NeoForge.EVENT_BUS.post((Event)new ChatBoxRenderEvent.Post(guiGraphics));
        }
    }

    @SubscribeEvent
    public static void ChatBoxRenderTick(ClientTickEvent.Post event) {
        if (ChatBoxRender.isRenderChatBox()) {
            ChatBoxUtil.chatBoxScreen.tick();
        }
    }

    @SubscribeEvent
    public static void ChatBoxRenderKeyInput(InputEvent.Key event) {
        if (ChatBoxRender.isRenderChatBox() && ChatBoxUtil.chatBoxScreen.keyPromptRender.visible.booleanValue()) {
            int key = event.getKey();
            if (key == 341) {
                ChatBoxUtil.chatBoxScreen.dialogBox.click(ChatBoxUtil.chatBoxScreen.shouldGotoNext());
            } else if (event.getAction() == 1 && key == 295) {
                ChatBoxUtil.chatBoxScreen.autoPlay = !ChatBoxUtil.chatBoxScreen.autoPlay;
            }
        }
    }

    @SubscribeEvent
    public static void ChatBoxRenderMouseInput(InputEvent.MouseButton.Post event) {
        if (ChatBoxRender.isRenderChatBox() && event.getAction() == 1 && event.getButton() == 1 && ChatBoxUtil.chatBoxScreen.dialogBox != null) {
            if (!CollUtil.isEmpty(ChatBoxUtil.chatBoxScreen.chatOptions).booleanValue() && ChatBoxUtil.chatBoxScreen.dialogBox.isAllOver) {
                ChatOption chatOption = ChatBoxUtil.chatBoxScreen.chatOptions.get(selectIndex);
                chatOption.click();
                selectIndex = 0;
            }
            if (ChatBoxUtil.chatBoxScreen.keyPromptRender.visible.booleanValue()) {
                ChatBoxUtil.chatBoxScreen.dialogBox.click(ChatBoxUtil.chatBoxScreen.shouldGotoNext());
            }
        }
    }

    @SubscribeEvent
    public static void ChatBoxRenderKeyInput(InputEvent.MouseScrollingEvent event) {
        if (ChatBoxRender.isRenderChatBox() && !ChatBoxUtil.chatBoxScreen.chatOptions.isEmpty()) {
            double scrollDeltaY = event.getScrollDeltaY();
            if (!CollUtil.isEmpty(ChatBoxUtil.chatBoxScreen.chatOptions).booleanValue()) {
                if (scrollDeltaY > 0.0) {
                    selectIndex = (selectIndex - 1 + ChatBoxUtil.chatBoxScreen.chatOptions.size()) % ChatBoxUtil.chatBoxScreen.chatOptions.size();
                } else if (scrollDeltaY < 0.0) {
                    selectIndex = (selectIndex + 1) % ChatBoxUtil.chatBoxScreen.chatOptions.size();
                }
                for (int i = 0; i < ChatBoxUtil.chatBoxScreen.chatOptions.size(); ++i) {
                    ChatOption chatOption = ChatBoxUtil.chatBoxScreen.chatOptions.get(i);
                    chatOption.isSelect = i == selectIndex;
                }
            }
            event.setCanceled(true);
        }
    }

    private static boolean isRenderChatBox() {
        return !ChatBoxUtil.isScreen && isOpenChatBox != false && ChatBoxRender.minecraft.screen == null && ChatBoxUtil.chatBoxScreen.dialogBox != null;
    }

    public static void onClose() {
        isOpenChatBox = false;
        ChatBoxUtil.chatBoxScreen.autoPlay = false;
        ChatBoxUtil.chatBoxScreen.fastForward = false;
        if (ChatBoxUtil.chatBoxScreen.video != null) {
            ChatBoxUtil.chatBoxScreen.video.close();
        }
    }
}

