/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.render;

import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.chatbox.RenderUtil;
import com.zhenshiz.chatbox.utils.common.BeanUtil;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;

public class KeyPromptRender
extends AbstractComponent<KeyPromptRender> {
    public Boolean visible;
    public Float mouseTextureWidth;
    public Float mouseTextureHeight;
    public ResourceLocation rightClickTexture;
    public ResourceLocation scrollTexture;

    public KeyPromptRender setMouseTextureSize(Float width, Float height) {
        if (width != null) {
            this.mouseTextureWidth = width;
        }
        if (height != null) {
            this.mouseTextureHeight = height;
        }
        return this;
    }

    public KeyPromptRender setVisible(Boolean visible) {
        if (visible != null) {
            this.visible = visible;
        }
        return this;
    }

    public KeyPromptRender setRightClickTexture(String rightClickTexture) {
        if (rightClickTexture != null) {
            this.rightClickTexture = ResourceLocation.parse((String)rightClickTexture);
        }
        return this;
    }

    public KeyPromptRender setScrollTexture(String scrollTexture) {
        if (scrollTexture != null) {
            this.scrollTexture = ResourceLocation.parse((String)scrollTexture);
        }
        return this;
    }

    @Override
    public void render(GuiGraphics guiGraphics, float pPartialTick) {
        if (this.visible.booleanValue()) {
            RenderUtil.renderOpacity(guiGraphics, this.opacity.floatValue(), () -> {
                Font font = KeyPromptRender.minecraft.font;
                String keyRightClick = Component.translatable((String)"chatbox.key.right_click").getString();
                String keyScroll = Component.translatable((String)"chatbox.key.scroll").getString();
                String keyEsc = Component.translatable((String)"chatbox.key.esc").getString();
                String keyCtrl = Component.translatable((String)"chatbox.key.ctrl").getString();
                String keyF6 = Component.translatable((String)"chatbox.key.f6").getString();
                Vec2 vec2 = this.getCurrentPosition();
                float x = vec2.x;
                float y = vec2.y;
                RenderUtil.renderImage(guiGraphics, BeanUtil.getValueOrDefault(this.rightClickTexture, ResourceLocation.parse((String)"chatbox:textures/key/right_mouse.png")), x, y + 2.0f, 0.0f, this.mouseTextureWidth.floatValue(), this.mouseTextureHeight.floatValue(), 1.0f, 0.0f);
                float f = x + this.mouseTextureWidth.floatValue() + 2.0f;
                Objects.requireNonNull(font);
                KeyPromptRender.drawText(guiGraphics, f, y + 9.0f / 2.0f, keyRightClick);
                RenderUtil.renderImage(guiGraphics, BeanUtil.getValueOrDefault(this.scrollTexture, ResourceLocation.parse((String)"chatbox:textures/key/scroll_mouse.png")), x += this.mouseTextureWidth.floatValue() + (float)font.width(keyRightClick) + 4.0f, y + 2.0f, 0.0f, this.mouseTextureWidth.floatValue(), this.mouseTextureHeight.floatValue(), 1.0f, 0.0f);
                float f2 = x + this.mouseTextureWidth.floatValue() + 2.0f;
                Objects.requireNonNull(font);
                KeyPromptRender.drawText(guiGraphics, f2, y + 9.0f / 2.0f, keyScroll);
                int n = (int)(x += this.mouseTextureWidth.floatValue() + (float)font.width(keyScroll) + 4.0f);
                int n2 = (int)y;
                Objects.requireNonNull(font);
                KeyPromptRender.drawKeyBoardKey(guiGraphics, n, n2 + 9 / 2, "Esc", false);
                float f3 = x + (float)font.width("Esc") + 6.0f;
                Objects.requireNonNull(font);
                KeyPromptRender.drawText(guiGraphics, f3, y + 9.0f / 2.0f, keyEsc);
                int n3 = (int)(x += (float)(10 + font.width("Esc") + font.width(keyEsc)));
                int n4 = (int)y;
                Objects.requireNonNull(font);
                KeyPromptRender.drawKeyBoardKey(guiGraphics, n3, n4 + 9 / 2, "Ctrl", false);
                float f4 = x + (float)font.width("Ctrl") + 6.0f;
                Objects.requireNonNull(font);
                KeyPromptRender.drawText(guiGraphics, f4, y + 9.0f / 2.0f, keyCtrl);
                int n5 = (int)(x += (float)(10 + font.width("Ctrl") + font.width(keyCtrl)));
                int n6 = (int)y;
                Objects.requireNonNull(font);
                KeyPromptRender.drawKeyBoardKey(guiGraphics, n5, n6 + 9 / 2, "F6", ChatBoxUtil.chatBoxScreen.autoPlay);
                float f5 = x + (float)font.width("F6") + 6.0f;
                Objects.requireNonNull(font);
                KeyPromptRender.drawText(guiGraphics, f5, y + 9.0f / 2.0f, keyF6);
            });
        }
    }

    public static void drawKeyBoardKey(GuiGraphics guiGraphics, int x, int y, String key, boolean pressed) {
        Font font = KeyPromptRender.minecraft.font;
        int width = font.width(key) + 4;
        int height = 12;
        int topColor = -9408400;
        int faceColor = -11513776;
        int bottomColor = -14671840;
        if (pressed) {
            topColor = -11513776;
            faceColor = -14671840;
            bottomColor = -16777216;
        }
        guiGraphics.fillGradient(x, y, x + width, y + height, topColor, bottomColor);
        guiGraphics.fill(x, y, x + width, y + height, faceColor);
        guiGraphics.fill(x, y, x + width, y + 1, topColor);
        guiGraphics.fill(x, y, x + 1, y + height, topColor);
        guiGraphics.fill(x, y + height - 1, x + width, y + height, bottomColor);
        guiGraphics.fill(x + width - 1, y, x + width, y + height, bottomColor);
        guiGraphics.drawCenteredString(font, key, x + width / 2, y + (height - 8) / 2, -1);
    }

    public static void drawText(GuiGraphics guiGraphics, float x, float y, String text) {
        Font font = Minecraft.getInstance().font;
        guiGraphics.drawString(font, text, x - 1.0f, y, -16777216, true);
        guiGraphics.drawString(font, text, x + 1.0f, y, -16777216, true);
        guiGraphics.drawString(font, text, x, y - 1.0f, -16777216, true);
        guiGraphics.drawString(font, text, x, y + 1.0f, -16777216, true);
        guiGraphics.drawString(font, text, x, y, -1, true);
    }
}

