/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.screen;

import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.component.ChatOption;
import com.zhenshiz.chatbox.component.DialogBox;
import com.zhenshiz.chatbox.component.FunctionalButton;
import com.zhenshiz.chatbox.component.Portrait;
import com.zhenshiz.chatbox.component.Video;
import com.zhenshiz.chatbox.event.neoforge.ChatBoxRenderEvent;
import com.zhenshiz.chatbox.mixin.SoundEngineAccessor;
import com.zhenshiz.chatbox.mixin.SoundInstanceAccessor;
import com.zhenshiz.chatbox.render.KeyPromptRender;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.chatbox.RenderUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;

public class ChatBoxScreen
extends Screen {
    public List<ChatOption> chatOptions = new ArrayList<ChatOption>();
    public List<Portrait> portraits = new ArrayList<Portrait>();
    public DialogBox dialogBox = new DialogBox();
    public List<FunctionalButton> functionalButtons = new ArrayList<FunctionalButton>();
    public ResourceLocation backgroundImage;
    public Boolean isTranslatable;
    public Boolean isEsc;
    public Boolean isPause;
    public Boolean isHistoricalSkip;
    public Integer maxTriggerCount;
    public Video video;
    public KeyPromptRender keyPromptRender = new KeyPromptRender();
    public boolean fastForward = false;
    public boolean autoPlay = false;
    public int tickAutoPlay = 20;
    public boolean hideDialogBox = false;

    public ChatBoxScreen() {
        super(Component.nullToEmpty((String)"ChatBoxScreen"));
    }

    public ChatBoxScreen addChatOptions(ChatOption chatOption) {
        if (chatOption != null) {
            this.chatOptions.add(chatOption);
        }
        return this;
    }

    public ChatBoxScreen setChatOptions(List<ChatOption> chatOptions) {
        if (chatOptions != null) {
            this.chatOptions = chatOptions;
        }
        return this;
    }

    public ChatBoxScreen setDialogBox(DialogBox dialogBox) {
        if (dialogBox != null) {
            this.dialogBox = dialogBox;
        }
        return this;
    }

    public ChatBoxScreen setPortrait(List<Portrait> portraits) {
        if (portraits != null) {
            this.portraits = portraits;
        }
        return this;
    }

    public ChatBoxScreen setFunctionalButtons(List<FunctionalButton> functionalButtons) {
        if (functionalButtons != null) {
            this.functionalButtons = functionalButtons;
        }
        return this;
    }

    public ChatBoxScreen setBackgroundImage(ResourceLocation backgroundImage) {
        this.backgroundImage = backgroundImage;
        return this;
    }

    public ChatBoxScreen setBackgroundImage(String backgroundImage) {
        if (backgroundImage != null) {
            return this.setBackgroundImage(ResourceLocation.tryParse((String)backgroundImage));
        }
        this.backgroundImage = null;
        return this;
    }

    public ChatBoxScreen setVideo(Video video) {
        if (!ChatBox.isWaterMediaLoaded()) {
            return this;
        }
        if (this.video != null) {
            this.video.close();
        }
        if (video != null) {
            this.video = video;
        }
        return this;
    }

    public ChatBoxScreen setIsTranslatable(Boolean isTranslatable) {
        if (isTranslatable != null) {
            this.isTranslatable = isTranslatable;
        }
        return this;
    }

    public ChatBoxScreen setIsEsc(Boolean isEsc) {
        if (isEsc != null) {
            this.isEsc = isEsc;
        }
        return this;
    }

    public ChatBoxScreen setIsPause(Boolean isPause) {
        if (isPause != null) {
            this.isPause = isPause;
        }
        return this;
    }

    public ChatBoxScreen setIsHistoricalSkip(Boolean isHistoricalSkip) {
        if (isHistoricalSkip != null) {
            this.isHistoricalSkip = isHistoricalSkip;
        }
        return this;
    }

    public ChatBoxScreen setMaxTriggerCount(Integer maxTriggerCount) {
        if (maxTriggerCount != null) {
            this.maxTriggerCount = maxTriggerCount;
        }
        return this;
    }

    public ChatBoxScreen setKeyPromptRender(KeyPromptRender keyPromptRender) {
        if (keyPromptRender != null) {
            this.keyPromptRender = keyPromptRender;
        }
        return this;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.dialogBox != null) {
            if (((ChatBoxRenderEvent.Pre)NeoForge.EVENT_BUS.post((Event)new ChatBoxRenderEvent.Pre(guiGraphics))).isCanceled()) {
                return;
            }
            if (this.backgroundImage != null) {
                RenderUtil.renderImage(guiGraphics, this.backgroundImage, 0.0f, 0.0f, 0.0f, RenderUtil.screenWidth(), RenderUtil.screenHeight(), 1.0f, 0.0f);
            }
            ArrayList<AbstractComponent> list = new ArrayList<AbstractComponent>();
            if (!this.hideDialogBox) {
                list.add(this.dialogBox);
            }
            if (this.video != null) {
                list.add(this.video);
            }
            if (this.chatOptions != null && !this.hideDialogBox) {
                list.addAll(this.chatOptions);
            }
            if (this.portraits != null) {
                list.addAll(this.hideDialogBox ? this.portraits.stream().filter(portrait -> portrait.renderOrder < this.dialogBox.renderOrder).toList() : this.portraits);
            }
            if (this.functionalButtons != null && !this.hideDialogBox) {
                list.addAll(this.functionalButtons);
            }
            list.sort(Comparator.comparingInt(p -> p.renderOrder));
            list.forEach(abstractComponent -> abstractComponent.render(guiGraphics, pMouseX, pMouseY, pPartialTick));
            NeoForge.EVENT_BUS.post((Event)new ChatBoxRenderEvent.Post(guiGraphics));
        }
        super.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public boolean shouldGotoNext() {
        if (this.video != null && this.video.isPlaying() && !this.video.canSkip) {
            return false;
        }
        return this.chatOptions.isEmpty();
    }

    private FunctionalButton getButton(FunctionalButton.Type type) {
        return this.functionalButtons.stream().filter(b -> b.type == type).findFirst().orElse(null);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.hideDialogBox) {
            this.hideDialogBox = false;
            return true;
        }
        if (pButton == 1) {
            this.hideDialogBox = true;
            this.fastForward = false;
            return true;
        }
        if (pButton == 0 && this.dialogBox != null) {
            this.fastForward = false;
            for (ChatOption chatOption : this.chatOptions) {
                if (!chatOption.isSelect(pMouseX, pMouseY) || !this.dialogBox.isAllOver) continue;
                chatOption.click();
                return super.mouseClicked(pMouseX, pMouseY, pButton);
            }
            for (FunctionalButton button : this.functionalButtons) {
                if (!button.isSelect(pMouseX, pMouseY)) continue;
                button.click();
                return super.mouseClicked(pMouseX, pMouseY, pButton);
            }
            this.dialogBox.click(this.shouldGotoNext());
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        FunctionalButton logButton;
        this.fastForward = false;
        if (this.hideDialogBox) {
            this.hideDialogBox = false;
            return true;
        }
        if (this.chatOptions.isEmpty() && scrollY < 0.0 && this.dialogBox != null) {
            this.dialogBox.click(this.shouldGotoNext());
            return true;
        }
        if (scrollY > 0.0 && (logButton = this.getButton(FunctionalButton.Type.LOG)) != null) {
            logButton.click();
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.video != null && this.video.isPlaying()) {
            this.video.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        this.autoPlay = false;
        this.fastForward = false;
        this.hideDialogBox = false;
        if (this.video != null) {
            this.video.close();
        }
        super.onClose();
    }

    public void tick() {
        if (this.hideDialogBox) {
            return;
        }
        if (!this.shouldGotoNext()) {
            this.fastForward = false;
        }
        if (this.dialogBox != null) {
            this.dialogBox.tick();
            if (this.fastForward) {
                this.dialogBox.click(this.shouldGotoNext());
            }
            Minecraft mc = Minecraft.getInstance();
            if (this.autoPlay) {
                SoundInstanceAccessor soundEngine = (SoundInstanceAccessor)((SoundEngineAccessor)mc.getSoundManager()).getSoundEngine();
                if (mc.isPaused()) {
                    soundEngine.invokeTickNonPaused();
                }
                if (ChatBoxUtil.lastSoundResourceLocation != null) {
                    Map<SoundInstance, ChannelAccess.ChannelHandle> instanceToChannel = soundEngine.getInstanceToChannel();
                    for (SoundInstance soundInstance : instanceToChannel.keySet()) {
                        if (!soundInstance.getLocation().equals((Object)ChatBoxUtil.lastSoundResourceLocation) || !mc.getSoundManager().isActive(soundInstance)) continue;
                        return;
                    }
                }
                if (!this.dialogBox.isAllOver || this.video != null && this.video.isPlaying()) {
                    return;
                }
                --this.tickAutoPlay;
                if (this.tickAutoPlay <= 0) {
                    this.tickAutoPlay = 20;
                    this.dialogBox.click(this.shouldGotoNext());
                }
            }
        }
    }

    public boolean shouldCloseOnEsc() {
        return this.isEsc;
    }

    public boolean isPauseScreen() {
        return this.isPause;
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }
}

