/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.utils.chatbox;

import com.zhenshiz.chatbox.api.ChatOptionClickEvent;
import com.zhenshiz.chatbox.data.ChatBoxDialogues;
import com.zhenshiz.chatbox.data.ChatBoxTriggerCount;
import com.zhenshiz.chatbox.network.c2s.ServerChatBoxPayload;
import com.zhenshiz.chatbox.network.s2c.ClientChatBoxPayload;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ChatBoxCommandUtil {
    @Info(value="\u670d\u52a1\u7aef\u5207\u6362\u5bf9\u8bdd\u6846\u4e3b\u9898\u6837\u5f0f")
    public static void serverToggleTheme(ServerPlayer player, ResourceLocation theme) {
        if (player != null) {
            player.connection.send((CustomPacketPayload)new ClientChatBoxPayload.SimplePayload("set_theme", theme.toString()));
        }
    }

    @Info(value="\u670d\u52a1\u7aef\u8df3\u8f6c\u5bf9\u8bdd")
    public static void serverSkipDialogues(ServerPlayer player, ResourceLocation dialogues, String group, Integer index) {
        if (player != null) {
            player.connection.send((CustomPacketPayload)new ClientChatBoxPayload.OpenScreenPayload(dialogues, group, index));
        }
    }

    @Info(value="\u670d\u52a1\u7aef\u8df3\u8f6c\u5bf9\u8bdd\uff0c\u9ed8\u8ba4\u7b2c\u4e00\u53e5\u8bdd")
    public static void serverSkipDialogues(ServerPlayer player, ResourceLocation dialogues, String group) {
        ChatBoxCommandUtil.serverSkipDialogues(player, dialogues, group, 0);
    }

    @Info(value="\u670d\u52a1\u7aef\u6253\u5f00\u5bf9\u8bdd\u6846\uff0c\u65e0\u89c6\u6700\u5927\u8bbf\u95ee\u6b21\u6570")
    public static void serverOpenChatBox(ServerPlayer player) {
        if (player != null) {
            player.connection.send((CustomPacketPayload)new ClientChatBoxPayload.SimplePayload("open_dialog", ""));
        }
    }

    @Info(value="\u670d\u52a1\u7aef\u8bbe\u7f6e\u6700\u5927\u8bbf\u95ee\u6b21\u6570\uff0c\u81ea\u5e26\u540c\u6b65")
    public static void serverSetMaxTriggerCount(ServerPlayer player, ResourceLocation dialogResourceLocation, int count) {
        if (player != null) {
            ChatBoxTriggerCount.MaxTriggerCount maxTriggerCount = (ChatBoxTriggerCount.MaxTriggerCount)player.getData(ChatBoxTriggerCount.MAX_TRIGGER_COUNT);
            String resourceLocation = dialogResourceLocation.toString();
            Map<String, Integer> triggerCounts = maxTriggerCount.getTriggerCounts();
            HashMap<String, Integer> newTriggerCounts = new HashMap<String, Integer>(triggerCounts);
            newTriggerCounts.put(resourceLocation, count);
            maxTriggerCount.setTriggerCounts(newTriggerCounts);
            player.setData(ChatBoxTriggerCount.MAX_TRIGGER_COUNT, (Object)maxTriggerCount);
        }
    }

    @Info(value="\u670d\u52a1\u7aef\u91cd\u7f6e\u8bbf\u95ee\u6b21\u6570\uff0c\u81ea\u5e26\u540c\u6b65")
    public static void serverResetMaxTriggerCount(ServerPlayer player) {
        if (player != null) {
            player.setData(ChatBoxTriggerCount.MAX_TRIGGER_COUNT, (Object)new ChatBoxTriggerCount.MaxTriggerCount());
        }
    }

    @Info(value="\u5ba2\u6237\u7aef\u5207\u6362\u5bf9\u8bdd\u6846\u4e3b\u9898\u6837\u5f0f")
    public static void clientToggleTheme(String theme) {
        ChatBoxUtil.toggleTheme(ResourceLocation.parse((String)theme));
        ChatBoxUtil.themeResourceLocation = theme;
    }

    @Info(value="\u5ba2\u6237\u7aef\u8df3\u8f6c\u5bf9\u8bdd\uff0c\u81ea\u5e26\u540c\u6b65\u6570\u636e\u9644\u4ef6")
    public static void clientSkipDialogues(ResourceLocation dialoguesResourceLocation, String group, Integer index) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return;
        }
        ChatBoxDialogues chatBoxDialogues = ChatBoxUtil.dialoguesMap.get(dialoguesResourceLocation);
        ChatBoxTriggerCount.MaxTriggerCount maxTriggerCount = (ChatBoxTriggerCount.MaxTriggerCount)minecraft.player.getData(ChatBoxTriggerCount.MAX_TRIGGER_COUNT);
        String resourceLocation = dialoguesResourceLocation.toString();
        Map<String, Integer> triggerCounts = maxTriggerCount.getTriggerCounts();
        Integer count = triggerCounts.get(resourceLocation);
        if (count == null) {
            ChatBoxCommandUtil.clientSetMaxTriggerCount(dialoguesResourceLocation, chatBoxDialogues.maxTriggerCount - 1);
            minecraft.player.connection.send((CustomPacketPayload)new ServerChatBoxPayload.SetMaxTriggerCountPayload(dialoguesResourceLocation, chatBoxDialogues.maxTriggerCount - 1));
        } else {
            if (count == 0) {
                return;
            }
            ChatBoxCommandUtil.clientSetMaxTriggerCount(dialoguesResourceLocation, count - 1);
            minecraft.player.connection.send((CustomPacketPayload)new ServerChatBoxPayload.SetMaxTriggerCountPayload(dialoguesResourceLocation, count - 1));
        }
        String theme = chatBoxDialogues.theme;
        if (theme != null && !theme.equals(ChatBoxUtil.themeResourceLocation)) {
            ChatBoxCommandUtil.clientToggleTheme(theme);
        }
        if (chatBoxDialogues.isScreen != null) {
            ChatBoxCommandUtil.clientSetIsScreen(chatBoxDialogues.isScreen);
        }
        ChatBoxUtil.skipDialogues(dialoguesResourceLocation, group, index);
    }

    @Info(value="\u5ba2\u6237\u7aef\u8df3\u8f6c\u5bf9\u8bdd\uff0c\u9ed8\u8ba4\u7b2c\u4e00\u53e5\u8bdd")
    public static void clientSkipDialogues(ResourceLocation dialogues, String group) {
        ChatBoxCommandUtil.clientSkipDialogues(dialogues, group, 0);
    }

    @Info(value="\u5ba2\u6237\u7aef\u6253\u5f00\u5bf9\u8bdd\u6846\uff0c\u65e0\u89c6\u6700\u5927\u8bbf\u95ee\u6b21\u6570")
    public static void clientOpenChatBox() {
        if (Minecraft.getInstance().player != null && ChatBoxUtil.dialoguesResourceLocation != null && ChatBoxUtil.group != null && ChatBoxUtil.index != null) {
            ChatBoxUtil.skipDialogues(ChatBoxUtil.dialoguesResourceLocation, ChatBoxUtil.group, ChatBoxUtil.index);
        }
    }

    @Info(value="\u5ba2\u6237\u7aef\u8bbe\u7f6e\u6700\u5927\u8bbf\u95ee\u6b21\u6570\uff0c\u81ea\u5e26\u540c\u6b65")
    public static void clientSetMaxTriggerCount(ResourceLocation dialogResourceLocation, int count) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return;
        }
        ChatBoxTriggerCount.MaxTriggerCount maxTriggerCount = (ChatBoxTriggerCount.MaxTriggerCount)minecraft.player.getData(ChatBoxTriggerCount.MAX_TRIGGER_COUNT);
        String resourceLocation = dialogResourceLocation.toString();
        Map<String, Integer> triggerCounts = maxTriggerCount.getTriggerCounts();
        triggerCounts.put(resourceLocation, count);
        minecraft.player.setData(ChatBoxTriggerCount.MAX_TRIGGER_COUNT, (Object)maxTriggerCount);
    }

    @Info(value="\u5ba2\u6237\u7aef\u91cd\u7f6e\u8bbf\u95ee\u6b21\u6570\uff0c\u81ea\u5e26\u540c\u6b65")
    public static void clientResetMaxTriggerCount() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return;
        }
        minecraft.player.setData(ChatBoxTriggerCount.MAX_TRIGGER_COUNT, (Object)new ChatBoxTriggerCount.MaxTriggerCount());
    }

    @Info(value="\u8df3\u8f6c\u4e0b\u4e00\u6761\u5bf9\u8bdd")
    public static void clientNextDialogue() {
        ChatBoxUtil.chatBoxScreen.dialogBox.click(ChatBoxUtil.chatBoxScreen.shouldGotoNext());
    }

    @Info(value="\u5f00\u5173\u81ea\u52a8\u5bf9\u8bdd")
    public static void clientAutoPlay(boolean autoPlay) {
        ChatBoxUtil.chatBoxScreen.autoPlay = autoPlay;
    }

    @Info(value="\u6ce8\u518c\u4e00\u4e2a\u9009\u9879\u70b9\u51fb\u4e8b\u4ef6")
    public static void registerClickEvent(String type, Consumer<String> executeOnClient, Boolean shouldExecuteOnServer, BiConsumer<ServerPlayer, String> executeOnServer) {
        ChatOptionClickEvent.registerClickEvent(type, executeOnClient, shouldExecuteOnServer, executeOnServer);
    }

    @Info(value="\u5207\u6362\u5bf9\u8bdd\u6846\u662f\u5426\u4e3a\u5c4f\u5e55")
    public static void clientSetIsScreen(boolean isScreen) {
        ChatBoxUtil.isScreen = isScreen;
    }
}

