/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.utils.chatbox;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.zhenshiz.chatbox.Config;
import com.zhenshiz.chatbox.component.HistoricalDialogue;
import com.zhenshiz.chatbox.component.Portrait;
import com.zhenshiz.chatbox.data.ChatBoxDialogues;
import com.zhenshiz.chatbox.data.ChatBoxTheme;
import com.zhenshiz.chatbox.event.neoforge.SkipChatEvent;
import com.zhenshiz.chatbox.network.c2s.SendClickEvent;
import com.zhenshiz.chatbox.render.ChatBoxRender;
import com.zhenshiz.chatbox.screen.ChatBoxScreen;
import com.zhenshiz.chatbox.screen.HistoricalDialogueScreen;
import com.zhenshiz.chatbox.utils.math.EasingUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class ChatBoxUtil {
    private static final Minecraft minecraft = Minecraft.getInstance();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Map<ResourceLocation, ChatBoxTheme> themeMap = new HashMap<ResourceLocation, ChatBoxTheme>();
    public static final Map<ResourceLocation, ChatBoxDialogues> dialoguesMap = new HashMap<ResourceLocation, ChatBoxDialogues>();
    public static final Map<String, List<ChatBoxTheme.Portrait.CustomAnimation>> animationMap = new HashMap<String, List<ChatBoxTheme.Portrait.CustomAnimation>>();
    public static ChatBoxTheme chatBoxTheme;
    public static ChatBoxScreen chatBoxScreen;
    public static HistoricalDialogueScreen historicalDialogue;
    public static ResourceLocation lastSoundResourceLocation;
    public static String themeResourceLocation;
    public static ResourceLocation dialoguesResourceLocation;
    public static String group;
    public static Integer index;
    public static boolean isScreen;

    public static void setDialoguesInfo(ResourceLocation resourceLocation, String group, Integer index) {
        if (resourceLocation != null && group != null && index != null) {
            dialoguesResourceLocation = resourceLocation;
            ChatBoxUtil.group = group;
            ChatBoxUtil.index = index;
        }
    }

    private static List<Portrait> bakePortrait(ResourceLocation newRl, String newGroup, Integer newIndex) {
        ChatBoxDialogues.Dialogues dialog;
        int i;
        List<Portrait> portraits = ChatBoxUtil.chatBoxScreen.portraits;
        List<ChatBoxDialogues.Dialogues> dialogues = ChatBoxUtil.dialoguesMap.get((Object)newRl).dialogues.get(newGroup);
        if (dialoguesResourceLocation != null && group != null && index != null && newRl == dialoguesResourceLocation && Objects.equals(newGroup, group) && newIndex == index + 1) {
            return dialogues.get(newIndex).setPortraitDialogues(portraits);
        }
        int startIndex = 0;
        for (i = newIndex.intValue(); i >= 0; --i) {
            dialog = dialogues.get(i);
            if (!dialog.clearOldPortrait.booleanValue()) continue;
            startIndex = i;
            break;
        }
        for (i = startIndex; i <= newIndex; ++i) {
            dialog = dialogues.get(i);
            dialog.setPortraitDialogues(portraits);
        }
        return portraits;
    }

    public static void skipDialogues(ResourceLocation dialoguesResourceLocation, String group, int index) {
        if (ChatBoxUtil.minecraft.player == null) {
            return;
        }
        ChatBoxDialogues chatBoxDialogues = dialoguesMap.get(dialoguesResourceLocation);
        Boolean isTranslatable = chatBoxDialogues.isTranslatable;
        List<ChatBoxDialogues.Dialogues> dialogues = chatBoxDialogues.dialogues.get(group);
        if (index >= 0 && index < dialogues.size()) {
            ResourceLocation soundResourceLocation;
            ChatBoxDialogues.Dialogues dialog = dialogues.get(index);
            ChatBoxDialogues.Dialogues.DialogBox dialogBox = dialog.dialogBox;
            chatBoxScreen.setDialogBox(dialogBox.setDialogBoxDialogues(ChatBoxUtil.chatBoxScreen.dialogBox, isTranslatable)).setVideo(dialog.video != null ? dialog.video.setVideo() : null).setPortrait(ChatBoxUtil.bakePortrait(dialoguesResourceLocation, group, index)).setChatOptions(dialog.setChatOptionDialogues(isTranslatable)).setBackgroundImage(dialog.backgroundImage).setIsTranslatable(isTranslatable).setIsEsc(chatBoxDialogues.isEsc).setIsPause(chatBoxDialogues.isPause).setIsHistoricalSkip(chatBoxDialogues.isHistoricalSkip).setMaxTriggerCount(chatBoxDialogues.maxTriggerCount);
            ChatBoxUtil.chatBoxScreen.dialogBox.resetTickCount();
            ChatBoxUtil.chatBoxScreen.dialogBox.setAllOver(false);
            if (!(ChatBoxUtil.minecraft.screen instanceof ChatBoxScreen) && !(ChatBoxUtil.minecraft.screen instanceof HistoricalDialogueScreen)) {
                historicalDialogue = new HistoricalDialogueScreen();
            }
            ChatBoxUtil.historicalDialogue.historicalDialogue.addHistoricalInfo(new HistoricalDialogue.HistoricalInfo(dialoguesResourceLocation, group, index).setName(dialogBox.name, isTranslatable).setText(dialogBox.text, isTranslatable));
            if (dialog.command != null) {
                ChatBoxUtil.minecraft.player.connection.send((CustomPacketPayload)new SendClickEvent("COMMAND", dialog.command));
            }
            if ((soundResourceLocation = ResourceLocation.tryParse((String)dialog.sound)) != null && !Objects.equals(dialog.sound, "")) {
                if (lastSoundResourceLocation != null) {
                    minecraft.getSoundManager().stop(lastSoundResourceLocation, null);
                }
                lastSoundResourceLocation = soundResourceLocation;
                SoundEvent soundEvent = (SoundEvent)Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)soundResourceLocation)).value();
                ChatBoxUtil.minecraft.player.playSound(soundEvent, dialog.volume.floatValue(), dialog.pitch.floatValue());
            } else if (((Boolean)Config.soundInterruptionEnabled.get()).booleanValue() && lastSoundResourceLocation != null) {
                minecraft.getSoundManager().stop(lastSoundResourceLocation, null);
            }
            NeoForge.EVENT_BUS.post((Event)new SkipChatEvent(chatBoxScreen, dialoguesResourceLocation, group, index));
            if (isScreen) {
                minecraft.setScreen((Screen)chatBoxScreen);
            } else {
                ChatBoxRender.isOpenChatBox = true;
            }
            ChatBoxUtil.setDialoguesInfo(dialoguesResourceLocation, group, index);
        } else if (isScreen) {
            if (ChatBoxUtil.minecraft.screen != null) {
                ChatBoxUtil.minecraft.screen.onClose();
            }
        } else {
            ChatBoxRender.onClose();
        }
    }

    public static void skipDialogues(ResourceLocation dialoguesResourceLocation, String dialogBlock) {
        ChatBoxUtil.skipDialogues(dialoguesResourceLocation, dialogBlock, 0);
    }

    public static void toggleTheme(ResourceLocation themeResourceLocation) {
        chatBoxTheme = themeMap.get(themeResourceLocation);
        chatBoxScreen.setDialogBox(ChatBoxUtil.chatBoxTheme.dialogBox.setDialogBoxTheme(ChatBoxUtil.chatBoxScreen.dialogBox)).setFunctionalButtons(ChatBoxTheme.FunctionButton.setFunctionalButtonTheme(ChatBoxUtil.chatBoxTheme.functionalButton)).setKeyPromptRender(ChatBoxUtil.chatBoxTheme.keyPrompt.setKeyPromptTheme(ChatBoxUtil.chatBoxScreen.keyPromptRender));
    }

    public static void setTheme(Map<ResourceLocation, String> map) {
        map.forEach((resourceLocation, str) -> {
            JsonElement jsonElement = (JsonElement)GSON.fromJson(str, JsonElement.class);
            if (jsonElement == null) {
                return;
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonElement portraitElement = jsonObject.get("portrait");
            JsonElement chatOptionElement = jsonObject.get("option");
            JsonElement dialogBoxElement = jsonObject.get("dialogBox");
            JsonElement fbElement = jsonObject.get("functionalButton");
            JsonElement customAnimationElement = jsonObject.get("customAnimation");
            JsonElement keyPromptElement = jsonObject.get("keyPrompt");
            HashMap<String, ChatBoxTheme.Portrait> portrait = new HashMap();
            ChatBoxTheme.Option option = new ChatBoxTheme.Option();
            ChatBoxTheme.DialogBox dialogBox = new ChatBoxTheme.DialogBox();
            ArrayList<ChatBoxTheme.FunctionButton> functionButton = new ArrayList();
            ChatBoxTheme.KeyPrompt keyPrompt = new ChatBoxTheme.KeyPrompt();
            Map customAnimation = new HashMap();
            if (portraitElement != null) {
                portrait = (Map)GSON.fromJson(portraitElement, new TypeToken<Map<String, ChatBoxTheme.Portrait>>(){}.getType());
            }
            if (chatOptionElement != null) {
                option = (ChatBoxTheme.Option)GSON.fromJson(chatOptionElement, ChatBoxTheme.Option.class);
            }
            if (dialogBoxElement != null) {
                dialogBox = (ChatBoxTheme.DialogBox)GSON.fromJson(dialogBoxElement, ChatBoxTheme.DialogBox.class);
            }
            if (fbElement != null) {
                functionButton = (List)GSON.fromJson(fbElement, new TypeToken<List<ChatBoxTheme.FunctionButton>>(){}.getType());
            }
            if (keyPromptElement != null) {
                keyPrompt = (ChatBoxTheme.KeyPrompt)GSON.fromJson(keyPromptElement, ChatBoxTheme.KeyPrompt.class);
            }
            if (customAnimationElement != null) {
                customAnimation = (Map)GSON.fromJson(customAnimationElement, new TypeToken<Map<String, List<ChatBoxTheme.Portrait.CustomAnimation>>>(){}.getType());
            }
            animationMap.putAll(customAnimation);
            themeMap.put((ResourceLocation)resourceLocation, new ChatBoxTheme(portrait, option, dialogBox, functionButton, keyPrompt, null).setDefaultValue());
        });
    }

    public static void setDialogues(Map<ResourceLocation, String> map) {
        map.forEach((resourceLocation, str) -> {
            JsonElement jsonElement = (JsonElement)GSON.fromJson(str, JsonElement.class);
            if (jsonElement != null) {
                ChatBoxDialogues chatBoxDialogues = (ChatBoxDialogues)GSON.fromJson(jsonElement, new com.google.common.reflect.TypeToken<ChatBoxDialogues>(){}.getType());
                dialoguesMap.put((ResourceLocation)resourceLocation, chatBoxDialogues);
            }
        });
    }

    public static String parseText(String input, boolean isLineBreak) {
        if (ChatBoxUtil.minecraft.player != null) {
            input = input.replaceAll("(?<!@)@s", Objects.requireNonNull(ChatBoxUtil.minecraft.player.getDisplayName()).getString());
            if (isLineBreak) {
                input = input.replaceAll("\n", "");
            }
            return input.replaceAll("@@", "@");
        }
        return input;
    }

    static {
        chatBoxScreen = new ChatBoxScreen();
        historicalDialogue = new HistoricalDialogueScreen();
        lastSoundResourceLocation = null;
        themeResourceLocation = null;
        isScreen = true;
        animationMap.put("FADE_IN", List.of(ChatBoxTheme.Portrait.CustomAnimation.builder().time(1).opacity(Float.valueOf(0.0f)).build(), ChatBoxTheme.Portrait.CustomAnimation.builder().time(30).opacity(Float.valueOf(100.0f)).easing(EasingUtil.Easing.EASE_OUT_SINE).build()));
        animationMap.put("SLIDE_IN_FROM_BOTTOM", List.of(ChatBoxTheme.Portrait.CustomAnimation.builder().time(30).yOffset(Float.valueOf(-5.0f)).easing(EasingUtil.Easing.EASE_OUT_SINE).build()));
        animationMap.put("BOUNCE", List.of(ChatBoxTheme.Portrait.CustomAnimation.builder().time(15).yOffset(Float.valueOf(-5.0f)).easing(EasingUtil.Easing.EASE_OUT_SINE).build(), ChatBoxTheme.Portrait.CustomAnimation.builder().time(15).yOffset(Float.valueOf(5.0f)).easing(EasingUtil.Easing.EASE_OUT_SINE).build()));
    }
}

