/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.zhenshiz.chatbox.command.ICommand;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.objectweb.asm.Type;
import org.slf4j.Logger;

@Mod(value="chatbox")
public class ChatBox {
    public static final String MOD_ID = "chatbox";
    public static final Logger LOGGER = LogUtils.getLogger();

    public ChatBox(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.addListener(this::onRegisterCommands);
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        String PACKAGE_NAME = "com.zhenshiz.chatbox.command";
        String REGISTER = "register";
        ModContainer modContainer = (ModContainer)ModList.get().getModContainerById(MOD_ID).orElseThrow();
        Set classes = modContainer.getModInfo().getOwningFile().getFile().getScanResult().getClasses();
        classes.forEach(classData -> {
            Type clazz = classData.clazz();
            if (clazz.getClassName().startsWith("com.zhenshiz.chatbox.command")) {
                try {
                    ClassLoader classLoader = ChatBox.class.getClassLoader();
                    Class<?> commandClass = classLoader.loadClass(clazz.getClassName());
                    if (Arrays.stream(commandClass.getInterfaces()).toList().contains(ICommand.class)) {
                        Method register = commandClass.getMethod("register", CommandDispatcher.class, CommandBuildContext.class, Commands.CommandSelection.class);
                        Constructor<?> constructor = commandClass.getDeclaredConstructor(new Class[0]);
                        Object iCommand = constructor.newInstance(new Object[0]);
                        register.invoke(iCommand, event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static ResourceLocation ResourceLocationMod(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }
}

