/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.zhenshiz.chatbox.command.ICommand;
import com.zhenshiz.chatbox.data.ChatBoxDialoguesLoader;
import com.zhenshiz.chatbox.data.ChatBoxThemeLoader;
import com.zhenshiz.chatbox.payload.s2c.ChatBoxPayload;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ChatBoxCommand
implements ICommand {
    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"chatbox").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.literal((String)"theme").then(Commands.argument((String)"Theme", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> SharedSuggestionProvider.suggestResource(ChatBoxThemeLoader.INSTANCE.themeMap.keySet(), (SuggestionsBuilder)builder)).executes(ChatBoxCommand::toggleTheme)))).then(Commands.literal((String)"skip").then(Commands.argument((String)"Dialogues", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> SharedSuggestionProvider.suggestResource(ChatBoxDialoguesLoader.INSTANCE.dialoguesMap.keySet(), (SuggestionsBuilder)builder)).then(((RequiredArgumentBuilder)Commands.argument((String)"Group", (ArgumentType)StringArgumentType.string()).executes(context -> ChatBoxCommand.skipDialogues((CommandContext<CommandSourceStack>)context, true))).then(Commands.argument((String)"Index", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ChatBoxCommand.skipDialogues((CommandContext<CommandSourceStack>)context, false))))))).then(Commands.literal((String)"open").executes(ChatBoxCommand::openChatBox)));
    }

    private static int toggleTheme(CommandContext<CommandSourceStack> context) {
        ResourceLocation theme = ResourceLocationArgument.getId(context, (String)"Theme");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player != null) {
            ChatBoxUtil.toggleTheme(player.getUUID(), theme);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.toggle.theme"), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int skipDialogues(CommandContext<CommandSourceStack> context, boolean isStart) {
        ResourceLocation dialogues = ResourceLocationArgument.getId(context, (String)"Dialogues");
        String group = StringArgumentType.getString(context, (String)"Group");
        int index = IntegerArgumentType.getInteger(context, (String)"Index");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player != null) {
            if (isStart) {
                player.connection.send((CustomPacketPayload)new ChatBoxPayload.OpenScreenPayload(dialogues, group, 0));
            } else {
                player.connection.send((CustomPacketPayload)new ChatBoxPayload.OpenScreenPayload(dialogues, group, index));
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.skip.dialogues", (Object[])new Object[]{group, index + 1}), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure(ERROR_PLAYER_ONLY);
        return 0;
    }

    private static int openChatBox(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player != null) {
            player.connection.send((CustomPacketPayload)new ChatBoxPayload.openChatBox());
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure(ERROR_PLAYER_ONLY);
        return 0;
    }
}

