/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.chatbox.RenderUtil;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;

public abstract class AbstractComponent<T extends AbstractComponent<T>> {
    public AlignX alignX;
    public AlignY alignY;
    public int x;
    public int y;
    public int z;
    public int width;
    public int height;
    public ResourceLocation dialoguesResourceLocation;
    public String group;
    public Integer index;
    protected static final Minecraft minecraft = Minecraft.getInstance();

    public void defaultOption() {
        this.setPosition(0, 0);
        this.setSize(10, 10);
        this.setAlign(AlignX.LEFT, AlignY.TOP);
        this.setZ(0);
    }

    public T setPosition(int x, int y) {
        if (this.isResponsiveSkew(x) && this.isResponsiveSkew(y)) {
            this.x = x;
            this.y = y;
        }
        return (T)this;
    }

    public T setPosition(Integer[] position) {
        if (position != null) {
            return this.setPosition(position[0], position[1]);
        }
        return (T)this;
    }

    public T setSize(int width, int height) {
        if (this.isResponsiveSize(width) && this.isResponsiveSize(height)) {
            this.width = width;
            this.height = height;
        }
        return (T)this;
    }

    public T setSize(Integer[] size) {
        if (size != null) {
            return this.setSize(size[0], size[1]);
        }
        return (T)this;
    }

    public T setAlign(AlignX alignX, AlignY alignY) {
        if (alignX != null) {
            this.alignX = alignX;
        }
        if (alignY != null) {
            this.alignY = alignY;
        }
        return (T)this;
    }

    public T setAlignX(AlignX alignX) {
        if (alignX != null) {
            this.alignX = alignX;
        }
        return (T)this;
    }

    public T setAlignY(AlignY alignY) {
        if (alignY != null) {
            this.alignY = alignY;
        }
        return (T)this;
    }

    public T setZ(Integer z) {
        if (z != null) {
            this.z = z;
        }
        return (T)this;
    }

    public T setDialoguesInfo(ResourceLocation dialoguesResourceLocation, String group, Integer index) {
        if (dialoguesResourceLocation != null && group != null && index != null) {
            this.dialoguesResourceLocation = dialoguesResourceLocation;
            this.group = group;
            this.index = index;
        }
        return (T)this;
    }

    public T setIndex(int index) {
        this.index = index;
        return (T)this;
    }

    public static int getResponsiveWidth(int value) {
        return minecraft.getWindow().getGuiScaledWidth() * value / 100;
    }

    public static int getResponsiveHeight(int value) {
        return minecraft.getWindow().getGuiScaledHeight() * value / 100;
    }

    protected boolean isResponsiveSkew(int value) {
        return value >= -100 && value <= 100;
    }

    protected boolean isResponsiveSize(int value) {
        return value >= 0 && value <= 100;
    }

    public Vec2 getCurrentPosition() {
        return new Vec2((float)this.alignX.getPositionX(this), (float)this.alignY.getPositionY(this));
    }

    public void renderImage(GuiGraphics guiGraphics, ResourceLocation texture) {
        Vec2 pos = this.getCurrentPosition();
        int x = (int)pos.x;
        int y = (int)pos.y;
        RenderUtil.renderImage(guiGraphics, texture, AbstractComponent.getResponsiveWidth(x), AbstractComponent.getResponsiveHeight(y), this.z, AbstractComponent.getResponsiveWidth(this.width), AbstractComponent.getResponsiveHeight(this.height));
    }

    public boolean isSelect(float width, float height, float x, float y, int mouseX, int mouseY) {
        return (float)mouseX > x && (float)mouseX < x + width && (float)mouseY > y && (float)mouseY < y + height;
    }

    public boolean isSelect(int mouseX, int mouseY) {
        Vec2 position = this.getCurrentPosition();
        return this.isSelect(AbstractComponent.getResponsiveWidth(this.width), AbstractComponent.getResponsiveHeight(this.height), AbstractComponent.getResponsiveWidth((int)position.x), AbstractComponent.getResponsiveHeight((int)position.y), mouseX, mouseY);
    }

    public String parseText(String input) {
        return ChatBoxUtil.parseText(input, false);
    }

    public abstract void render(GuiGraphics var1, int var2, int var3);

    public static enum AlignX {
        LEFT,
        CENTER,
        RIGHT;


        public int getPositionX(AbstractComponent<?> abstractComponent) {
            int x = abstractComponent.x;
            int width = abstractComponent.width;
            AlignX alignX = abstractComponent.alignX;
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"LEFT", "CENTER", "RIGHT"}, (AlignX)alignX, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> x;
                case 1 -> x + 50 - width / 2;
                case 2 -> x + 100 - width;
                case -1 -> x;
            };
        }

        public static AlignX of(String value) {
            if (value == null) {
                return LEFT;
            }
            return AlignX.valueOf(value.toUpperCase());
        }
    }

    public static enum AlignY {
        TOP,
        CENTER,
        BOTTOM;


        public int getPositionY(AbstractComponent<?> abstractComponent) {
            int y = abstractComponent.y;
            int height = abstractComponent.height;
            AlignY alignY = abstractComponent.alignY;
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TOP", "CENTER", "BOTTOM"}, (AlignY)alignY, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> y;
                case 1 -> y + 50 - height / 2;
                case 2 -> y + 100 - height;
                case -1 -> y;
            };
        }

        public static AlignY of(String value) {
            if (value == null) {
                return TOP;
            }
            return AlignY.valueOf(value.toUpperCase());
        }
    }
}

