/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.common.StrUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;

public class ChatOption
extends AbstractComponent<ChatOption> {
    public ResourceLocation texture = ChatBox.ResourceLocationMod("textures/options/default_no_checked_option.png");
    public ResourceLocation selectTexture = ChatBox.ResourceLocationMod("textures/options/default_checked_option.png");
    public ResourceLocation lockTexture = ChatBox.ResourceLocationMod("textures/options/default_no_checked_option.png");
    public Component optionChat = CommonComponents.EMPTY;
    public int optionChatX = 0;
    public int optionChatY = 0;
    public Runnable onClickEvent = () -> {};
    public boolean isLock = false;
    public Component optionTooltip = CommonComponents.EMPTY;
    public TextAlign textAlign = TextAlign.LEFT;
    public String next = "";

    public ChatOption() {
        this.defaultOption();
    }

    public ChatOption setOptionChat(String optionChat, boolean isTranslatable) {
        if (optionChat != null) {
            this.optionChat = isTranslatable ? Component.translatable((String)optionChat) : Component.nullToEmpty((String)optionChat);
        }
        return this;
    }

    public ChatOption setOptionTooltip(String optionTooltip, boolean isTranslatable) {
        if (optionTooltip != null) {
            this.optionTooltip = isTranslatable ? Component.translatable((String)optionTooltip) : Component.nullToEmpty((String)optionTooltip);
        }
        return this;
    }

    public ChatOption setTextures(ResourceLocation textures) {
        if (textures != null) {
            this.texture = textures;
        }
        return this;
    }

    public ChatOption setTextures(String textures) {
        if (textures != null) {
            return this.setTextures(ResourceLocation.parse((String)textures));
        }
        return this;
    }

    public ChatOption setSelectTexture(ResourceLocation selectTexture) {
        if (selectTexture != null) {
            this.selectTexture = selectTexture;
        }
        return this;
    }

    public ChatOption setSelectTexture(String selectTexture) {
        if (selectTexture != null) {
            return this.setSelectTexture(ResourceLocation.parse((String)selectTexture));
        }
        return this;
    }

    public ChatOption setLockTexture(ResourceLocation lockTexture) {
        if (lockTexture != null) {
            this.lockTexture = lockTexture;
        }
        return this;
    }

    public ChatOption setLockTexture(String lockTexture) {
        if (lockTexture != null) {
            return this.setLockTexture(ResourceLocation.parse((String)lockTexture));
        }
        return this;
    }

    public ChatOption setClickEvent(Runnable onClickEvent) {
        if (onClickEvent != null) {
            this.onClickEvent = onClickEvent;
        }
        return this;
    }

    public ChatOption setClickEvent(String type, String value) {
        if (type != null && value != null) {
            this.onClickEvent = () -> {
                if (ChatOption.minecraft.player != null && type.equals("command")) {
                    ChatOption.minecraft.player.connection.sendCommand(value);
                }
            };
        }
        return this;
    }

    public ChatOption setIsLock(boolean isLock) {
        this.isLock = isLock;
        return this;
    }

    public ChatOption setNext(String next) {
        if (next != null) {
            this.next = next;
        }
        return this;
    }

    public ChatOption setOptionChatPosition(int x, int y) {
        if (this.isResponsiveSkew(x) && this.isResponsiveSkew(y)) {
            this.optionChatX = x;
            this.optionChatY = y;
        }
        return this;
    }

    public ChatOption setOptionChatPosition(Integer[] optionChatPosition) {
        if (optionChatPosition != null) {
            return this.setOptionChatPosition(optionChatPosition[0], optionChatPosition[1]);
        }
        return this;
    }

    public ChatOption setTextAlign(TextAlign textAlign) {
        if (textAlign != null) {
            this.textAlign = textAlign;
        }
        return this;
    }

    public void click() {
        if (!this.isLock && ChatOption.minecraft.player != null) {
            this.onClickEvent.run();
            if (StrUtil.isEmpty(this.next)) {
                ChatBoxUtil.skipDialogues(ChatOption.minecraft.player.getUUID(), this.dialoguesResourceLocation, this.group, this.index + 1);
            } else if (StrUtil.isInteger(this.next)) {
                int index = Integer.parseInt(this.next);
                ChatBoxUtil.skipDialogues(ChatOption.minecraft.player.getUUID(), this.dialoguesResourceLocation, this.group, index);
            } else {
                ChatBoxUtil.skipDialogues(ChatOption.minecraft.player.getUUID(), this.dialoguesResourceLocation, this.next);
            }
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Vec2 pos = this.getCurrentPosition();
        int x = (int)pos.x;
        int y = (int)pos.y;
        int color = -1;
        ResourceLocation texture = this.texture;
        if (this.isLock) {
            texture = this.lockTexture;
            color = -8355712;
        } else if (this.isSelect(mouseX, mouseY)) {
            texture = this.selectTexture;
            color = -256;
        }
        this.renderImage(guiGraphics, texture);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        switch (this.textAlign.ordinal()) {
            case 0: {
                guiGraphics.drawString(ChatOption.minecraft.font, this.parseText(this.optionChat.getString()), ChatOption.getResponsiveWidth(x + this.width / 2 + this.optionChatX), ChatOption.getResponsiveHeight(y + this.height / 2 + this.optionChatY), color);
                break;
            }
            case 1: {
                guiGraphics.drawCenteredString(ChatOption.minecraft.font, this.parseText(this.optionChat.getString()), ChatOption.getResponsiveWidth(x + this.width / 2 + this.optionChatX), ChatOption.getResponsiveHeight(y + this.height / 2 + this.optionChatY), color);
            }
        }
        poseStack.popPose();
        if (!this.optionTooltip.getString().isEmpty() && this.isSelect(mouseX, mouseY)) {
            guiGraphics.renderTooltip(ChatOption.minecraft.font, this.optionTooltip, mouseX, mouseY);
        }
    }

    public static enum TextAlign {
        LEFT,
        CENTER;


        public static TextAlign of(String text) {
            if (text == null) {
                return LEFT;
            }
            return TextAlign.valueOf(text.toUpperCase());
        }
    }
}

