/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.common.StrUtil;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;

public class DialogBox
extends AbstractComponent<DialogBox> {
    public ResourceLocation texture = ChatBox.ResourceLocationMod("textures/chatbox/default_dialog_box.png");
    public Component text = CommonComponents.EMPTY;
    public Component name = CommonComponents.EMPTY;
    public int nameX;
    public int nameY;
    public int textX;
    public int textY;
    public int lineWidth = 100;
    public boolean isAllOver = false;
    public int tickCount = 0;
    private String[] textBuffer = new String[]{""};

    public DialogBox() {
        this.defaultOption();
    }

    public DialogBox setTexture(ResourceLocation texture) {
        if (texture != null) {
            this.texture = texture;
        }
        return this;
    }

    public DialogBox setTexture(String texture) {
        if (texture != null) {
            return this.setTexture(ResourceLocation.parse((String)texture));
        }
        return this;
    }

    public DialogBox setText(String text, boolean isTranslatable) {
        if (text != null) {
            this.text = isTranslatable ? Component.translatable((String)text) : Component.nullToEmpty((String)text);
            this.textToTextBuffer();
        }
        return this;
    }

    public DialogBox setName(String name, boolean isTranslatable) {
        if (name != null) {
            this.name = isTranslatable ? Component.translatable((String)name) : Component.nullToEmpty((String)name);
        }
        return this;
    }

    public DialogBox setNamePosition(int x, int y) {
        if (this.isResponsiveSkew(x) && this.isResponsiveSkew(y)) {
            this.nameX = x;
            this.nameY = y;
        }
        return this;
    }

    public DialogBox setNamePosition(Integer[] namePosition) {
        if (namePosition != null) {
            return this.setNamePosition(namePosition[0], namePosition[1]);
        }
        return this;
    }

    public DialogBox setTextPosition(int x, int y) {
        if (this.isResponsiveSkew(x) && this.isResponsiveSkew(y)) {
            this.textX = x;
            this.textY = y;
        }
        return this;
    }

    public DialogBox setTextPosition(Integer[] textPosition) {
        if (textPosition != null) {
            return this.setTextPosition(textPosition[0], textPosition[1]);
        }
        return this;
    }

    public DialogBox setLineWidth(int lineWidth) {
        if (this.isResponsiveSize(lineWidth)) {
            this.lineWidth = lineWidth;
        }
        return this;
    }

    public DialogBox setAllOver(boolean allOver) {
        this.isAllOver = allOver;
        return this;
    }

    public DialogBox resetTickCount() {
        this.tickCount = 0;
        return this;
    }

    private void textToTextBuffer() {
        String input = this.text.getString();
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int index = 0; index < input.length(); ++index) {
            char c = input.charAt(index);
            stringBuilder.append(c);
            if (c == '\\' || c == '\u00a7') {
                stringBuilder.append(input.charAt(index + 1));
                ++index;
            }
            result.add(stringBuilder.toString());
        }
        this.textBuffer = result.toArray(new String[0]);
    }

    public void click(int pMouseX, int pMouseY, boolean isOptionExist) {
        if (!this.isAllOver) {
            this.tickCount = this.textBuffer.length - 1;
            this.setAllOver(true);
        } else if (!isOptionExist && DialogBox.minecraft.player != null) {
            this.setIndex(this.index + 1);
            ChatBoxUtil.skipDialogues(DialogBox.minecraft.player.getUUID(), this.dialoguesResourceLocation, this.group, this.index);
        }
    }

    public void tick() {
        if (!this.isAllOver) {
            ++this.tickCount;
            if (this.tickCount == this.textBuffer.length - 1) {
                this.setAllOver(true);
            }
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderImage(guiGraphics, this.texture);
        Vec2 position = this.getCurrentPosition();
        int x = (int)position.x;
        int y = (int)position.y;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        if (StrUtil.isNotEmpty(this.name.getString())) {
            guiGraphics.drawWordWrap(DialogBox.minecraft.font, (FormattedText)Component.nullToEmpty((String)this.parseText(StrUtil.format("[{}]", this.name.getString()))), DialogBox.getResponsiveWidth(x + this.nameX), DialogBox.getResponsiveHeight(y + this.nameY), DialogBox.getResponsiveWidth(this.lineWidth), -1);
        }
        if (StrUtil.isNotEmpty(this.text.getString())) {
            guiGraphics.drawWordWrap(DialogBox.minecraft.font, (FormattedText)Component.nullToEmpty((String)this.parseText(this.textBuffer[this.tickCount])), DialogBox.getResponsiveWidth(x + this.textX), DialogBox.getResponsiveHeight(y + this.textY), DialogBox.getResponsiveWidth(this.lineWidth), -1);
        }
        poseStack.popPose();
    }
}

