/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.utils.chatbox.RenderUtil;
import com.zhenshiz.chatbox.utils.math.EasingUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.phys.Vec2;

public class Portrait
extends AbstractComponent<Portrait> {
    public Type type;
    public String value;
    public Integer opacity;
    public Integer customItemData;
    public AnimationType animationType;
    public EasingUtil.Easing easing;
    private Integer targetOpacity;
    private Integer targetY;
    private boolean isAnimation = false;
    private int currentAnimationTick = 0;
    private int durationAnimationTick = 20;

    public Portrait() {
        this.defaultOption();
    }

    public Portrait setType(Type type) {
        if (type != null) {
            this.type = type;
        }
        return this;
    }

    public Portrait setValue(String value) {
        if (value != null) {
            this.value = value;
        }
        return this;
    }

    public Portrait setOpacity(Integer opacity) {
        if (opacity != null && this.isResponsiveSize(opacity)) {
            this.opacity = opacity;
        }
        return this;
    }

    public Portrait setCustomItemData(Integer customItemData) {
        if (customItemData != null) {
            this.customItemData = customItemData;
        }
        return this;
    }

    public Portrait setAnimationType(AnimationType animationType) {
        if (animationType != null) {
            this.animationType = animationType;
        }
        return this;
    }

    public Portrait setAnimationType(String animationType) {
        if (animationType != null) {
            return this.setAnimationType(AnimationType.of(animationType));
        }
        return this;
    }

    public Portrait setIsAnimation(Boolean isAnimation) {
        if (isAnimation != null) {
            this.isAnimation = isAnimation;
        }
        return this;
    }

    public void resetCurrentAnimationTick() {
        this.currentAnimationTick = 0;
    }

    public Portrait setDurationAnimationTick(Integer durationAnimationTick) {
        if (durationAnimationTick != null) {
            this.durationAnimationTick = durationAnimationTick;
        }
        return this;
    }

    public Portrait setEasing(EasingUtil.Easing easing) {
        if (easing != null) {
            this.easing = easing;
        }
        return this;
    }

    public Portrait setEasing(String easing) {
        if (easing != null) {
            this.setEasing(EasingUtil.Easing.of(easing));
        }
        return this;
    }

    public void setTarget() {
        this.targetOpacity = this.opacity;
        this.targetY = this.y;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.type != null && this.value != null) {
            Vec2 position = this.getCurrentPosition();
            int x = (int)position.x;
            int y = (int)position.y;
            switch (this.type.ordinal()) {
                case 0: {
                    if (this.isAnimation) {
                        ++this.currentAnimationTick;
                        switch (this.animationType.ordinal()) {
                            case 1: {
                                this.setOpacity((int)EasingUtil.easingFunction(0, this.targetOpacity, this.currentAnimationTick, this.durationAnimationTick, this.easing));
                                break;
                            }
                            case 2: {
                                this.setPosition(this.x, (int)EasingUtil.easingFunction(this.targetY, 0, this.currentAnimationTick, this.durationAnimationTick, this.easing));
                                break;
                            }
                            case 3: {
                                int offset = 5;
                                if (this.currentAnimationTick >= this.durationAnimationTick / 2) {
                                    this.setPosition(this.x, (int)EasingUtil.easingFunction(this.targetY, this.targetY + offset, this.currentAnimationTick, this.durationAnimationTick, this.easing));
                                    break;
                                }
                                this.setPosition(this.x, (int)EasingUtil.easingFunction(this.targetY + offset, this.targetY, this.currentAnimationTick, this.durationAnimationTick, this.easing));
                            }
                        }
                        if (this.currentAnimationTick == this.durationAnimationTick) {
                            this.setIsAnimation(false);
                            this.resetCurrentAnimationTick();
                        }
                    }
                    RenderSystem.enableBlend();
                    guiGraphics.setColor(1.0f, 1.0f, 1.0f, (float)this.opacity.intValue() / 100.0f);
                    this.renderImage(guiGraphics, ResourceLocation.parse((String)this.value));
                    RenderSystem.disableBlend();
                    break;
                }
                case 1: {
                    RenderUtil.renderPlayerHead(guiGraphics, this.parseText(this.value), Portrait.getResponsiveWidth(x), Portrait.getResponsiveHeight(y), Portrait.getResponsiveWidth(this.width) + Portrait.getResponsiveHeight(this.height));
                    break;
                }
                case 2: {
                    ItemStack itemStack = ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)this.value))).getDefaultInstance();
                    if (this.customItemData != null) {
                        itemStack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(this.customItemData.intValue()));
                    }
                    RenderUtil.renderItem(guiGraphics, itemStack, Portrait.getResponsiveWidth(x), Portrait.getResponsiveHeight(y), (float)(this.width + this.height) / 2.0f);
                }
            }
        }
    }

    public static enum Type {
        TEXTURE,
        PLAYER_HEAD,
        ITEM;


        public static Type of(String type) {
            return Type.valueOf(type.toUpperCase());
        }
    }

    public static enum AnimationType {
        NONE,
        FADE_IN,
        SLIDE_IN_FROM_BOTTOM,
        BOUNCE;


        public static AnimationType of(String type) {
            return AnimationType.valueOf(type.toUpperCase());
        }
    }
}

