/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.data;

import com.zhenshiz.chatbox.component.ChatOption;
import com.zhenshiz.chatbox.component.Portrait;
import com.zhenshiz.chatbox.data.ChatBoxDialoguesLoader;
import com.zhenshiz.chatbox.data.ChatBoxTheme;
import com.zhenshiz.chatbox.data.ChatBoxThemeLoader;
import com.zhenshiz.chatbox.utils.common.CollUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class ChatBoxDialogues {
    private static final Integer[] DEFAULT_INT_ARRAY = new Integer[]{0, 0};
    private static final Boolean DEFAULT_BOOL = false;
    public DialogBox dialogBox;
    public List<Portrait> portrait;
    public List<Option> options;

    public ChatBoxDialogues(DialogBox dialogBox, List<Portrait> portrait, List<Option> options) {
        this.dialogBox = dialogBox;
        this.portrait = portrait;
        this.options = options;
    }

    public void setDefaultValue(ResourceLocation resourceLocation, String group, int index) {
        if (!CollUtil.isEmpty(this.options).booleanValue()) {
            for (Option option : this.options) {
                option.dialoguesResourceLocation = resourceLocation;
                option.group = group;
                option.index = index;
            }
        }
        this.dialogBox.dialoguesResourceLocation = resourceLocation;
        this.dialogBox.group = group;
        this.dialogBox.index = index;
    }

    public static class DialogBox {
        public String name;
        public String text;
        public Boolean isTranslatable = DEFAULT_BOOL;
        public ResourceLocation dialoguesResourceLocation;
        public String group;
        public Integer index;

        public com.zhenshiz.chatbox.component.DialogBox setDialogBoxDialogues(com.zhenshiz.chatbox.component.DialogBox dialogBox) {
            return this.setDialogBoxDialogues(dialogBox, this.index);
        }

        public com.zhenshiz.chatbox.component.DialogBox setDialogBoxDialogues(com.zhenshiz.chatbox.component.DialogBox dialogBox, int index) {
            this.index = index;
            return ((com.zhenshiz.chatbox.component.DialogBox)dialogBox.setName(this.name, this.isTranslatable).setText(this.text, this.isTranslatable).setDialoguesInfo(this.dialoguesResourceLocation, this.group, index)).resetTickCount();
        }
    }

    public static class Option {
        public String text;
        public Boolean isTranslatable = DEFAULT_BOOL;
        public Boolean isLock = DEFAULT_BOOL;
        public Condition lock = new Condition();
        public Condition hidden = new Condition();
        public Boolean isHidden = DEFAULT_BOOL;
        public String next;
        public Click click = new Click();
        public String tooltip;
        public ResourceLocation dialoguesResourceLocation;
        public String group;
        public Integer index;

        public static List<ChatOption> setChatOptionDialogues(ResourceLocation themeResourceLocation, ResourceLocation dialoguesResourceLocation, String group, int index) {
            ChatBoxTheme theme = ChatBoxThemeLoader.INSTANCE.getTheme(themeResourceLocation);
            List<ChatBoxDialogues> chatBoxDialogues = ChatBoxDialoguesLoader.INSTANCE.getDialogues(dialoguesResourceLocation).get(group);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ServerScoreboard scoreboard = null;
            if (server != null) {
                ArrayList<ChatOption> chatOptions = new ArrayList<ChatOption>();
                if (index >= 0 && index < chatBoxDialogues.size()) {
                    ChatBoxDialogues chatBoxDialogue = chatBoxDialogues.get(index);
                    int i = -1;
                    ChatBoxTheme.Option option = theme.option;
                    for (Option value : chatBoxDialogue.options) {
                        scoreboard = server.getScoreboard();
                        Objective objective = scoreboard.getObjective(value.hidden.objective);
                        ScoreAccess scoreAccess = null;
                        if (objective != null) {
                            scoreAccess = scoreboard.getOrCreatePlayerScore(ScoreHolder.forNameOnly((String)value.hidden.value), objective);
                        }
                        if (value.isHidden.booleanValue() && (scoreAccess == null || scoreAccess.get() != 1)) continue;
                        ++i;
                        objective = scoreboard.getObjective(value.lock.objective);
                        if (objective != null) {
                            scoreAccess = scoreboard.getOrCreatePlayerScore(ScoreHolder.forNameOnly((String)value.lock.value), objective);
                        }
                        ChatOption chatOption = (ChatOption)new ChatOption().setOptionTooltip(value.tooltip, value.isTranslatable).setOptionChat(value.text, value.isTranslatable).setIsLock(value.isLock != false && (scoreAccess == null || scoreAccess.get() != 1)).setNext(value.next).setClickEvent(value.click.type, value.click.value).setDialoguesInfo(dialoguesResourceLocation, group, index);
                        chatOptions.add(option.setChatOptionTheme(chatOption, i));
                    }
                }
                return chatOptions;
            }
            return new ArrayList<ChatOption>();
        }

        public static class Condition {
            public String objective;
            public String value;
        }

        public static class Click {
            public String type;
            public String value;
        }
    }

    public static class Portrait {
        public String type;
        public String value;

        public static List<com.zhenshiz.chatbox.component.Portrait> setPortraitDialogues(List<Portrait> portraits, ResourceLocation themeResourceLocation) {
            ChatBoxTheme theme = ChatBoxThemeLoader.INSTANCE.getTheme(themeResourceLocation);
            Map<String, ChatBoxTheme.Portrait> map = theme.portrait;
            ArrayList<com.zhenshiz.chatbox.component.Portrait> portraitList = new ArrayList<com.zhenshiz.chatbox.component.Portrait>();
            if (map != null && !map.isEmpty()) {
                portraits.forEach(p -> {
                    com.zhenshiz.chatbox.component.Portrait portrait = ((ChatBoxTheme.Portrait)map.get(p.value)).setPortraitTheme(new com.zhenshiz.chatbox.component.Portrait()).setType(Portrait.Type.of(p.type)).setIsAnimation(true);
                    portrait.setTarget();
                    portraitList.add(portrait);
                });
            }
            return portraitList;
        }
    }
}

