/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.data;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.zhenshiz.chatbox.data.ChatBoxDialogues;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class ChatBoxDialoguesLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final ChatBoxDialoguesLoader INSTANCE = new ChatBoxDialoguesLoader();
    public final Map<ResourceLocation, JsonElement> dialoguesMap = new HashMap<ResourceLocation, JsonElement>();

    public ChatBoxDialoguesLoader() {
        super(GSON, "chatbox/dialogues");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        this.dialoguesMap.clear();
        resourceManager.listPacks().forEach(packResources -> {
            Set namespaces = packResources.getNamespaces(PackType.SERVER_DATA);
            namespaces.forEach(namespace -> packResources.listResources(PackType.SERVER_DATA, namespace, "chatbox/dialogues", (resourceLocation, inputStreamIoSupplier) -> {
                String path = resourceLocation.getPath();
                ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path.substring("chatbox/dialogues/".length(), path.length() - ".json".length()));
                JsonElement jsonElement = (JsonElement)resourceLocationJsonElementMap.get(rl);
                if (jsonElement != null) {
                    this.dialoguesMap.put(rl, jsonElement);
                }
            }));
        });
    }

    public Map<String, List<ChatBoxDialogues>> getDialogues(ResourceLocation resourceLocation) {
        JsonElement jsonElement = this.dialoguesMap.get(resourceLocation);
        if (jsonElement == null) {
            return null;
        }
        JsonElement dialoguesElement = jsonElement.getAsJsonObject().get("dialogues");
        if (dialoguesElement != null) {
            Map map = (Map)GSON.fromJson(dialoguesElement, new TypeToken<Map<String, List<ChatBoxDialogues>>>(){}.getType());
            for (Map.Entry entry : map.entrySet()) {
                int index = 0;
                ((List)entry.getValue()).forEach(chatBoxDialogues -> chatBoxDialogues.setDefaultValue(resourceLocation, (String)entry.getKey(), index));
            }
            return map;
        }
        return null;
    }
}

