/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.screen;

import com.zhenshiz.chatbox.component.ChatOption;
import com.zhenshiz.chatbox.component.DialogBox;
import com.zhenshiz.chatbox.component.LogButton;
import com.zhenshiz.chatbox.component.Portrait;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ChatBoxScreen
extends Screen {
    public List<ChatOption> chatOptions = new ArrayList<ChatOption>();
    public List<Portrait> portraits = new ArrayList<Portrait>();
    public DialogBox dialogBox = new DialogBox();
    public LogButton logButton = new LogButton();

    public ChatBoxScreen() {
        super(Component.nullToEmpty((String)"ChatBoxScreen"));
    }

    public ChatBoxScreen setChatOptions(ChatOption chatOption) {
        if (chatOption != null) {
            this.chatOptions.add(chatOption);
        }
        return this;
    }

    public ChatBoxScreen setChatOptions(List<ChatOption> chatOptions) {
        if (chatOptions != null) {
            this.chatOptions = chatOptions;
        }
        return this;
    }

    public ChatBoxScreen setDialogBox(DialogBox dialogBox) {
        if (dialogBox != null) {
            this.dialogBox = dialogBox;
        }
        return this;
    }

    public ChatBoxScreen setPortrait(List<Portrait> portraits) {
        if (portraits != null) {
            this.portraits = portraits;
        }
        return this;
    }

    public ChatBoxScreen setLogButton(LogButton logButton) {
        if (logButton != null) {
            this.logButton = logButton;
        }
        return this;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.dialogBox != null) {
            this.dialogBox.render(guiGraphics, pMouseX, pMouseY);
            if (this.chatOptions != null) {
                for (ChatOption chatOption : this.chatOptions) {
                    chatOption.render(guiGraphics, pMouseX, pMouseY);
                }
            }
            if (this.portraits != null) {
                for (Portrait portrait : this.portraits) {
                    portrait.render(guiGraphics, pMouseX, pMouseY);
                }
            }
            if (this.logButton != null) {
                this.logButton.render(guiGraphics, pMouseX, pMouseY);
            }
        }
        super.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0 && this.dialogBox != null) {
            for (ChatOption chatOption : this.chatOptions) {
                if (!chatOption.isSelect((int)pMouseX, (int)pMouseY) || !this.dialogBox.isAllOver) continue;
                chatOption.click();
                return super.mouseClicked(pMouseX, pMouseY, pButton);
            }
            if (this.logButton.isSelect((int)pMouseX, (int)pMouseY)) {
                this.logButton.click();
                return super.mouseClicked(pMouseX, pMouseY, pButton);
            }
            this.dialogBox.click((int)pMouseX, (int)pMouseY, !this.chatOptions.isEmpty());
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public void tick() {
        if (this.dialogBox != null) {
            this.dialogBox.tick();
        }
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }
}

