/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.utils.chatbox;

import com.zhenshiz.chatbox.component.ChatOption;
import com.zhenshiz.chatbox.component.DialogBox;
import com.zhenshiz.chatbox.component.HistoricalDialogue;
import com.zhenshiz.chatbox.data.ChatBoxDialogues;
import com.zhenshiz.chatbox.data.ChatBoxDialoguesLoader;
import com.zhenshiz.chatbox.data.ChatBoxTheme;
import com.zhenshiz.chatbox.data.ChatBoxThemeLoader;
import com.zhenshiz.chatbox.screen.ChatBoxScreen;
import com.zhenshiz.chatbox.screen.HistoricalDialogueScreen;
import com.zhenshiz.chatbox.utils.common.CollUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

public class ChatBoxUtil {
    private static final Minecraft minecraft = Minecraft.getInstance();
    public static final Map<UUID, ResourceLocation> playerChatBoxTheme = new HashMap<UUID, ResourceLocation>();
    public static final Map<UUID, ChatBoxScreen> chatBoxScreens = new HashMap<UUID, ChatBoxScreen>();
    public static final Map<UUID, HistoricalDialogueScreen> historicalDialogue = new HashMap<UUID, HistoricalDialogueScreen>();

    public static void skipDialogues(UUID uuid, ResourceLocation dialoguesResourceLocation, String dialogBlock, int index) {
        List<ChatBoxDialogues> chatBoxDialogues = ChatBoxDialoguesLoader.INSTANCE.getDialogues(dialoguesResourceLocation).get(dialogBlock);
        ChatBoxScreen chatBoxScreen = chatBoxScreens.get(uuid);
        ResourceLocation themeResourceLocation = playerChatBoxTheme.get(uuid);
        if (index >= 0 && index < chatBoxDialogues.size()) {
            ChatBoxDialogues dialogue = chatBoxDialogues.get(index);
            ChatBoxDialogues.DialogBox dialogBox = dialogue.dialogBox;
            chatBoxScreen.setDialogBox(dialogBox != null ? dialogBox.setDialogBoxDialogues(chatBoxScreen.dialogBox, index) : new DialogBox()).setPortrait(CollUtil.isEmpty(dialogue.portrait) == false ? ChatBoxDialogues.Portrait.setPortraitDialogues(dialogue.portrait, themeResourceLocation) : new ArrayList()).setChatOptions(CollUtil.isEmpty(dialogue.options) == false ? ChatBoxDialogues.Option.setChatOptionDialogues(themeResourceLocation, dialoguesResourceLocation, dialogBlock, index) : new ArrayList<ChatOption>());
            chatBoxScreen.dialogBox.resetTickCount();
            chatBoxScreen.dialogBox.setAllOver(false);
            if (ChatBoxUtil.minecraft.screen == null) {
                historicalDialogue.put(uuid, new HistoricalDialogueScreen());
                minecraft.setScreen((Screen)chatBoxScreen);
            }
            HistoricalDialogueScreen historicalDialogueScreen = historicalDialogue.get(uuid);
            if (dialogBox != null) {
                historicalDialogueScreen.historicalDialogue.addHistoricalInfo(new HistoricalDialogue.HistoricalInfo(dialoguesResourceLocation, dialogBlock, index).setName(dialogBox.name, dialogBox.isTranslatable).setText(dialogBox.text, dialogBox.isTranslatable));
            }
        } else if (ChatBoxUtil.minecraft.screen != null) {
            ChatBoxUtil.minecraft.screen.onClose();
        }
        if (uuid != null) {
            chatBoxScreens.put(uuid, chatBoxScreen);
        }
    }

    public static void skipDialogues(UUID uuid, ResourceLocation dialoguesResourceLocation, String dialogBlock) {
        ChatBoxUtil.skipDialogues(uuid, dialoguesResourceLocation, dialogBlock, 0);
    }

    public static void toggleTheme(UUID uuid, ResourceLocation themeResourceLocation) {
        ChatBoxScreen chatBoxScreen = chatBoxScreens.get(uuid);
        ChatBoxTheme theme = ChatBoxThemeLoader.INSTANCE.getTheme(themeResourceLocation);
        chatBoxScreen.setDialogBox(theme.dialogBox.setDialogBoxTheme(chatBoxScreen.dialogBox)).setLogButton(theme.logButton.setLogButtonTheme(chatBoxScreen.logButton));
        if (uuid != null) {
            chatBoxScreens.put(uuid, chatBoxScreen);
            playerChatBoxTheme.put(uuid, themeResourceLocation);
        }
    }

    public static String parseText(String input, boolean isLineBreak) {
        if (ChatBoxUtil.minecraft.player != null) {
            input = input.replaceAll("(?<!@)@s", ChatBoxUtil.minecraft.player.getDisplayName().getString());
            if (isLineBreak) {
                input = input.replaceAll("\n", "");
            }
            return input.replaceAll("@@", "@");
        }
        return input;
    }
}

