/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.utils.chatbox;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Point;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;

public class RenderUtil {
    private static final Minecraft minecraft = Minecraft.getInstance();
    private static Supplier<PlayerSkin> supplier = null;

    public static int screenWidth() {
        return minecraft.getWindow().getGuiScaledWidth();
    }

    public static int screenHeight() {
        return minecraft.getWindow().getGuiScaledHeight();
    }

    public static void fillRect(GuiGraphics guiGraphics, int x, int y, int w, int h, int color) {
        BufferBuilder buf = RenderUtil.getTesselator().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f mat = guiGraphics.pose().last().pose();
        buf.addVertex(mat, (float)x, (float)y, 0.0f).setColor(color);
        buf.addVertex(mat, (float)(x + w), (float)y, 0.0f).setColor(color);
        buf.addVertex(mat, (float)(x + w), (float)(y + h), 0.0f).setColor(color);
        buf.addVertex(mat, (float)x, (float)(y + h), 0.0f).setColor(color);
        RenderUtil.beginRendering();
        BufferUploader.drawWithShader((MeshData)Objects.requireNonNull(buf.build()));
        RenderUtil.finishRendering();
    }

    public static void fillArc(GuiGraphics guiGraphics, int cX, int cY, int radius, int start, int end, int color) {
        BufferBuilder buf = RenderUtil.getTesselator().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f mat = guiGraphics.pose().last().pose();
        buf.addVertex(mat, (float)cX, (float)cY, 0.0f).setColor(color);
        for (int i = start - 90; i <= end - 90; ++i) {
            double angle = Math.toRadians(i);
            float x = (float)(Math.cos(angle) * (double)radius) + (float)cX;
            float y = (float)(Math.sin(angle) * (double)radius) + (float)cY;
            buf.addVertex(mat, x, y, 0.0f).setColor(color);
        }
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillCircle(GuiGraphics guiGraphics, int cX, int cY, int radius, int color) {
        RenderUtil.fillArc(guiGraphics, cX, cY, radius, 0, 360, color);
    }

    public static void fillAnnulusArc(GuiGraphics guiGraphics, int cx, int cy, int radius, int start, int end, int thickness, int color) {
        BufferBuilder buf = RenderUtil.getTesselator().begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f mat = guiGraphics.pose().last().pose();
        for (int i = start - 90; i <= end - 90; ++i) {
            float angle = (float)Math.toRadians(i);
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            float x1 = (float)cx + cos * (float)radius;
            float y1 = (float)cy + sin * (float)radius;
            float x2 = (float)cx + cos * (float)(radius + thickness);
            float y2 = (float)cy + sin * (float)(radius + thickness);
            buf.addVertex(mat, x1, y1, 0.0f).setColor(color);
            buf.addVertex(mat, x2, y2, 0.0f).setColor(color);
        }
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillAnnulus(GuiGraphics guiGraphics, int cx, int cy, int radius, int thickness, int color) {
        RenderUtil.fillAnnulusArc(guiGraphics, cx, cy, radius, 0, 360, thickness, color);
    }

    public static void fillRoundRect(GuiGraphics guiGraphics, int x, int y, int w, int h, int r, int color) {
        r = Mth.clamp((int)r, (int)0, (int)(Math.min(w, h) / 2));
        BufferBuilder buf = RenderUtil.getTesselator().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f mat = guiGraphics.pose().last().pose();
        buf.addVertex(mat, (float)x + (float)w / 2.0f, (float)y + (float)h / 2.0f, 0.0f).setColor(color);
        int[][] corners = new int[][]{{x + w - r, y + r}, {x + w - r, y + h - r}, {x + r, y + h - r}, {x + r, y + r}};
        for (int corner = 0; corner < 4; ++corner) {
            int cornerStart = (corner - 1) * 90;
            int cornerEnd = cornerStart + 90;
            for (int i = cornerStart; i <= cornerEnd; i += 10) {
                float angle = (float)Math.toRadians(i);
                float rx = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)r);
                float ry = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)r);
                buf.addVertex(mat, rx, ry, 0.0f).setColor(color);
            }
        }
        buf.addVertex(mat, (float)corners[0][0], (float)y, 0.0f).setColor(color);
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillRoundShadow(GuiGraphics guiGraphics, int x, int y, int w, int h, int r, int thickness, int innerColor, int outerColor) {
        r = Mth.clamp((int)r, (int)0, (int)(Math.min(w, h) / 2));
        BufferBuilder buf = RenderUtil.getTesselator().begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f mat = guiGraphics.pose().last().pose();
        int[][] corners = new int[][]{{x + w - r, y + r}, {x + w - r, y + h - r}, {x + r, y + h - r}, {x + r, y + r}};
        for (int corner = 0; corner < 4; ++corner) {
            int cornerStart = (corner - 1) * 90;
            int cornerEnd = cornerStart + 90;
            for (int i = cornerStart; i <= cornerEnd; i += 10) {
                float angle = (float)Math.toRadians(i);
                float rx1 = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)r);
                float ry1 = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)r);
                float rx2 = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)(r + thickness));
                float ry2 = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)(r + thickness));
                buf.addVertex(mat, rx1, ry1, 0.0f).setColor(innerColor);
                buf.addVertex(mat, rx2, ry2, 0.0f).setColor(outerColor);
            }
        }
        buf.addVertex(mat, (float)corners[0][0], (float)y, 0.0f).setColor(innerColor);
        buf.addVertex(mat, (float)corners[0][0], (float)(y - thickness), 0.0f).setColor(outerColor);
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillRoundTabTop(GuiGraphics guiGraphics, int x, int y, int w, int h, int r, int color) {
        r = Mth.clamp((int)r, (int)0, (int)(Math.min(w, h) / 2));
        BufferBuilder buf = RenderUtil.getTesselator().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f mat = guiGraphics.pose().last().pose();
        buf.addVertex(mat, (float)x + (float)w / 2.0f, (float)y + (float)h / 2.0f, 0.0f).setColor(color);
        int[][] corners = new int[][]{{x + r, y + r}, {x + w - r, y + r}};
        for (int corner = 0; corner < 2; ++corner) {
            int cornerStart = (corner - 2) * 90;
            int cornerEnd = cornerStart + 90;
            for (int i = cornerStart; i <= cornerEnd; i += 10) {
                float angle = (float)Math.toRadians(i);
                float rx = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)r);
                float ry = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)r);
                buf.addVertex(mat, rx, ry, 0.0f).setColor(color);
            }
        }
        buf.addVertex(mat, (float)(x + w), (float)(y + h), 0.0f).setColor(color);
        buf.addVertex(mat, (float)x, (float)(y + h), 0.0f).setColor(color);
        buf.addVertex(mat, (float)x, (float)corners[0][1], 0.0f).setColor(color);
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillRoundTabBottom(GuiGraphics guiGraphics, int x, int y, int w, int h, int r, int color) {
        r = Mth.clamp((int)r, (int)0, (int)(Math.min(w, h) / 2));
        BufferBuilder buf = RenderUtil.getTesselator().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f mat = guiGraphics.pose().last().pose();
        buf.addVertex(mat, (float)x + (float)w / 2.0f, (float)y + (float)h / 2.0f, 0.0f).setColor(color);
        int[][] corners = new int[][]{{x + w - r, y + h - r}, {x + r, y + h - r}};
        for (int corner = 0; corner < 2; ++corner) {
            int cornerStart = corner * 90;
            int cornerEnd = cornerStart + 90;
            for (int i = cornerStart; i <= cornerEnd; i += 10) {
                float angle = (float)Math.toRadians(i);
                float rx = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)r);
                float ry = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)r);
                buf.addVertex(mat, rx, ry, 0.0f).setColor(color);
            }
        }
        buf.addVertex(mat, (float)x, (float)y, 0.0f).setColor(color);
        buf.addVertex(mat, (float)(x + w), (float)y, 0.0f).setColor(color);
        buf.addVertex(mat, (float)(x + w), (float)corners[0][1], 0.0f).setColor(color);
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillRoundHorLine(GuiGraphics guiGraphics, int x, int y, int length, int thickness, int color) {
        RenderUtil.fillRoundRect(guiGraphics, x, y, length, thickness, thickness / 2, color);
    }

    public static void fillRoundVerLine(GuiGraphics guiGraphics, int x, int y, int length, int thickness, int color) {
        RenderUtil.fillRoundRect(guiGraphics, x, y, thickness, length, thickness / 2, color);
    }

    public static void drawRect(GuiGraphics guiGraphics, int x, int y, int w, int h, int color) {
        RenderUtil.drawHorLine(guiGraphics, x, y, w, color);
        RenderUtil.drawVerLine(guiGraphics, x, y + 1, h - 2, color);
        RenderUtil.drawVerLine(guiGraphics, x + w - 1, y + 1, h - 2, color);
        RenderUtil.drawHorLine(guiGraphics, x, y + h - 1, w, color);
    }

    public static void drawBox(GuiGraphics guiGraphics, int x, int y, int w, int h, int color) {
        RenderUtil.drawLine(guiGraphics, x, y, x + w, y, color);
        RenderUtil.drawLine(guiGraphics, x, y + h, x + w, y + h, color);
        RenderUtil.drawLine(guiGraphics, x, y, x, y + h, color);
        RenderUtil.drawLine(guiGraphics, x + w, y, x + w, y + h, color);
    }

    public static void drawHorLine(GuiGraphics guiGraphics, int x, int y, int length, int color) {
        RenderUtil.fillRect(guiGraphics, x, y, length, 1, color);
    }

    public static void drawVerLine(GuiGraphics guiGraphics, int x, int y, int length, int color) {
        RenderUtil.fillRect(guiGraphics, x, y, 1, length, color);
    }

    public static void drawLine(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int color) {
        BufferBuilder buf = RenderUtil.getTesselator().begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f mat = guiGraphics.pose().last().pose();
        buf.addVertex(mat, (float)x1, (float)y1, 0.0f).setColor(color);
        buf.addVertex(mat, (float)x2, (float)y2, 0.0f).setColor(color);
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void drawArc(GuiGraphics guiGraphics, int cX, int cY, int radius, int start, int end, int color) {
        BufferBuilder buf = RenderUtil.getTesselator().begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f mat = guiGraphics.pose().last().pose();
        for (int i = start - 90; i <= end - 90; ++i) {
            double angle = Math.toRadians(i);
            float x = (float)(Math.cos(angle) * (double)radius) + (float)cX;
            float y = (float)(Math.sin(angle) * (double)radius) + (float)cY;
            buf.addVertex(mat, x, y, 0.0f).setColor(color);
        }
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void drawCircle(GuiGraphics guiGraphics, int cX, int cY, int radius, int color) {
        RenderUtil.drawArc(guiGraphics, cX, cY, radius, 0, 360, color);
    }

    public static void drawRoundRect(GuiGraphics guiGraphics, int x, int y, int w, int h, int r, int color) {
        r = Mth.clamp((int)r, (int)0, (int)(Math.min(w, h) / 2));
        BufferBuilder buf = RenderUtil.getTesselator().begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f mat = guiGraphics.pose().last().pose();
        int[][] corners = new int[][]{{x + w - r, y + r}, {x + w - r, y + h - r}, {x + r, y + h - r}, {x + r, y + r}};
        for (int corner = 0; corner < 4; ++corner) {
            int cornerStart = (corner - 1) * 90;
            int cornerEnd = cornerStart + 90;
            for (int i = cornerStart; i <= cornerEnd; i += 10) {
                float angle = (float)Math.toRadians(i);
                float rx = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)r);
                float ry = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)r);
                buf.addVertex(mat, rx, ry, 0.0f).setColor(color);
            }
        }
        buf.addVertex(mat, (float)corners[0][0], (float)y, 0.0f).setColor(color);
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void drawRoundHorLine(GuiGraphics guiGraphics, int x, int y, int length, int thickness, int color) {
        RenderUtil.drawRoundRect(guiGraphics, x, y, length, thickness, thickness / 2, color);
    }

    public static void drawRoundVerLine(GuiGraphics guiGraphics, int x, int y, int length, int thickness, int color) {
        RenderUtil.drawRoundRect(guiGraphics, x, y, thickness, length, thickness / 2, color);
    }

    public static void renderImage(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int x, int y, int z, int uw, int uh, int width, int height) {
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        bufferBuilder.addVertex(matrix4f, (float)x, (float)y, (float)z).setUv(0.0f, 0.0f);
        bufferBuilder.addVertex(matrix4f, (float)x, (float)(y + height), (float)z).setUv(0.0f, (float)uh);
        bufferBuilder.addVertex(matrix4f, (float)(x + width), (float)(y + height), (float)z).setUv((float)uw, (float)uh);
        bufferBuilder.addVertex(matrix4f, (float)(x + width), (float)y, (float)z).setUv((float)uw, 0.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
        RenderSystem.enableBlend();
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }

    public static void renderImage(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int x, int y, int z, int width, int height) {
        RenderUtil.renderImage(guiGraphics, resourceLocation, x, y, z, 1, 1, width, height);
    }

    public static void renderPlayerHead(GuiGraphics guiGraphics, String input, int x, int y, int size) {
        RenderUtil.handleGameProfileAsync(input, gameProfile -> {
            supplier = RenderUtil.texturesSupplier(gameProfile);
        });
        PlayerFaceRenderer.draw((GuiGraphics)guiGraphics, (ResourceLocation)(supplier == null ? DefaultPlayerSkin.getDefaultTexture() : supplier.get().texture()), (int)x, (int)y, (int)size);
    }

    public static void renderItem(GuiGraphics guiGraphics, ItemStack item, int x, int y, float scale, String text) {
        x = (int)((float)x / scale);
        y = (int)((float)y / scale);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(scale, scale, scale);
        guiGraphics.renderItem(item, x, y);
        guiGraphics.renderItemDecorations(RenderUtil.minecraft.font, item, x, y, text);
        guiGraphics.pose().popPose();
    }

    public static void renderItem(GuiGraphics guiGraphics, ItemStack item, int x, int y, float scale) {
        RenderUtil.renderItem(guiGraphics, item, x, y, scale, "");
    }

    public static void drawLeftScaleText(GuiGraphics guiGraphics, Component component, int x, int y, float scale, boolean shadow, int color) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.scale(scale, scale, scale);
        float rescale = 1.0f / scale;
        x = (int)((float)x * rescale);
        y = (int)((float)y * rescale);
        guiGraphics.drawString(RenderUtil.minecraft.font, component, x, y, color, shadow);
        poseStack.scale(rescale, rescale, rescale);
    }

    public static void drawCenterScaleText(GuiGraphics guiGraphics, Component component, int centerX, int y, float scale, boolean shadow, int color) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.scale(scale, scale, scale);
        float rescale = 1.0f / scale;
        centerX = (int)((float)centerX * rescale);
        y = (int)((float)y * rescale);
        guiGraphics.drawString(RenderUtil.minecraft.font, component, centerX -= RenderUtil.minecraft.font.width((FormattedText)component) / 2, y, color, shadow);
        poseStack.scale(rescale, rescale, rescale);
    }

    public static void drawRightScaleText(GuiGraphics guiGraphics, Component component, int rightX, int y, float scale, boolean shadow, int color) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.scale(scale, scale, scale);
        float rescale = 1.0f / scale;
        rightX = (int)((float)rightX * rescale);
        y = (int)((float)y * rescale);
        guiGraphics.drawString(RenderUtil.minecraft.font, component, rightX -= RenderUtil.minecraft.font.width((FormattedText)component), y, color, shadow);
        poseStack.scale(rescale, rescale, rescale);
    }

    public static void setCursor(int x, int y) {
        Window window = minecraft.getWindow();
        int w1 = window.getWidth();
        int w2 = RenderUtil.screenWidth();
        int h1 = window.getHeight();
        int h2 = RenderUtil.screenHeight();
        double ratW = (double)w2 / (double)w1;
        double ratH = (double)h2 / (double)h1;
        GLFW.glfwSetCursorPos((long)window.getWindow(), (double)((double)x / ratW), (double)((double)y / ratH));
    }

    public static Point getCursor() {
        Window window = minecraft.getWindow();
        int w1 = window.getWidth();
        int w2 = RenderUtil.screenWidth();
        int h1 = window.getHeight();
        int h2 = RenderUtil.screenHeight();
        double rW = (double)w2 / (double)w1;
        double rH = (double)h2 / (double)h1;
        return new Point((int)(rW * RenderUtil.minecraft.mouseHandler.xpos()), (int)(rH * RenderUtil.minecraft.mouseHandler.ypos()));
    }

    private static void drawBuffer(BufferBuilder buf) {
        BufferUploader.drawWithShader((MeshData)Objects.requireNonNull(buf.build()));
    }

    public static void beginRendering() {
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
    }

    public static void finishRendering() {
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
    }

    private static Tesselator getTesselator() {
        return Tesselator.getInstance();
    }

    private static void handleGameProfileAsync(String input, Consumer<GameProfile> postAction) {
        ResolvableProfile component = RenderUtil.createProfileComponent(input);
        ((CompletableFuture)component.resolve().thenApplyAsync(result -> {
            GameProfile profile = result.gameProfile();
            postAction.accept(profile);
            return profile;
        })).exceptionally(ex -> null);
    }

    private static ResolvableProfile createProfileComponent(String input) {
        try {
            UUID uuid = UUID.fromString(input);
            return new ResolvableProfile(Optional.empty(), Optional.of(uuid), new PropertyMap());
        }
        catch (IllegalArgumentException e) {
            return new ResolvableProfile(Optional.of(input), Optional.empty(), new PropertyMap());
        }
    }

    private static Supplier<PlayerSkin> texturesSupplier(GameProfile profile) {
        Minecraft minecraft = Minecraft.getInstance();
        SkinManager skinManager = minecraft.getSkinManager();
        CompletableFuture completableFuture = skinManager.getOrLoad(profile);
        boolean bl = !minecraft.isLocalPlayer(profile.getId());
        PlayerSkin playerSkin = DefaultPlayerSkin.get((GameProfile)profile);
        return () -> {
            PlayerSkin PlayerSkin2 = completableFuture.getNow(playerSkin);
            return bl && !PlayerSkin2.secure() ? playerSkin : PlayerSkin2;
        };
    }
}

