/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.chatbox.RenderUtil;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;

public abstract class AbstractComponent<T extends AbstractComponent<T>> {
    protected static final Minecraft minecraft = Minecraft.m_91087_();
    public AlignX alignX;
    public AlignY alignY;
    public float x;
    public float y;
    public float width;
    public float height;
    public Float opacity;
    public Integer renderOrder;
    public ResourceLocation dialoguesResourceLocation;
    public String group;
    public Integer index;

    public static float getResponsiveWidth(float value) {
        return (float)minecraft.m_91268_().m_85445_() * value / 100.0f;
    }

    public static float getResponsiveHeight(float value) {
        return (float)minecraft.m_91268_().m_85446_() * value / 100.0f;
    }

    protected static <T> T getValueOrDefault(T param, T defaultValue) {
        return Optional.ofNullable(param).orElse(defaultValue);
    }

    protected void defaultOption() {
        this.setPosition(0.0f, 0.0f);
        this.setSize(10.0f, 10.0f);
        this.setAlign(AlignX.LEFT, AlignY.TOP);
    }

    public T setDefaultOption(float x, float y, float width, float height, AlignX alignX, AlignY alignY, Float opacity, Integer renderOrder) {
        this.setPosition(x, y);
        this.setSize(width, height);
        this.setAlign(alignX, alignY);
        this.setOpacity(opacity);
        this.setRenderOrder(renderOrder);
        return (T)this;
    }

    public T setPosition(float x, float y) {
        this.x = x;
        this.y = y;
        return (T)this;
    }

    public T setSize(float width, float height) {
        if (this.checkSize(width) && this.checkSize(height)) {
            this.width = width;
            this.height = height;
        }
        return (T)this;
    }

    public T setAlign(AlignX alignX, AlignY alignY) {
        if (alignX != null) {
            this.alignX = alignX;
        }
        if (alignY != null) {
            this.alignY = alignY;
        }
        return (T)this;
    }

    public T setAlignX(AlignX alignX) {
        if (alignX != null) {
            this.alignX = alignX;
        }
        return (T)this;
    }

    public T setAlignY(AlignY alignY) {
        if (alignY != null) {
            this.alignY = alignY;
        }
        return (T)this;
    }

    public T setOpacity(Float opacity) {
        if (opacity != null && this.checkSize(opacity.floatValue())) {
            this.opacity = opacity;
        }
        return (T)this;
    }

    public T setRenderOrder(Integer renderOrder) {
        if (renderOrder != null) {
            this.renderOrder = renderOrder;
        }
        return (T)this;
    }

    public T setDialoguesInfo(ResourceLocation dialoguesResourceLocation, String group, Integer index) {
        if (dialoguesResourceLocation != null && group != null && index != null) {
            this.dialoguesResourceLocation = dialoguesResourceLocation;
            this.group = group;
            this.index = index;
        }
        return (T)this;
    }

    public T setIndex(int index) {
        this.index = index;
        return (T)this;
    }

    public T build() {
        return (T)this;
    }

    protected boolean checkSize(float value) {
        return value >= 0.0f;
    }

    protected Vec2 getCurrentPosition() {
        return new Vec2(this.alignX.getPositionX(this), this.alignY.getPositionY(this));
    }

    protected void renderImage(GuiGraphics guiGraphics, ResourceLocation texture) {
        this.renderImage(guiGraphics, texture, Float.valueOf(1.0f));
    }

    protected void renderImage(GuiGraphics guiGraphics, ResourceLocation texture, Float scale) {
        RenderUtil.renderOpacity(guiGraphics, this.opacity.floatValue() / 100.0f, () -> {
            Vec2 position = this.getCurrentPosition();
            RenderUtil.renderImage(guiGraphics, texture, AbstractComponent.getResponsiveWidth(position.f_82470_), AbstractComponent.getResponsiveHeight(position.f_82471_), 0.0f, AbstractComponent.getResponsiveWidth(this.width), AbstractComponent.getResponsiveHeight(this.height), scale.floatValue());
        });
    }

    public boolean isSelect(float width, float height, float x, float y, double mouseX, double mouseY) {
        return mouseX > (double)x && mouseX < (double)(x + width) && mouseY > (double)y && mouseY < (double)(y + height);
    }

    public boolean isSelect(double mouseX, double mouseY) {
        Vec2 position = this.getCurrentPosition();
        return this.isSelect(AbstractComponent.getResponsiveWidth(this.width), AbstractComponent.getResponsiveHeight(this.height), AbstractComponent.getResponsiveWidth((int)position.f_82470_), AbstractComponent.getResponsiveHeight((int)position.f_82471_), mouseX, mouseY);
    }

    protected String parseText(String input) {
        return ChatBoxUtil.parseText(input, false);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTick) {
    }

    public void render(GuiGraphics guiGraphics, float pPartialTick) {
        this.render(guiGraphics, 0, 0, pPartialTick);
    }

    public static enum AlignX {
        LEFT,
        CENTER,
        RIGHT;


        public static AlignX of(String value) {
            if (value == null) {
                return LEFT;
            }
            return AlignX.valueOf(value.toUpperCase());
        }

        public float getPositionX(AbstractComponent<?> abstractComponent) {
            float x = abstractComponent.x;
            float width = abstractComponent.width;
            return switch (abstractComponent.alignX) {
                default -> throw new IncompatibleClassChangeError();
                case LEFT -> x;
                case CENTER -> x + 50.0f - width / 2.0f;
                case RIGHT -> x + 100.0f - width;
            };
        }
    }

    public static enum AlignY {
        TOP,
        CENTER,
        BOTTOM;


        public static AlignY of(String value) {
            if (value == null) {
                return TOP;
            }
            return AlignY.valueOf(value.toUpperCase());
        }

        public float getPositionY(AbstractComponent<?> abstractComponent) {
            float y = abstractComponent.y;
            float height = abstractComponent.height;
            return switch (abstractComponent.alignY) {
                default -> throw new IncompatibleClassChangeError();
                case TOP -> y;
                case CENTER -> y + 50.0f - height / 2.0f;
                case BOTTOM -> y + 100.0f - height;
            };
        }
    }
}

