/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.network.c2s.SendCommandPayload;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.chatbox.RenderUtil;
import com.zhenshiz.chatbox.utils.common.StrUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;

public class ChatOption
extends AbstractComponent<ChatOption> {
    public ResourceLocation texture;
    public ResourceLocation selectTexture;
    public ResourceLocation lockTexture;
    public Component optionChat;
    public float optionChatX;
    public float optionChatY;
    public Runnable onClickEvent;
    public boolean isLock;
    public Component optionTooltip;
    public TextAlign textAlign;
    public String next;
    public boolean isSelect;

    public ChatOption() {
        this.setTextures(ChatBox.ResourceLocationMod("textures/options/default_no_checked_option.png"));
        this.setSelectTexture(ChatBox.ResourceLocationMod("textures/options/default_checked_option.png"));
        this.setLockTexture(ChatBox.ResourceLocationMod("textures/options/default_no_checked_option.png"));
        this.setOptionChat("", false);
        this.setOptionChatPosition(0.0f, 0.0f);
        this.setClickEvent(() -> {});
        this.setIsLock(false);
        this.setOptionTooltip("", false);
        this.setTextAlign(TextAlign.LEFT);
        this.setNext("");
        this.defaultOption();
        this.setIsSelect(false);
    }

    public ChatOption setOptionChat(String optionChat, boolean isTranslatable) {
        if (optionChat != null) {
            this.optionChat = isTranslatable ? Component.m_237115_((String)optionChat) : Component.m_130674_((String)optionChat);
        }
        return this;
    }

    public ChatOption setOptionTooltip(String optionTooltip, boolean isTranslatable) {
        if (optionTooltip != null) {
            this.optionTooltip = isTranslatable ? Component.m_237115_((String)optionTooltip) : Component.m_130674_((String)optionTooltip);
        }
        return this;
    }

    public ChatOption setTextures(ResourceLocation textures) {
        if (textures != null) {
            this.texture = textures;
        }
        return this;
    }

    public ChatOption setTextures(String textures) {
        if (textures != null) {
            return this.setTextures(ResourceLocation.m_135820_((String)textures));
        }
        return this;
    }

    public ChatOption setSelectTexture(ResourceLocation selectTexture) {
        if (selectTexture != null) {
            this.selectTexture = selectTexture;
        }
        return this;
    }

    public ChatOption setSelectTexture(String selectTexture) {
        if (selectTexture != null) {
            return this.setSelectTexture(ResourceLocation.m_135820_((String)selectTexture));
        }
        return this;
    }

    public ChatOption setLockTexture(ResourceLocation lockTexture) {
        if (lockTexture != null) {
            this.lockTexture = lockTexture;
        }
        return this;
    }

    public ChatOption setLockTexture(String lockTexture) {
        if (lockTexture != null) {
            return this.setLockTexture(ResourceLocation.m_135820_((String)lockTexture));
        }
        return this;
    }

    public ChatOption setClickEvent(Runnable onClickEvent) {
        if (onClickEvent != null) {
            this.onClickEvent = onClickEvent;
        }
        return this;
    }

    public ChatOption setClickEvent(String type, String value) {
        if (type != null && value != null) {
            this.onClickEvent = () -> {
                if (ChatOption.minecraft.f_91074_ != null && type.equals("command")) {
                    String[] commands;
                    for (String command : commands = value.split(";")) {
                        if ((command = command.trim()).isBlank()) continue;
                        ChatBox.PLATFORM.sendToServer(new SendCommandPayload(command));
                    }
                }
            };
        }
        return this;
    }

    public ChatOption setIsLock(boolean isLock) {
        this.isLock = isLock;
        return this;
    }

    public ChatOption setNext(String next) {
        if (next != null) {
            this.next = next;
        }
        return this;
    }

    public ChatOption setOptionChatPosition(float x, float y) {
        this.optionChatX = x;
        this.optionChatY = y;
        return this;
    }

    public ChatOption setTextAlign(TextAlign textAlign) {
        if (textAlign != null) {
            this.textAlign = textAlign;
        }
        return this;
    }

    public ChatOption setIsSelect(boolean isSelect) {
        this.isSelect = isSelect;
        return this;
    }

    public void click() {
        if (!this.isLock && ChatOption.minecraft.f_91074_ != null) {
            this.onClickEvent.run();
            if (StrUtil.isEmpty(this.next)) {
                ChatBoxUtil.skipDialogues(this.dialoguesResourceLocation, this.group, this.index + 1);
            } else if (StrUtil.isInteger(this.next)) {
                int index = Integer.parseInt(this.next);
                ChatBoxUtil.skipDialogues(this.dialoguesResourceLocation, this.group, index);
            } else {
                ChatBoxUtil.skipDialogues(this.dialoguesResourceLocation, this.next);
            }
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTick) {
        Vec2 pos = this.getCurrentPosition();
        float x = pos.f_82470_;
        float y = pos.f_82471_;
        int color = -1;
        ResourceLocation texture = this.texture;
        if (this.isLock) {
            texture = this.lockTexture;
            color = -6250336;
        } else if (this.isSelect(mouseX, mouseY)) {
            texture = this.selectTexture;
            color = -256;
        }
        this.renderInCommon(guiGraphics, texture, color, x, y);
        if (!this.optionTooltip.getString().isEmpty() && this.isSelect(mouseX, mouseY)) {
            guiGraphics.m_280557_(ChatOption.minecraft.f_91062_, this.optionTooltip, mouseX, mouseY);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, float pPartialTick) {
        Vec2 pos = this.getCurrentPosition();
        float x = pos.f_82470_;
        float y = pos.f_82471_;
        int color = -1;
        ResourceLocation texture = this.texture;
        if (this.isLock) {
            texture = this.lockTexture;
            color = -6250336;
        } else if (this.isSelect) {
            texture = this.selectTexture;
            color = -256;
        }
        this.renderInCommon(guiGraphics, texture, color, x, y);
    }

    private void renderInCommon(GuiGraphics guiGraphics, ResourceLocation texture, int color, float x, float y) {
        if (texture != null) {
            this.renderImage(guiGraphics, texture);
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        switch (this.textAlign) {
            case LEFT: {
                RenderUtil.drawLeftScaleText(guiGraphics, Component.m_130674_((String)this.parseText(this.optionChat.getString())), (int)ChatOption.getResponsiveWidth(x + this.width / 2.0f + this.optionChatX), (int)ChatOption.getResponsiveHeight(y + this.height / 2.0f + this.optionChatY), 1.0f, false, color);
                break;
            }
            case CENTER: {
                RenderUtil.drawCenterScaleText(guiGraphics, Component.m_130674_((String)this.parseText(this.optionChat.getString())), (int)ChatOption.getResponsiveWidth(x + this.width / 2.0f + this.optionChatX), (int)ChatOption.getResponsiveHeight(y + this.height / 2.0f + this.optionChatY), 1.0f, false, color);
                break;
            }
            case RIGHT: {
                RenderUtil.drawRightScaleText(guiGraphics, Component.m_130674_((String)this.parseText(this.optionChat.getString())), (int)ChatOption.getResponsiveWidth(x + this.width / 2.0f + this.optionChatX), (int)ChatOption.getResponsiveHeight(y + this.height / 2.0f + this.optionChatY), 1.0f, false, color);
            }
        }
        poseStack.m_85849_();
    }

    public static enum TextAlign {
        LEFT,
        CENTER,
        RIGHT;


        public static TextAlign of(String text) {
            if (text == null) {
                return LEFT;
            }
            return TextAlign.valueOf(text.toUpperCase());
        }
    }
}

