/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.common.StrUtil;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;

public class DialogBox
extends AbstractComponent<DialogBox> {
    public ResourceLocation texture;
    public Component text;
    public float textX;
    public float textY;
    public Component name;
    public float nameX;
    public float nameY;
    public float lineWidth;
    public boolean isAllOver;
    public int tickCount;
    private String[] textBuffer;

    public DialogBox() {
        this.setTexture(ChatBox.ResourceLocationMod("textures/chatbox/default_dialog_box.png"));
        this.setText("", false);
        this.setTextPosition(0.0f, 0.0f);
        this.setName("", false);
        this.setNamePosition(0.0f, 0.0f);
        this.setLineWidth(Float.valueOf(100.0f));
        this.setAllOver(false);
        this.resetTickCount();
        this.textBuffer = new String[]{""};
        this.defaultOption();
    }

    public DialogBox setTexture(ResourceLocation texture) {
        if (texture != null) {
            this.texture = texture;
        }
        return this;
    }

    public DialogBox setTexture(String texture) {
        if (texture != null) {
            return this.setTexture(ResourceLocation.m_135820_((String)texture));
        }
        return this;
    }

    public DialogBox setText(String text, boolean isTranslatable) {
        if (text != null) {
            this.text = isTranslatable ? Component.m_237115_((String)text) : Component.m_130674_((String)text);
            this.textToTextBuffer();
        }
        return this;
    }

    public DialogBox setName(String name, boolean isTranslatable) {
        if (name != null) {
            this.name = isTranslatable ? Component.m_237115_((String)name) : Component.m_130674_((String)name);
        }
        return this;
    }

    public DialogBox setNamePosition(float x, float y) {
        this.nameX = x;
        this.nameY = y;
        return this;
    }

    public DialogBox setTextPosition(float x, float y) {
        this.textX = x;
        this.textY = y;
        return this;
    }

    public DialogBox setLineWidth(Float lineWidth) {
        if (this.checkSize(lineWidth.floatValue())) {
            this.lineWidth = lineWidth.floatValue();
        }
        return this;
    }

    public DialogBox setAllOver(boolean allOver) {
        this.isAllOver = allOver;
        return this;
    }

    public DialogBox resetTickCount() {
        this.tickCount = 0;
        return this;
    }

    private void textToTextBuffer() {
        String input = this.text.getString();
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int index = 0; index < input.length(); ++index) {
            char c = input.charAt(index);
            stringBuilder.append(c);
            if (c == '\\' || c == '\u00a7') {
                stringBuilder.append(input.charAt(index + 1));
                ++index;
            }
            result.add(stringBuilder.toString());
        }
        this.textBuffer = result.toArray(new String[0]);
    }

    public void click(boolean gotoNext) {
        if (!this.isAllOver) {
            this.tickCount = this.textBuffer.length - 1;
            this.setAllOver(true);
        } else if (gotoNext && DialogBox.minecraft.f_91074_ != null) {
            this.setIndex(this.index + 1);
            ChatBoxUtil.skipDialogues(this.dialoguesResourceLocation, this.group, this.index);
            ChatBoxUtil.chatBoxScreen.tickAutoPlay = 20;
        }
    }

    public void tick() {
        if (!this.isAllOver) {
            if (this.tickCount == this.textBuffer.length - 1) {
                this.setAllOver(true);
                return;
            }
            ++this.tickCount;
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTick) {
        if (this.texture != null) {
            this.renderImage(guiGraphics, this.texture);
        }
        Vec2 position = this.getCurrentPosition();
        float x = position.f_82470_;
        float y = position.f_82471_;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        if (StrUtil.isNotEmpty(this.name.getString())) {
            guiGraphics.m_280554_(DialogBox.minecraft.f_91062_, (FormattedText)Component.m_130674_((String)this.parseText(StrUtil.format("[{}]", this.name.getString()))), (int)DialogBox.getResponsiveWidth(x + this.nameX), (int)DialogBox.getResponsiveHeight(y + this.nameY), (int)DialogBox.getResponsiveWidth(this.lineWidth), -1);
        }
        if (StrUtil.isNotEmpty(this.text.getString())) {
            guiGraphics.m_280554_(DialogBox.minecraft.f_91062_, (FormattedText)Component.m_130674_((String)this.parseText(this.textBuffer[this.tickCount])), (int)DialogBox.getResponsiveWidth(x + this.textX), (int)DialogBox.getResponsiveHeight(y + this.textY), (int)DialogBox.getResponsiveWidth(this.lineWidth), -1);
        }
        poseStack.m_85849_();
    }
}

