/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zhenshiz.chatbox.client.ChatBoxClient;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.common.StrUtil;
import com.zhenshiz.chatbox.utils.math.Clamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector4i;

public class HistoricalDialogue
extends AbstractWidget {
    public List<HistoricalInfo> historicalInfos = new ArrayList<HistoricalInfo>();
    private float yOffset = 0.0f;
    private float verticalScrollAmount = 0.0f;
    private static final Minecraft minecraft = Minecraft.m_91087_();

    public HistoricalDialogue(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.m_237119_());
    }

    public HistoricalDialogue addHistoricalInfo(HistoricalInfo historicalInfo) {
        if (historicalInfo != null) {
            this.historicalInfos.add(historicalInfo);
        }
        return this;
    }

    public HistoricalDialogue setHistoricalInfo(List<HistoricalInfo> historicalInfos) {
        if (historicalInfos != null) {
            this.historicalInfos = historicalInfos;
        }
        return this;
    }

    protected void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        Objects.requireNonNull(HistoricalDialogue.minecraft.f_91062_);
        this.yOffset = Clamp.clamp(this.yOffset + this.verticalScrollAmount * delta, this.f_93619_ - 30 - (9 + 27) * this.historicalInfos.size(), this.f_93619_ - 30);
        this.verticalScrollAmount = this.verticalScrollAmount > 0.0f ? Clamp.clamp(this.verticalScrollAmount - delta * 3.0f, 0.0f, Float.MAX_VALUE) : Clamp.clamp(this.verticalScrollAmount + delta * 3.0f, -3.4028235E38f, 0.0f);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 27.0f + this.yOffset, 0.0f);
        for (HistoricalInfo historicalInfo : this.historicalInfos) {
            historicalInfo.render(this, guiGraphics, mouseX, mouseY, delta);
            Objects.requireNonNull(HistoricalDialogue.minecraft.f_91062_);
            poseStack.m_252880_(0.0f, (float)(9 + 27), 0.0f);
        }
        poseStack.m_85849_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        float direction = (float)Math.signum(delta);
        float baseSpeed = ChatBoxClient.conf.historicalScrollSpeed;
        this.verticalScrollAmount = direction * baseSpeed;
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && ChatBoxUtil.chatBoxScreen.isHistoricalSkip.booleanValue()) {
            for (HistoricalInfo historicalInfo : this.historicalInfos) {
                if (!historicalInfo.isMouseInRect(mouseX, mouseY)) continue;
                int i = this.historicalInfos.indexOf(historicalInfo);
                this.historicalInfos = this.historicalInfos.subList(0, i);
                historicalInfo.click();
                return super.m_6375_(mouseX, mouseY, button);
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_168797_(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    public static class HistoricalInfo {
        public Component name = CommonComponents.f_237098_;
        public Component text = CommonComponents.f_237098_;
        public ResourceLocation resourceLocation;
        public String group;
        public int index;
        private Vector4i vector4i;
        private float progress;

        public HistoricalInfo(ResourceLocation resourceLocation, String group, int index) {
            this.resourceLocation = resourceLocation;
            this.group = group;
            this.index = index;
        }

        public HistoricalInfo setName(String name, boolean isTranslatable) {
            if (name != null) {
                this.name = isTranslatable ? Component.m_237115_((String)name) : Component.m_130674_((String)name);
            }
            return this;
        }

        public HistoricalInfo setText(String text, boolean isTranslatable) {
            if (text != null) {
                this.text = isTranslatable ? Component.m_237115_((String)text) : Component.m_130674_((String)text);
            }
            return this;
        }

        private void render(HistoricalDialogue historicalDialogue, GuiGraphics guiGraphics, double mouseX, double mouseY, float delta) {
            this.vector4i = this.createEntryAbsoluteRect(guiGraphics);
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)historicalDialogue.f_93618_ * -0.025f * this.progress, 0.0f, 0.0f);
            poseStack.m_85841_(1.0f + 0.05f * this.progress, 1.0f + 0.05f * this.progress, 1.0f + 0.05f * this.progress);
            Vector4i relativelyRect = this.createEntryRelativelyRect();
            Font font = Minecraft.m_91087_().f_91062_;
            boolean inRect = this.isMouseInRect(mouseX, mouseY);
            this.progress = Clamp.clamp(this.progress + (inRect ? delta * 0.5f : -delta * 0.5f), 0.0f, 1.0f);
            guiGraphics.m_280509_(relativelyRect.x, relativelyRect.y, relativelyRect.z, relativelyRect.w, this.getBackgroundColor());
            int lineBreak = Minecraft.m_91087_().m_91268_().m_85445_() / 7 * 5;
            guiGraphics.m_280554_(font, (FormattedText)Component.m_130674_((String)StrUtil.maxLength(ChatBoxUtil.parseText(this.name.getString(), true), 60)), relativelyRect.x + 3, -5, lineBreak, -1);
            guiGraphics.m_280554_(font, (FormattedText)Component.m_130674_((String)StrUtil.maxLength(ChatBoxUtil.parseText(this.text.getString(), true), 60)), relativelyRect.x + 3, 8, lineBreak, -1);
            poseStack.m_85849_();
        }

        public void click() {
            ChatBoxUtil.skipDialogues(this.resourceLocation, this.group, this.index);
        }

        public boolean isMouseInRect(double mouseX, double mouseY) {
            return (double)this.vector4i.x <= mouseX && mouseX <= (double)this.vector4i.z && (double)this.vector4i.y <= mouseY && mouseY <= (double)this.vector4i.w;
        }

        public Vector4i createEntryAbsoluteRect(GuiGraphics guiGraphics) {
            int y = (int)guiGraphics.m_280168_().m_85850_().m_252922_().m31();
            return this.createEntryRelativelyRect().add(0, y, 0, y);
        }

        private Vector4i createEntryRelativelyRect() {
            int width = Minecraft.m_91087_().m_91268_().m_85445_();
            int n = width / 7;
            int n2 = width / 7 * 6;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            return new Vector4i(n, -7, n2, 20 + 9);
        }

        private int getBackgroundColor() {
            return (int)(34.0f + 102.0f * this.progress) << 24 | 0xFFFFFF;
        }
    }
}

