/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.component;

import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.data.ChatBoxTheme;
import com.zhenshiz.chatbox.utils.chatbox.RenderUtil;
import com.zhenshiz.chatbox.utils.common.CollUtil;
import com.zhenshiz.chatbox.utils.math.EasingUtil;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;

public class Portrait
extends AbstractComponent<Portrait> {
    public Type type;
    public String value;
    public AnimationType animationType;
    public EasingUtil.Easing easing;
    public Float scale;
    public Integer customItemData;
    public List<ChatBoxTheme.Portrait.CustomAnimation> customAnimation;
    public Boolean loop;
    private final ChatBoxTheme.Portrait.CustomAnimation targetCustomAnimation = new ChatBoxTheme.Portrait.CustomAnimation();
    private final ChatBoxTheme.Portrait.CustomAnimation startCustomAnimation = new ChatBoxTheme.Portrait.CustomAnimation();
    private boolean isAnimation = false;
    private int currentAnimationTick = 0;
    private int durationAnimationTick = 20;
    private int customAnimationIndex = 0;

    public Portrait(Type type, List<ChatBoxTheme.Portrait.CustomAnimation> customAnimation, Float scale, Boolean loop) {
        this.setType(type).setCustomAnimation(customAnimation).setLoop(loop).setScale(scale).build();
        this.defaultOption();
    }

    public Portrait createTexture(Portrait portrait, String value, String animationType, String easing, Integer duration) {
        return portrait.setValue(value).setAnimationType(animationType).setEasing(easing).setDurationAnimationTick(duration);
    }

    public Portrait createPlayerHead(Portrait portrait, String value) {
        return portrait.setValue(value);
    }

    public Portrait createItem(Portrait portrait, String value, Integer customItemData) {
        return portrait.setValue(value).setCustomItemData(customItemData);
    }

    public Portrait setScale(Float scale) {
        if (scale != null) {
            this.scale = scale;
        }
        return this;
    }

    public Portrait setType(Type type) {
        if (type != null) {
            this.type = type;
        }
        return this;
    }

    public Portrait setValue(String value) {
        if (value != null) {
            this.value = value;
        }
        return this;
    }

    public Portrait setCustomItemData(Integer customItemData) {
        if (customItemData != null) {
            this.customItemData = customItemData;
        }
        return this;
    }

    public Portrait setAnimationType(AnimationType animationType) {
        if (animationType != null) {
            this.animationType = animationType;
        }
        return this;
    }

    public Portrait setAnimationType(String animationType) {
        if (animationType != null) {
            return this.setAnimationType(AnimationType.of(animationType));
        }
        return this;
    }

    public Portrait setIsAnimation(Boolean isAnimation) {
        if (isAnimation != null) {
            this.isAnimation = isAnimation;
        }
        return this;
    }

    public Portrait setCustomAnimation(List<ChatBoxTheme.Portrait.CustomAnimation> customAnimation) {
        if (!CollUtil.isEmpty(customAnimation).booleanValue()) {
            this.customAnimation = customAnimation;
        }
        return this;
    }

    public Portrait setLoop(Boolean loop) {
        if (loop != null) {
            this.loop = loop;
        }
        return this;
    }

    public void resetCurrentAnimationTick() {
        this.currentAnimationTick = 0;
    }

    public void setCustomAnimationIndex(Integer customAnimationIndex) {
        if (customAnimationIndex != null) {
            this.customAnimationIndex = customAnimationIndex;
        }
    }

    public Portrait setDurationAnimationTick(Integer durationAnimationTick) {
        if (durationAnimationTick != null) {
            this.durationAnimationTick = durationAnimationTick;
        }
        return this;
    }

    public Portrait setEasing(EasingUtil.Easing easing) {
        if (easing != null) {
            this.easing = easing;
        }
        return this;
    }

    public Portrait setEasing(String easing) {
        if (easing != null) {
            return this.setEasing(EasingUtil.Easing.of(easing));
        }
        return this;
    }

    public void setTarget() {
        this.targetCustomAnimation.y = Float.valueOf(this.y);
        this.targetCustomAnimation.opacity = this.opacity;
    }

    public void setTarget(float x, float y, float scale, float opacity) {
        this.targetCustomAnimation.x = Float.valueOf(x);
        this.targetCustomAnimation.y = Float.valueOf(y);
        this.targetCustomAnimation.scale = Float.valueOf(scale);
        this.targetCustomAnimation.opacity = Float.valueOf(opacity);
    }

    public void setStart(float x, float y, float scale, float opacity) {
        this.startCustomAnimation.x = Float.valueOf(x);
        this.startCustomAnimation.y = Float.valueOf(y);
        this.startCustomAnimation.scale = Float.valueOf(scale);
        this.startCustomAnimation.opacity = Float.valueOf(opacity);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTick) {
        if (this.type != null && this.value != null) {
            Vec2 position = this.getCurrentPosition();
            float x = position.f_82470_;
            float y = position.f_82471_;
            if (this.isAnimation) {
                ++this.currentAnimationTick;
            }
            switch (this.type) {
                case TEXTURE: {
                    if (this.isAnimation) {
                        switch (this.animationType) {
                            case FADE_IN: {
                                this.setOpacity(Float.valueOf(EasingUtil.easingFunction(0.0f, this.targetCustomAnimation.opacity.floatValue(), this.currentAnimationTick, this.durationAnimationTick, this.easing)));
                                if (this.currentAnimationTick != this.durationAnimationTick) break;
                                this.setIsAnimation(false);
                                break;
                            }
                            case SLIDE_IN_FROM_BOTTOM: {
                                this.setPosition(this.x, EasingUtil.easingFunction(this.targetCustomAnimation.y.floatValue(), 0.0f, this.currentAnimationTick, this.durationAnimationTick, this.easing));
                                if (this.currentAnimationTick != this.durationAnimationTick) break;
                                this.setIsAnimation(false);
                                break;
                            }
                            case BOUNCE: {
                                int offset = 5;
                                if (this.currentAnimationTick >= this.durationAnimationTick / 2) {
                                    this.setPosition(this.x, EasingUtil.easingFunction(this.targetCustomAnimation.y.floatValue(), this.targetCustomAnimation.y.floatValue() + (float)offset, this.currentAnimationTick, this.durationAnimationTick, this.easing));
                                } else {
                                    this.setPosition(this.x, EasingUtil.easingFunction(this.targetCustomAnimation.y.floatValue() + (float)offset, this.targetCustomAnimation.y.floatValue(), this.currentAnimationTick, this.durationAnimationTick, this.easing));
                                }
                                if (this.currentAnimationTick != this.durationAnimationTick) break;
                                this.setIsAnimation(false);
                                break;
                            }
                            case CUSTOM: {
                                this.execCustomAnimation();
                            }
                        }
                    }
                    this.renderImage(guiGraphics, new ResourceLocation(this.value), Portrait.getValueOrDefault(this.scale, Float.valueOf(1.0f)));
                    break;
                }
                case PLAYER_HEAD: {
                    if (this.isAnimation) {
                        this.execCustomAnimation();
                    }
                    RenderUtil.renderOpacity(guiGraphics, this.opacity.floatValue() / 100.0f, () -> RenderUtil.renderPlayerHead(guiGraphics, this.parseText(this.value), (int)Portrait.getResponsiveWidth(x), (int)Portrait.getResponsiveHeight(y), (int)(Portrait.getResponsiveWidth(this.width) + Portrait.getResponsiveHeight(this.height)), Portrait.getValueOrDefault(this.scale, Float.valueOf(1.0f)).floatValue()));
                    break;
                }
                case ITEM: {
                    if (this.isAnimation) {
                        this.execCustomAnimation();
                    }
                    ItemStack itemStack = ((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(this.value))).m_7968_();
                    if (this.customItemData != null) {
                        CompoundTag tag = itemStack.m_41784_();
                        tag.m_128405_("CustomModelData", this.customItemData.intValue());
                        itemStack.m_41751_(tag);
                    }
                    RenderUtil.renderOpacity(guiGraphics, this.opacity.floatValue() / 100.0f, () -> RenderUtil.renderItem(guiGraphics, itemStack, (int)Portrait.getResponsiveWidth(x), (int)Portrait.getResponsiveHeight(y), this.scale.floatValue()));
                }
            }
        }
    }

    private void execCustomAnimation() {
        if (this.customAnimationIndex == this.customAnimation.size()) {
            if (this.loop.booleanValue()) {
                this.setCustomAnimationIndex(0);
                this.setTarget(this.startCustomAnimation.x.floatValue(), this.startCustomAnimation.y.floatValue(), this.startCustomAnimation.scale.floatValue(), this.startCustomAnimation.opacity.floatValue());
            } else {
                this.setIsAnimation(false);
                return;
            }
        }
        ChatBoxTheme.Portrait.CustomAnimation customAnimation = this.customAnimation.get(this.customAnimationIndex);
        if (this.type.equals((Object)Type.TEXTURE)) {
            this.setValue(customAnimation.texture);
        }
        this.setPosition(EasingUtil.easingFunction(this.targetCustomAnimation.x.floatValue(), customAnimation.x.floatValue(), this.currentAnimationTick, customAnimation.time.intValue(), customAnimation.easing), EasingUtil.easingFunction(this.targetCustomAnimation.y.floatValue(), customAnimation.y.floatValue(), this.currentAnimationTick, customAnimation.time.intValue(), customAnimation.easing));
        this.setScale(Float.valueOf(EasingUtil.easingFunction(this.targetCustomAnimation.scale.floatValue(), customAnimation.scale.floatValue(), this.currentAnimationTick, customAnimation.time.intValue(), customAnimation.easing)));
        this.setOpacity(Float.valueOf(EasingUtil.easingFunction(this.targetCustomAnimation.opacity.floatValue(), customAnimation.opacity.floatValue(), this.currentAnimationTick, customAnimation.time.intValue(), customAnimation.easing)));
        if (this.currentAnimationTick == customAnimation.time) {
            this.setTarget(this.x, this.y, this.scale.floatValue(), this.opacity.floatValue());
            this.setCustomAnimationIndex(this.customAnimationIndex + 1);
            this.resetCurrentAnimationTick();
        }
    }

    public Portrait() {
    }

    public static enum Type {
        TEXTURE,
        PLAYER_HEAD,
        ITEM;


        public static Type of(String type) {
            return Type.valueOf(type.toUpperCase());
        }
    }

    public static enum AnimationType {
        NONE,
        FADE_IN,
        SLIDE_IN_FROM_BOTTOM,
        BOUNCE,
        CUSTOM;


        public static AnimationType of(String type) {
            return AnimationType.valueOf(type.toUpperCase());
        }
    }
}

