/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.data;

import com.google.gson.JsonElement;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.component.ChatOption;
import com.zhenshiz.chatbox.component.DialogBox;
import com.zhenshiz.chatbox.component.Portrait;
import com.zhenshiz.chatbox.component.Video;
import com.zhenshiz.chatbox.data.ChatBoxTheme;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.common.BeanUtil;
import com.zhenshiz.chatbox.utils.common.CollUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;

public class ChatBoxDialogues {
    private static final Boolean DEFAULT_BOOL = false;
    public Map<String, List<Dialogues>> dialogues = new HashMap<String, List<Dialogues>>();
    public Boolean isTranslatable;
    public Boolean isEsc;
    public Boolean isPause;
    public Boolean isHistoricalSkip;
    public String theme;

    public void setDefaultValue(ResourceLocation resourceLocation) {
        for (Map.Entry<String, List<Dialogues>> entry : this.dialogues.entrySet()) {
            int index = 0;
            entry.getValue().forEach(dialogues -> dialogues.setDefaultValue(resourceLocation, (String)entry.getKey(), index));
        }
        this.isTranslatable = BeanUtil.getValueOrDefault(this.isTranslatable, false);
        this.isEsc = BeanUtil.getValueOrDefault(this.isEsc, true);
        this.isPause = BeanUtil.getValueOrDefault(this.isPause, true);
        this.isHistoricalSkip = BeanUtil.getValueOrDefault(this.isHistoricalSkip, true);
    }

    public static class Dialogues {
        public DialogBox dialogBox;
        public List<JsonElement> portrait;
        public List<Option> options;
        public String sound;
        public Float volume;
        public Float pitch;
        public String command;
        public String backgroundImage;
        public Video video;

        public static List<Portrait> setPortraitDialogues(List<Object> portraits, ChatBoxTheme theme) {
            Map<String, ChatBoxTheme.Portrait> map = theme.portrait;
            ArrayList<Portrait> portraitList = new ArrayList<Portrait>();
            if (map != null && !map.isEmpty()) {
                portraits.forEach(p -> {
                    Portrait portrait = null;
                    if (p instanceof String) {
                        try {
                            portrait = (Portrait)((ChatBoxTheme.Portrait)map.get(p)).setPortraitTheme().build();
                        }
                        catch (Exception e) {
                            ChatBox.LOGGER.error("portrait {} not found", p);
                        }
                    } else if (p instanceof ReplacePortrait) {
                        ReplacePortrait replacePortrait = (ReplacePortrait)p;
                        try {
                            portrait = (Portrait)replacePortrait.replace((ChatBoxTheme.Portrait)map.get(replacePortrait.id)).setPortraitTheme().build();
                        }
                        catch (Exception e) {
                            ChatBox.LOGGER.error("portrait {} not found", (Object)replacePortrait.id);
                        }
                    }
                    if (portrait != null) {
                        if (!CollUtil.isEmpty(portrait.customAnimation).booleanValue()) {
                            BeanUtil.copyPropertiesIfTargetNull(new ChatBoxTheme.Portrait.CustomAnimation(Float.valueOf(portrait.x), Float.valueOf(portrait.y), BeanUtil.getValueOrDefault(portrait.scale, Float.valueOf(1.0f)), portrait.opacity), portrait.customAnimation.get(0));
                            if (portrait.customAnimation.size() > 1) {
                                for (int i = 1; i < portrait.customAnimation.size(); ++i) {
                                    BeanUtil.copyPropertiesIfTargetNull(portrait.customAnimation.get(i - 1), portrait.customAnimation.get(i));
                                }
                            }
                            portrait.setIsAnimation(true).setTarget(portrait.x, portrait.y, BeanUtil.getValueOrDefault(portrait.scale, Float.valueOf(1.0f)).floatValue(), portrait.opacity.floatValue());
                            if (portrait.loop.booleanValue()) {
                                portrait.setStart(portrait.x, portrait.y, BeanUtil.getValueOrDefault(portrait.scale, Float.valueOf(1.0f)).floatValue(), portrait.opacity.floatValue());
                            }
                        } else if (portrait.type.equals((Object)Portrait.Type.TEXTURE) && !portrait.animationType.equals((Object)Portrait.AnimationType.CUSTOM)) {
                            portrait.setIsAnimation(true).setTarget();
                        }
                        portraitList.add(portrait);
                    }
                });
            }
            return portraitList;
        }

        public static List<Object> parsePortrait(List<JsonElement> jsonElements) {
            ArrayList<Object> portraitList = new ArrayList<Object>();
            for (JsonElement element : jsonElements) {
                if (element.isJsonPrimitive()) {
                    portraitList.add(element.getAsString());
                    continue;
                }
                if (!element.isJsonObject()) continue;
                ReplacePortrait obj = (ReplacePortrait)ChatBoxUtil.GSON.fromJson(element, ReplacePortrait.class);
                portraitList.add(obj);
            }
            return portraitList;
        }

        public void setDefaultValue(ResourceLocation resourceLocation, String group, int index) {
            this.sound = BeanUtil.getValueOrDefault(this.sound, "");
            this.volume = BeanUtil.getValueOrDefault(this.volume, Float.valueOf(1.0f));
            this.pitch = BeanUtil.getValueOrDefault(this.pitch, Float.valueOf(1.0f));
            this.dialogBox.dialoguesResourceLocation = resourceLocation;
            this.dialogBox.group = group;
            this.dialogBox.index = index;
            if (!CollUtil.isEmpty(this.options).booleanValue()) {
                for (Option option : this.options) {
                    option.isLock = BeanUtil.getValueOrDefault(option.isLock, DEFAULT_BOOL);
                    option.isHidden = BeanUtil.getValueOrDefault(option.isHidden, DEFAULT_BOOL);
                    option.dialoguesResourceLocation = resourceLocation;
                    option.group = group;
                    option.index = index;
                }
            }
        }

        public static class ReplacePortrait
        extends ChatBoxTheme.Portrait {
            public String id;

            public ChatBoxTheme.Portrait replace(ChatBoxTheme.Portrait portrait) {
                ChatBoxTheme.Portrait copy = new ChatBoxTheme.Portrait();
                BeanUtil.copyProperties(portrait, copy);
                BeanUtil.copyProperties(this, copy);
                return copy;
            }
        }

        public static class DialogBox {
            public String name;
            public String text;
            public ResourceLocation dialoguesResourceLocation;
            public String group;
            public Integer index;

            public com.zhenshiz.chatbox.component.DialogBox setDialogBoxDialogues(com.zhenshiz.chatbox.component.DialogBox dialogBox, int index, boolean isTranslatable) {
                this.index = index;
                return ((com.zhenshiz.chatbox.component.DialogBox)dialogBox.setName(this.name, isTranslatable).setText(this.text, isTranslatable).setDialoguesInfo(this.dialoguesResourceLocation, this.group, index)).resetTickCount();
            }
        }

        public static class Option {
            public String text;
            public Boolean isLock;
            public Condition lock = new Condition();
            public Condition hidden = new Condition();
            public Boolean isHidden;
            public String next;
            public Click click = new Click();
            public String tooltip;
            public ResourceLocation dialoguesResourceLocation;
            public String group;
            public Integer index;

            public static List<ChatOption> setChatOptionDialogues(ChatBoxTheme theme, ResourceLocation dialoguesResourceLocation, String group, int index, boolean isTranslatable) {
                List<Dialogues> chatBoxDialogues = ChatBoxUtil.dialoguesMap.get((Object)dialoguesResourceLocation).dialogues.get(group);
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                if (level != null) {
                    ArrayList<ChatOption> chatOptions = new ArrayList<ChatOption>();
                    if (index >= 0 && index < chatBoxDialogues.size()) {
                        Dialogues dialog = chatBoxDialogues.get(index);
                        int i = -1;
                        ChatBoxTheme.Option option = theme.option;
                        for (Option value : dialog.options) {
                            Scoreboard scoreboard = level.m_6188_();
                            Objective objective = scoreboard.m_83477_(value.hidden.objective);
                            Score scoreAccess = null;
                            if (objective != null) {
                                scoreAccess = scoreboard.m_83471_(value.hidden.value, objective);
                            }
                            if (value.isHidden.booleanValue() && (scoreAccess == null || scoreAccess.m_83400_() != 1)) continue;
                            ++i;
                            objective = scoreboard.m_83477_(value.lock.objective);
                            if (objective != null) {
                                scoreAccess = scoreboard.m_83471_(value.lock.value, objective);
                            }
                            ChatOption chatOption = (ChatOption)new ChatOption().setOptionTooltip(value.tooltip, isTranslatable).setOptionChat(value.text, isTranslatable).setIsLock(value.isLock != false && (scoreAccess == null || scoreAccess.m_83400_() != 1)).setNext(value.next).setClickEvent(value.click.type, value.click.value).setDialoguesInfo(dialoguesResourceLocation, group, index);
                            chatOptions.add(option.setChatOptionTheme(chatOption, i));
                        }
                    }
                    return chatOptions;
                }
                return new ArrayList<ChatOption>();
            }

            public static class Condition {
                public String objective;
                public String value;
            }

            public static class Click {
                public String type;
                public String value;
            }
        }

        public static class Video
        extends ChatBoxTheme.Component {
            public String path;
            public Boolean canControl;
            public Boolean canSkip;
            public Boolean loop;

            @Override
            public void setDefaultValue() {
                this.x = BeanUtil.getValueOrDefault(this.x, Float.valueOf(0.0f));
                this.y = BeanUtil.getValueOrDefault(this.y, Float.valueOf(0.0f));
                this.width = BeanUtil.getValueOrDefault(this.width, Float.valueOf(100.0f));
                this.height = BeanUtil.getValueOrDefault(this.height, Float.valueOf(100.0f));
                this.alignX = BeanUtil.getValueOrDefault(this.alignX, AbstractComponent.AlignX.LEFT.name());
                this.alignY = BeanUtil.getValueOrDefault(this.alignY, AbstractComponent.AlignY.TOP.name());
                this.opacity = BeanUtil.getValueOrDefault(this.opacity, Float.valueOf(100.0f));
                this.renderOrder = BeanUtil.getValueOrDefault(this.renderOrder, -1);
                this.canControl = BeanUtil.getValueOrDefault(this.canControl, true);
                this.canSkip = BeanUtil.getValueOrDefault(this.canSkip, true);
                this.loop = BeanUtil.getValueOrDefault(this.loop, false);
            }

            public com.zhenshiz.chatbox.component.Video setVideo() {
                if (!ChatBox.isWaterMediaLoaded()) {
                    return null;
                }
                this.setDefaultValue();
                Path gameDir = ChatBox.PLATFORM.getGameDirectory().toPath();
                File file = new File(gameDir.toString(), this.path);
                if (!file.exists()) {
                    file = new File(this.path);
                }
                if (!file.exists()) {
                    ChatBox.LOGGER.error("video {} not found", (Object)this.path);
                    return null;
                }
                return (com.zhenshiz.chatbox.component.Video)new com.zhenshiz.chatbox.component.Video(file.toURI(), this.canControl, this.canSkip, this.loop).setDefaultOption(this.x.floatValue(), this.y.floatValue(), this.width.floatValue(), this.height.floatValue(), AbstractComponent.AlignX.of(this.alignX), AbstractComponent.AlignY.of(this.alignY), this.opacity, this.renderOrder);
            }
        }
    }
}

